/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.test.StoreToStringServiceHolder;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StockEntryTest {
    private IModelService modelService;
    private IArticle article;
    private IArticle article1;
    private IStock stock;

    @Before
    public void before() {
        this.modelService = (IModelService)OsgiServiceUtil.getService(IModelService.class, (String)"(service.model.name=ch.elexis.core.model)").get();
        this.article = (IArticle)this.modelService.create(IArticle.class);
        this.article.setName("test article");
        this.article.setCode("123456789");
        this.article.setTyp(ArticleTyp.EIGENARTIKEL);
        this.article.setGtin("0000001111111");
        this.article.setPackageSize(12);
        this.article.setSellingSize(12);
        this.modelService.save((Identifiable)this.article);
        this.article1 = (IArticle)this.modelService.create(IArticle.class);
        this.article1.setName("test article 1");
        this.article1.setCode("987654321");
        this.article1.setTyp(ArticleTyp.EIGENARTIKEL);
        this.article1.setGtin("1111112222222");
        this.article1.setPackageSize(24);
        this.article1.setSellingSize(24);
        this.modelService.save((Identifiable)this.article1);
        this.stock = (IStock)this.modelService.create(IStock.class);
        this.stock.setCode("TST");
        this.stock.setPriority(5);
        this.modelService.save((Identifiable)this.stock);
    }

    @After
    public void after() {
        this.modelService.remove((Identifiable)this.article);
        this.modelService.remove((Identifiable)this.article1);
        this.modelService.remove((Identifiable)this.stock);
        OsgiServiceUtil.ungetService((Object)this.modelService);
        this.modelService = null;
    }

    @Test
    public void create() {
        IStockEntry entry = (IStockEntry)this.modelService.create(IStockEntry.class);
        Assert.assertNotNull((Object)entry);
        Assert.assertTrue((boolean)(entry instanceof IStockEntry));
        entry.setArticle(this.article);
        entry.setStock(this.stock);
        entry.setMinimumStock(2);
        entry.setCurrentStock(1);
        entry.setMaximumStock(5);
        this.modelService.save((Identifiable)entry);
        Optional loaded = this.modelService.load(entry.getId(), IStockEntry.class);
        Assert.assertTrue((boolean)loaded.isPresent());
        Assert.assertFalse((entry == loaded.get() ? 1 : 0) != 0);
        Assert.assertEquals((Object)entry, loaded.get());
        Assert.assertEquals((Object)entry.getArticle(), (Object)((IStockEntry)loaded.get()).getArticle());
        Assert.assertEquals((Object)entry.getStock(), (Object)((IStockEntry)loaded.get()).getStock());
        Assert.assertEquals((long)entry.getCurrentStock(), (long)((IStockEntry)loaded.get()).getCurrentStock());
        this.modelService.remove((Identifiable)entry);
    }

    @Test
    public void query() {
        IStockEntry entry = (IStockEntry)this.modelService.create(IStockEntry.class);
        entry.setArticle(this.article);
        entry.setStock(this.stock);
        entry.setMinimumStock(2);
        entry.setCurrentStock(1);
        entry.setMaximumStock(5);
        this.modelService.save((Identifiable)entry);
        IStockEntry entry1 = (IStockEntry)this.modelService.create(IStockEntry.class);
        entry1.setArticle(this.article1);
        entry1.setStock(this.stock);
        entry1.setMinimumStock(3);
        entry1.setCurrentStock(2);
        entry1.setMaximumStock(4);
        this.modelService.save((Identifiable)entry1);
        IQuery query = this.modelService.getQuery(IStockEntry.class);
        query.and((EStructuralFeature)ModelPackage.Literals.ISTOCK_ENTRY__STOCK, IQuery.COMPARATOR.EQUALS, (Object)this.stock);
        List existing = query.execute();
        Assert.assertEquals((long)2L, (long)existing.size());
        INamedQuery currentStock = this.modelService.getNamedQueryByName(Long.class, IStockEntry.class, "StockEntry_SumCurrentStock.articleId.articleType");
        String storeToString = StoreToStringServiceHolder.getStoreToString(this.article);
        String[] parts = storeToString.split("::");
        List results = currentStock.executeWithParameters(currentStock.getParameterMap(new Object[]{"articleId", parts[1], "articleType", parts[0]}));
        Assert.assertEquals((Object)((Long)results.get(0)), (Object)1L);
        this.modelService.remove((Identifiable)entry);
        this.modelService.remove((Identifiable)entry1);
    }
}

