/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.test.AbstractTest;
import ch.elexis.core.types.DocumentStatus;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentLetterTest
extends AbstractTest {
    private IContact contact1;
    private IPatient patient1;

    @Before
    public void before() {
        super.before();
        this.contact1 = (IContact)this.coreModelService.create(IContact.class);
        this.contact1.setDescription1("test contact 1");
        this.coreModelService.save((Identifiable)this.contact1);
        this.patient1 = (IPatient)this.coreModelService.create(IPatient.class);
        this.patient1.setDescription1("test patient 2");
        this.coreModelService.save((Identifiable)this.patient1);
    }

    @After
    public void after() {
        this.coreModelService.remove((Identifiable)this.contact1);
        this.coreModelService.remove((Identifiable)this.patient1);
        super.after();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void create() throws IOException {
        IDocumentLetter letter;
        block13: {
            letter = (IDocumentLetter)this.coreModelService.create(IDocumentLetter.class);
            Assert.assertNotNull((Object)letter);
            Assert.assertTrue((boolean)(letter instanceof IDocumentLetter));
            Assert.assertEquals(Collections.singletonList(DocumentStatus.NEW), (Object)letter.getStatus());
            letter.setDescription("test letter 1");
            letter.setAuthor(this.contact1);
            letter.setContent((InputStream)new ByteArrayInputStream("test content".getBytes()));
            this.coreModelService.save((Identifiable)letter);
            Optional loadedLetter = this.coreModelService.load(letter.getId(), IDocumentLetter.class);
            Assert.assertTrue((boolean)loadedLetter.isPresent());
            Assert.assertFalse((letter == loadedLetter.get() ? 1 : 0) != 0);
            Assert.assertEquals((Object)letter, loadedLetter.get());
            Assert.assertEquals((Object)letter.getDescription(), (Object)((IDocumentLetter)loadedLetter.get()).getDescription());
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                ByteArrayOutputStream contentByteArray = new ByteArrayOutputStream();
                try {
                    try (InputStream contentStream = letter.getContent();){
                        IOUtils.copy((InputStream)contentStream, (OutputStream)contentByteArray);
                        Assert.assertEquals((Object)"test content", (Object)new String(contentByteArray.toByteArray()));
                    }
                    if (contentByteArray == null) break block13;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (contentByteArray == null) throw throwable;
                    contentByteArray.close();
                    throw throwable;
                }
                contentByteArray.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        this.coreModelService.remove((Identifiable)letter);
    }

    @Test
    public void query() throws IOException {
        IDocumentLetter letter1 = (IDocumentLetter)this.coreModelService.create(IDocumentLetter.class);
        letter1.setDescription("test letter 1");
        letter1.setAuthor(this.contact1);
        letter1.setContent((InputStream)new ByteArrayInputStream("test content 1".getBytes()));
        this.coreModelService.save((Identifiable)letter1);
        IDocumentLetter letter2 = (IDocumentLetter)this.coreModelService.create(IDocumentLetter.class);
        letter2.setDescription("test letter 2");
        letter2.setAuthor(this.contact1);
        letter2.setPatient(this.patient1);
        letter2.setContent((InputStream)new ByteArrayInputStream("test content 2".getBytes()));
        this.coreModelService.save((Identifiable)letter2);
        IQuery query = this.coreModelService.getQuery(IDocumentLetter.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IDOCUMENT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)this.patient1);
        List existing = query.execute();
        Assert.assertNotNull((Object)existing);
        Assert.assertFalse((boolean)existing.isEmpty());
        Assert.assertFalse((letter2 == existing.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((Object)letter2, existing.get(0));
        Assert.assertEquals((Object)letter2.getDescription(), (Object)((IDocumentLetter)existing.get(0)).getDescription());
        IOUtils.contentEquals((InputStream)letter2.getContent(), (InputStream)((IDocumentLetter)existing.get(0)).getContent());
        this.coreModelService.remove((Identifiable)letter1);
        this.coreModelService.remove((Identifiable)letter2);
    }

    @Test
    public void storeAndReadExternal() throws IOException {
        byte[] content;
        Path tempDirectory = Files.createTempDirectory(((Object)((Object)this)).getClass().getName() + "_test", new FileAttribute[0]);
        ConfigServiceHolder.get().set("briefe/Textmodul_Extern_File", true);
        ConfigServiceHolder.get().set("briefe/Textmodul_Extern_File_Path", tempDirectory.toUri().toString());
        IDocumentLetter letter1 = (IDocumentLetter)this.coreModelService.create(IDocumentLetter.class);
        letter1.setDescription("test letter external");
        letter1.setPatient(this.patient1);
        letter1.setAuthor(this.contact1);
        letter1.setMimeType("txt");
        letter1.setContent((InputStream)new ByteArrayInputStream("My name is Mr. Me seeks, look at me".getBytes()));
        this.coreModelService.save((Identifiable)letter1);
        File file = tempDirectory.resolve(this.patient1.getPatientNr()).resolve(letter1.getId() + ".txt").toFile();
        Assert.assertTrue((boolean)file.exists());
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream is = letter1.getContent();){
            content = IOUtils.toByteArray((InputStream)is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertTrue((boolean)new String(content).startsWith("My name is"));
        FileUtils.deleteDirectory((File)tempDirectory.toFile());
        ConfigServiceHolder.get().set("briefe/Textmodul_Extern_File", false);
    }
}

