/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail;

import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.InternetAddress;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.angus.mail.imap.IMAPMessage;
import org.slf4j.LoggerFactory;

public class IMAPMailMessage {
    private final IMAPMessage message;
    private String sender;
    private String subject;
    private String text;
    private List<Attachment> attachments;
    private Date sentDate;

    public IMAPMailMessage(IMAPMessage message) {
        this.message = message;
        this.attachments = new ArrayList<Attachment>();
    }

    public static IMAPMailMessage of(IMAPMessage message) throws MessagingException {
        IMAPMailMessage imapMailMessage = new IMAPMailMessage(message);
        imapMailMessage.extractContent();
        return imapMailMessage;
    }

    private void extractContent() throws MessagingException {
        InternetAddress _sender = (InternetAddress)this.message.getSender();
        this.sender = _sender.getAddress();
        this.sentDate = this.message.getSentDate();
        this.subject = this.message.getSubject();
        try {
            String contentType = this.message.getContentType();
            Object content = this.message.getContent();
            if (content instanceof Multipart) {
                this.extractMultipartContent((Multipart)content);
            } else if (content instanceof BodyPart) {
                this.extractBodyPartContent((BodyPart)content);
            } else {
                this.extractOtherContent(contentType, content);
            }
        }
        catch (MessagingException | IOException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error reading attachments on mail {}: {}", (Object)this.sender, (Object)this.subject);
            throw new MessagingException("Error reading attachments", (Exception)e);
        }
    }

    private void extractOtherContent(String contentType, Object content) {
        if (contentType.toLowerCase().contains("text/plain")) {
            if (content instanceof String) {
                this.text = (String)content;
            } else if (content instanceof InputStream) {
                try {
                    this.text = IOUtils.toString((InputStream)((InputStream)content), (String)"ISO-8859-1");
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).warn("Error extraction other content", (Throwable)e);
                }
            } else {
                LoggerFactory.getLogger(this.getClass()).warn("Unknown other content [" + String.valueOf(content) + "]");
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Unknown other content type [" + contentType + "]");
        }
    }

    private void extractMultipartContent(Multipart multiPart) throws MessagingException, IOException {
        int numberOfParts = multiPart.getCount();
        int partCount = 0;
        while (partCount < numberOfParts) {
            BodyPart part = multiPart.getBodyPart(partCount);
            if (part.getContentType().contains("multipart")) {
                this.extractMultipartContent((Multipart)part.getContent());
            } else {
                this.extractBodyPartContent(part);
            }
            ++partCount;
        }
    }

    private void extractBodyPartContent(BodyPart part) throws MessagingException, IOException {
        if ("attachment".equalsIgnoreCase(part.getDisposition())) {
            String fileName = part.getFileName();
            byte[] content = IOUtils.toByteArray((InputStream)part.getInputStream());
            Attachment attachment = new Attachment(fileName, part.getSize(), content);
            this.attachments.add(attachment);
        } else {
            this.extractOtherContent(part.getContentType(), part.getContent());
        }
    }

    public Message toIMAPMessage() {
        return this.message;
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public String getSender() {
        return this.sender;
    }

    public String getText() {
        return this.text;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public static class Attachment {
        private String filename;
        private int size;
        private byte[] content;

        public Attachment(String filename, int size, byte[] content) {
            this.filename = filename;
            this.size = size;
            this.content = content;
        }

        public String getFilename() {
            return this.filename;
        }

        public byte[] getContent() {
            return this.content;
        }

        public int getSize() {
            return this.size;
        }
    }
}

