/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jpa.liquibase;

import ch.elexis.core.jpa.entitymanager.ui.IDatabaseUpdateUi;
import ch.elexis.core.l10n.Messages;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.AbstractChangeExecListener;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.command.core.ClearChecksumsCommandStep;
import liquibase.command.core.UpdateCommandStep;
import liquibase.command.core.helpers.ChangeExecListenerCommandStep;
import liquibase.command.core.helpers.DatabaseChangelogCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.resource.ClassLoaderResourceAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseDBUpdater {
    private static Logger logger = LoggerFactory.getLogger(LiquibaseDBUpdater.class);
    private String changelogXmlUrl;
    private DataSource dataSource;
    private IDatabaseUpdateUi updateProgress;

    public LiquibaseDBUpdater(DataSource dataSource, IDatabaseUpdateUi updateProgress) {
        this.dataSource = dataSource;
        this.changelogXmlUrl = "/db/elexisdb_master_update.xml";
        this.updateProgress = updateProgress;
    }

    public boolean update() {
        block5: {
            try {
                logger.info("Updating database [" + String.valueOf(this.dataSource) + "] with liquibase");
                try {
                    this.applyLiquibaseChangelist(this.dataSource.getConnection(), this.changelogXmlUrl);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof ValidationFailedException || e instanceof ValidationFailedException) {
                        logger.info("Validation failed clear checksums and retry");
                        this.clearCheckSums(this.dataSource.getConnection());
                        this.applyLiquibaseChangelist(this.dataSource.getConnection(), this.changelogXmlUrl);
                        break block5;
                    }
                    logger.error("Exception performing DB init", (Throwable)e);
                }
            }
            catch (SQLException | LiquibaseException e) {
                logger.warn("Exception on DB update.", e);
                return false;
            }
        }
        return true;
    }

    private void clearCheckSums(Connection connection) throws LiquibaseException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));){
                Map<String, ClassLoaderResourceAccessor> scopeObjects = Map.of(Scope.Attr.database.name(), database, Scope.Attr.resourceAccessor.name(), new ClassLoaderResourceAccessor(this.getClass().getClassLoader()));
                Scope.child(scopeObjects, () -> {
                    CommandResults commandResults = new CommandScope(ClearChecksumsCommandStep.COMMAND_NAME).addArgumentValue(DbUrlConnectionArgumentsCommandStep.DATABASE_ARG, (Object)database).addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)database.getConnection().getURL()).addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, (Object)new AbstractChangeExecListener(){

                        public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
                            if (LiquibaseDBUpdater.this.updateProgress != null) {
                                LiquibaseDBUpdater.this.updateProgress.setMessage(Messages.LiquibaseDBUpdater_Update_execute + changeSet.getDescription());
                            } else {
                                logger.info(Messages.LiquibaseDBUpdater_Update_execute + changeSet.getDescription());
                            }
                        }
                    }).execute();
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (LiquibaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LiquibaseException((Throwable)e);
        }
    }

    public void applyLiquibaseChangelist(Connection connection, String changelistClasspathResource) throws LiquibaseException {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));){
                Map<String, ClassLoaderResourceAccessor> scopeObjects = Map.of(Scope.Attr.database.name(), database, Scope.Attr.resourceAccessor.name(), new ClassLoaderResourceAccessor(this.getClass().getClassLoader()));
                Scope.child(scopeObjects, () -> {
                    CommandResults commandResults = new CommandScope(new String[]{"update"}).addArgumentValue(DbUrlConnectionArgumentsCommandStep.DATABASE_ARG, (Object)database).addArgumentValue(UpdateCommandStep.CHANGELOG_FILE_ARG, (Object)changelistClasspathResource).addArgumentValue(DatabaseChangelogCommandStep.CHANGELOG_PARAMETERS, (Object)new ChangeLogParameters(database)).addArgumentValue(ChangeExecListenerCommandStep.CHANGE_EXEC_LISTENER_ARG, (Object)new AbstractChangeExecListener(){

                        public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
                            if (LiquibaseDBUpdater.this.updateProgress != null) {
                                LiquibaseDBUpdater.this.updateProgress.setMessage(Messages.LiquibaseDBUpdater_Update_execute + changeSet.getDescription());
                            } else {
                                logger.info(Messages.LiquibaseDBUpdater_Update_execute + changeSet.getDescription());
                            }
                        }
                    }).execute();
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (LiquibaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LiquibaseException((Throwable)e);
        }
    }
}

