/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.importer.div.tasks.internal;

import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.multifile.strategy.BasicFileImportStrategyFactory;
import ch.elexis.core.importer.div.importers.multifile.strategy.DefaultPDFImportStrategy;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategy;
import ch.elexis.core.importer.div.importers.multifile.strategy.IFileImportStrategyFactory;
import ch.elexis.core.services.IVirtualFilesystemService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;

public class HL7ImportStrategyFactory
extends BasicFileImportStrategyFactory {
    private boolean moveAfterImport;
    private ILabContactResolver labContactResolver;
    private Logger logger;
    private ImportHandler importHandler;

    public HL7ImportStrategyFactory(Logger logger, ImportHandler importHandler) {
        this.logger = logger;
        this.importHandler = importHandler;
    }

    @Override
    public Map<IVirtualFilesystemService.IVirtualFilesystemHandle, IFileImportStrategy> createImportStrategyMap(IVirtualFilesystemService.IVirtualFilesystemHandle hl7File) {
        List<IVirtualFilesystemService.IVirtualFilesystemHandle> matchingFiles;
        Map<IVirtualFilesystemService.IVirtualFilesystemHandle, IFileImportStrategy> ret = super.createImportStrategyMap(hl7File);
        try {
            matchingFiles = this.getMatchingFiles(hl7File);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (!matchingFiles.isEmpty()) {
            DefaultPDFImportStrategy pdfImportStrategy = new DefaultPDFImportStrategy(this.importHandler);
            for (IVirtualFilesystemService.IVirtualFilesystemHandle mFile : matchingFiles) {
                String type = FilenameUtils.getExtension((String)mFile.getName()).toLowerCase();
                if (!"pdf".equals(type)) continue;
                this.logger.debug("... adding [" + mFile.getName() + "] with DefaultPDFImportStrategy");
                ret.put(mFile, pdfImportStrategy);
            }
        }
        ret.values().forEach(strategy -> {
            IFileImportStrategy iFileImportStrategy = strategy.setMoveAfterImport(this.moveAfterImport).setLabContactResolver(this.labContactResolver);
        });
        return ret;
    }

    @Override
    public IFileImportStrategyFactory setLabContactResolver(ILabContactResolver resolver) {
        this.labContactResolver = resolver;
        return this;
    }

    @Override
    public IFileImportStrategyFactory setMoveAfterImport(boolean value) {
        this.moveAfterImport = value;
        return this;
    }
}

