/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.FindingsContentHelper;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IModelService;
import java.util.Optional;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseResource;
import org.hl7.fhir.r4.model.Observation;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ObservationIObservationTransformer
implements IFhirTransformer<Observation, IObservation> {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;
    @Reference
    private IFindingsService findingsService;
    private FindingsContentHelper contentHelper = new FindingsContentHelper();

    @Override
    public Optional<Observation> getFhirObject(IObservation localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        Optional<IBaseResource> resource = this.contentHelper.getResource((IFinding)localObject);
        if (resource.isPresent()) {
            return Optional.of((Observation)resource.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IObservation> getLocalObject(Observation fhirObject) {
        Optional existing;
        if (fhirObject != null && fhirObject.getId() != null && (existing = this.findingsService.findById(fhirObject.getId(), IObservation.class)).isPresent()) {
            return Optional.of((IObservation)existing.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IObservation> updateLocalObject(Observation fhirObject, IObservation localObject) {
        return Optional.empty();
    }

    @Override
    public Optional<IObservation> createLocalObject(Observation fhirObject) {
        String id;
        Optional encounter;
        IObservation iObservation = (IObservation)this.findingsService.create(IObservation.class);
        this.contentHelper.setResource((BaseResource)fhirObject, (IFinding)iObservation);
        if (fhirObject.getSubject() != null && fhirObject.getSubject().hasReference()) {
            String id2 = fhirObject.getSubject().getReferenceElement().getIdPart();
            Optional patient = this.modelService.load(id2, IPatient.class);
            patient.ifPresent(k -> iObservation.setPatientId(id2));
        }
        IEncounter iEncounter = null;
        if (fhirObject.getEncounter() != null && fhirObject.getEncounter().hasReference() && (encounter = this.findingsService.findById(id = fhirObject.getEncounter().getReferenceElement().getIdPart(), IEncounter.class)).isPresent()) {
            iEncounter = (IEncounter)encounter.get();
            iObservation.setEncounter(iEncounter);
        }
        this.findingsService.saveFinding((IFinding)iObservation);
        return Optional.of(iObservation);
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return Observation.class.equals(fhirClazz) && IObservation.class.equals(localClazz);
    }
}

