/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.fhir.transformer;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.ICodingService;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.transformer.helper.CodeSystemUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.CodeSystem;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class CodeSystemStringTransformer
implements IFhirTransformer<CodeSystem, String> {
    @Reference
    private ICodingService codingService;
    private HashMap<String, CodeSystem> idMap = new HashMap();

    @Override
    public Optional<CodeSystem> getFhirObject(String localObject, SummaryEnum summaryEnum, Set<Include> includes) {
        List codes;
        CodeSystem ret = null;
        Optional<String> idString = CodeSystemUtil.getIdForString(localObject);
        Optional<String> systemString = CodeSystemUtil.getSystemForId(idString.get());
        if (idString.isPresent() && (ret = this.idMap.get(idString.get())) == null && this.codingService != null && systemString.isPresent() && (codes = this.codingService.getAvailableCodes(systemString.get())) != null && !codes.isEmpty()) {
            CodeSystem system = new CodeSystem();
            system.setId(idString.get());
            system.setUrl(systemString.get());
            List concepts = codes.stream().map(iCoding -> this.codingToConcept((ICoding)iCoding)).collect(Collectors.toList());
            system.setConcept(concepts);
            this.idMap.put(idString.get(), system);
            ret = system;
        }
        return Optional.ofNullable(ret);
    }

    private CodeSystem.ConceptDefinitionComponent codingToConcept(ICoding iCoding) {
        return new CodeSystem.ConceptDefinitionComponent().setCode(iCoding.getCode()).setDisplay(iCoding.getDisplay());
    }

    @Override
    public Optional<String> getLocalObject(CodeSystem fhirObject) {
        return null;
    }

    @Override
    public Optional<String> updateLocalObject(CodeSystem fhirObject, String localObject) {
        return null;
    }

    @Override
    public Optional<String> createLocalObject(CodeSystem fhirObject) {
        return null;
    }

    @Override
    public boolean matchesTypes(Class<?> fhirClazz, Class<?> localClazz) {
        return CodeSystem.class.equals(fhirClazz) && String.class.equals(localClazz);
    }
}

