/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util.commands;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.util.FindingsTextUtil;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.commands.IFindingCommand;

public class UpdateFindingTextCommand
implements IFindingCommand {
    private IFinding iFinding;

    public UpdateFindingTextCommand(IFinding finding) {
        this.iFinding = finding;
    }

    @Override
    public void execute() throws ElexisException {
        IFinding rootFinding;
        if (this.iFinding instanceof IObservation && ((IObservation)this.iFinding).getObservationType() != IObservation.ObservationType.REF) {
            FindingsTextUtil.getObservationText((IObservation)this.iFinding, true);
        }
        if ((rootFinding = this.getRootFinding()) instanceof IObservation) {
            IObservation.ObservationType observationType = ((IObservation)rootFinding).getObservationType();
            if (observationType == IObservation.ObservationType.REF) {
                FindingsTextUtil.getGroupText((IObservation)rootFinding, true);
            } else {
                FindingsTextUtil.getObservationText((IObservation)rootFinding, true);
            }
        }
    }

    private IFinding getRootFinding() {
        IObservation rootFinding = null;
        if (this.iFinding instanceof IObservation) {
            rootFinding = ModelUtil.getRootObservationRecursive((IObservation)this.iFinding);
        }
        return rootFinding;
    }
}

