/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.dialogs;

import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.ui.action.DateAction;
import ch.elexis.core.findings.ui.composites.CompositeBoolean;
import ch.elexis.core.findings.ui.composites.CompositeDate;
import ch.elexis.core.findings.ui.composites.CompositeGroup;
import ch.elexis.core.findings.ui.composites.CompositeTextUnit;
import ch.elexis.core.findings.ui.composites.ICompositeSaveable;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.commands.UpdateFindingTextCommand;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FindingsEditDialog
extends TitleAreaDialog {
    private final IFinding iFinding;
    private ICompositeSaveable iCompositeSaveable;
    private List<IFinding> lockedFindings = new ArrayList<IFinding>();

    public FindingsEditDialog(Shell parentShell, IFinding iFinding) {
        super(parentShell);
        this.iFinding = iFinding;
        this.lockedFindings.clear();
    }

    protected Control createDialogArea(Composite parent) {
        String title = FindingsUiUtil.getTypeAsText(this.iFinding);
        this.setTitle("Befund");
        this.setMessage(title);
        int depth = 0;
        this.iCompositeSaveable = new CompositeGroup(parent, this.iFinding, false, false, 10, 10, depth++);
        try {
            this.iCompositeSaveable.getChildReferences().add(this.createDynamicContent(this.iFinding, this.iCompositeSaveable, depth));
        }
        catch (ElexisException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Fehler", (String)e.getMessage());
            this.cancelPressed();
        }
        return (Control)this.iCompositeSaveable;
    }

    private ICompositeSaveable createDynamicContent(IFinding iFinding, ICompositeSaveable current, int depth) throws ElexisException {
        if (!LocalLockServiceHolder.get().acquireLock((Object)iFinding).isOk()) {
            throw new ElexisException("Die Editierung ist nicht m\u00f6glich, kein Lock erhalten.");
        }
        this.lockedFindings.add(iFinding);
        if (iFinding instanceof IObservation) {
            IObservation item = (IObservation)iFinding;
            List refChildrens = item.getTargetObseravtions(IObservationLink.ObservationLinkType.REF);
            StringBuilder sb = new StringBuilder();
            refChildrens.stream().forEach(o -> {
                StringBuilder stringBuilder2 = sb.append(((ICoding)o.getCoding().get(0)).getDisplay()).append(o.isDeleted()).append(",");
            });
            List compChildrens = item.getComponents();
            if (refChildrens.isEmpty() && compChildrens.isEmpty()) {
                current = this.createComposite((Composite)current, (IFinding)item, null);
            } else {
                if (!refChildrens.isEmpty()) {
                    current = new CompositeGroup((Composite)current, (IFinding)item, true, false, 0, 10, depth);
                    for (IObservation child : refChildrens) {
                        ICompositeSaveable childComposite = this.createDynamicContent((IFinding)child, current, ++depth);
                        current.getChildReferences().add(childComposite);
                    }
                }
                if (!compChildrens.isEmpty()) {
                    current = new CompositeGroup((Composite)current, (IFinding)item, false, false, 0, 5, depth);
                    Group group = new Group((Composite)current, 0);
                    group.setText("");
                    GridLayout gd = new GridLayout(2, false);
                    gd.marginHeight = 0;
                    gd.marginBottom = 10;
                    gd.verticalSpacing = 0;
                    gd.marginTop = 0;
                    group.setLayout((Layout)gd);
                    group.setLayoutData((Object)new GridData(4, 4, true, true));
                    Composite groupComposite = new Composite((Composite)group, 0);
                    GridLayout gd2 = new GridLayout(2, false);
                    gd2.marginHeight = 0;
                    gd2.marginBottom = 5;
                    gd2.verticalSpacing = 0;
                    gd2.marginTop = 0;
                    groupComposite.setLayout((Layout)gd2);
                    groupComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
                    Label lblTitle = new Label(groupComposite, 0);
                    lblTitle.setText(current.getTitle());
                    lblTitle.setLayoutData((Object)new GridData(16384, 1024, false, false, 1, 1));
                    current.setToolbarActions(FindingsUiUtil.createToolbarSubComponents(groupComposite, item, 1));
                    boolean allUnitsSame = ModelUtil.getExactUnitOfComponent((List)compChildrens) != null;
                    int i = 0;
                    for (ObservationComponent child : compChildrens) {
                        ++i;
                        ICompositeSaveable childComposite = this.createComposite((Composite)group, iFinding, child);
                        current.getChildComponents().add(childComposite);
                        if (!allUnitsSame || !(childComposite instanceof CompositeTextUnit)) continue;
                        childComposite.hideLabel(i < compChildrens.size());
                    }
                }
            }
        } else {
            current = this.createComposite((Composite)current, iFinding, null);
        }
        return current;
    }

    private ICompositeSaveable createComposite(Composite parent, IFinding iFinding, ObservationComponent backboneComponent) {
        if (iFinding instanceof IObservation) {
            IObservation.ObservationType type = ((IObservation)iFinding).getObservationType();
            switch (type) {
                case COMP: 
                case NUMERIC: 
                case TEXT: {
                    return new CompositeTextUnit(parent, iFinding, backboneComponent);
                }
                case BOOLEAN: {
                    return new CompositeBoolean(parent, iFinding, backboneComponent);
                }
                case DATE: {
                    return new CompositeDate(parent, iFinding, backboneComponent);
                }
            }
            throw new IllegalStateException("No composite for observation type [" + String.valueOf(type) + "] of [" + String.valueOf(iFinding) + "]");
        }
        throw new IllegalStateException("No composite for finding [" + String.valueOf(iFinding) + "]");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        if (this.iCompositeSaveable != null) {
            LocalDateTime localDateTime = LocalDateTime.now();
            List<Action> actions = this.iCompositeSaveable.getToolbarActions();
            if (actions != null) {
                for (Action action : actions) {
                    if (!(action instanceof DateAction)) continue;
                    localDateTime = ((DateAction)action).getLocalDateTime();
                }
            }
            FindingsUiUtil.saveGroup(this.iCompositeSaveable);
            this.iCompositeSaveable.saveContents(localDateTime);
            try {
                new UpdateFindingTextCommand(this.iFinding).execute();
            }
            catch (ElexisException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Fehler", (String)"Fehler bei der Generierung des Texts der Beobachtung.");
            }
        }
        super.okPressed();
    }

    public void releaseAllLocks() {
        for (IFinding iFinding : this.lockedFindings) {
            LocalLockServiceHolder.get().releaseLock((Object)iFinding);
        }
    }

    public List<IFinding> getLockedFindings() {
        return this.lockedFindings;
    }
}

