/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.ui.composites.CodingContentProposalProvider;
import ch.elexis.core.findings.ui.dialogs.CodingEditDialog;
import ch.elexis.core.findings.ui.services.CodingServiceComponent;
import ch.elexis.core.findings.util.model.TransientCoding;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CodingSelectionComposite
extends Composite
implements ISelectionProvider {
    private ListenerList selectionListeners = new ListenerList();
    private Text selectionTxt;
    private ComboViewer systemCombo;
    private CodingContentProposalProvider proposalProvider;
    private Optional<ICoding> selectedCode = Optional.empty();

    public CodingSelectionComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.systemCombo = new ComboViewer((Composite)this);
        this.systemCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.systemCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return super.getText(element);
            }
        });
        this.systemCombo.setInput(CodingServiceComponent.getService().getAvailableCodeSystems().stream().filter(system -> !system.equals(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem())).collect(Collectors.toList()));
        this.systemCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CodingSelectionComposite.this.proposalProvider != null) {
                    ISelection selection = event.getSelection();
                    if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                        CodingSelectionComposite.this.proposalProvider.setSelectedSystem(Optional.of((String)((StructuredSelection)selection).getFirstElement()));
                    } else {
                        CodingSelectionComposite.this.proposalProvider.setSelectedSystem(Optional.empty());
                    }
                }
            }
        });
        this.selectionTxt = new Text((Composite)this, 2048);
        this.selectionTxt.setMessage("Coding selektieren");
        this.selectionTxt.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.proposalProvider = new CodingContentProposalProvider();
        ContentProposalAdapter toAddressProposalAdapter = new ContentProposalAdapter((Control)this.selectionTxt, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.proposalProvider, null, null);
        toAddressProposalAdapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                Object[] listeners;
                CodingSelectionComposite.this.selectionTxt.setText(proposal.getContent());
                CodingSelectionComposite.this.proposalProvider.getCodingForProposal(proposal).ifPresent(iCoding -> {
                    CodingSelectionComposite.this.selectedCode = Optional.of(iCoding);
                    Optional<ICoding> optional = CodingSelectionComposite.this.selectedCode;
                });
                CodingSelectionComposite.this.selectionTxt.setSelection(CodingSelectionComposite.this.selectionTxt.getText().length());
                Object[] objectArray = listeners = CodingSelectionComposite.this.selectionListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    SelectionChangedEvent selectionEvent = new SelectionChangedEvent((ISelectionProvider)CodingSelectionComposite.this, CodingSelectionComposite.this.getSelection());
                    ((ISelectionChangedListener)object).selectionChanged(selectionEvent);
                    ++n2;
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action("Lokalen Code anlegen"){

            public void run() {
                TransientCoding transientCoding = new TransientCoding(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem(), CodingSelectionComposite.this.selectionTxt.getSelectionText(), "");
                CodingEditDialog editDialog = new CodingEditDialog((ICoding)transientCoding, CodingSelectionComposite.this.getShell());
                if (editDialog.open() == 0) {
                    CodingServiceComponent.getService().addLocalCoding((ICoding)transientCoding);
                    CodingSelectionComposite.this.setCodeSystem(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem());
                }
            }

            public boolean isEnabled() {
                Object codeSystem;
                ISelection systemSelection = CodingSelectionComposite.this.systemCombo.getSelection();
                if (systemSelection instanceof StructuredSelection && (codeSystem = ((StructuredSelection)systemSelection).getFirstElement()) instanceof String && codeSystem.equals(CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem())) {
                    String text = CodingSelectionComposite.this.selectionTxt.getSelectionText();
                    return text != null && !text.isEmpty();
                }
                return false;
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items;
                IContributionItem[] iContributionItemArray = items = manager.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem iContributionItem = iContributionItemArray[n2];
                    iContributionItem.update();
                    ++n2;
                }
            }
        });
        this.selectionTxt.setMenu(menuManager.createContextMenu((Control)this.selectionTxt));
    }

    public void setCodeSystem(String codeSystem) {
        if (this.systemCombo != null) {
            this.systemCombo.setSelection((ISelection)new StructuredSelection((Object)codeSystem));
        }
    }

    public Optional<ICoding> getSelectedCoding() {
        return this.selectedCode;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        StructuredSelection ret = new StructuredSelection();
        if (this.selectedCode.isPresent()) {
            ret = new StructuredSelection((Object)this.selectedCode.get());
        }
        return ret;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            ICoding iCoding = (ICoding)((IStructuredSelection)selection).getFirstElement();
            String label = this.proposalProvider.toLabel(iCoding);
            if (label != null) {
                this.selectionTxt.setText(label);
                this.selectionTxt.setSelection(this.selectionTxt.getText().length());
                this.selectedCode = Optional.of(iCoding);
            }
        } else {
            this.selectionTxt.setText("");
            this.selectedCode = Optional.empty();
        }
    }
}

