/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.action;

import ch.elexis.core.ui.dialogs.DateTimeSelectorDialog;
import ch.elexis.core.ui.icons.Images;
import ch.rgw.tools.TimeTool;
import java.time.LocalDateTime;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class DateAction
extends Action {
    private LocalDateTime localDateTime;
    private final Shell shell;
    private Label lblDateText;

    public DateAction(Shell shell, LocalDateTime localDateTime, Composite composite) {
        super("", 1);
        Assert.isNotNull((Object)shell);
        this.shell = shell;
        this.localDateTime = localDateTime == null ? LocalDateTime.now() : localDateTime;
        this.lblDateText = new Label(composite, 0);
        this.lblDateText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.init();
    }

    public void run() {
        TimeTool timeTool;
        DateTimeSelectorDialog inputDialog = new DateTimeSelectorDialog(this.shell, new TimeTool(this.localDateTime), true);
        if (inputDialog.open() == 0 && (timeTool = inputDialog.getSelectedDate()) != null) {
            this.localDateTime = timeTool.toLocalDateTime();
            this.init();
        }
        super.run();
    }

    public String getToolTipText() {
        return "Datum \u00e4ndern";
    }

    private void init() {
        if (this.lblDateText != null) {
            this.lblDateText.setText(new TimeTool(this.localDateTime).toString(0));
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return Images.IMG_CALENDAR.getImageDescriptor();
    }

    public LocalDateTime getLocalDateTime() {
        return this.localDateTime;
    }
}

