/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Type implements Enumerator
{
    OBSERVATION_VITAL(1, "OBSERVATION_VITAL", "OBSERVATION_VITAL"),
    PROCEDURE(100, "PROCEDURE", "PROCEDURE"),
    CONDITION(200, "CONDITION", "CONDITION"),
    EVALUATION(300, "EVALUATION", "EVALUATION");

    public static final int OBSERVATION_VITAL_VALUE = 1;
    public static final int PROCEDURE_VALUE = 100;
    public static final int CONDITION_VALUE = 200;
    public static final int EVALUATION_VALUE = 300;
    private static final Type[] VALUES_ARRAY;
    public static final List<Type> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Type[]{OBSERVATION_VITAL, PROCEDURE, CONDITION, EVALUATION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Type get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Type result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Type getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Type result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Type get(int value) {
        switch (value) {
            case 1: {
                return OBSERVATION_VITAL;
            }
            case 100: {
                return PROCEDURE;
            }
            case 200: {
                return CONDITION;
            }
            case 300: {
                return EVALUATION;
            }
        }
        return null;
    }

    private Type(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

