/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.migrator;

import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFamilyMemberHistory;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.migration.IMigratorContribution;
import ch.elexis.core.findings.migration.IMigratorService;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.model.TransientCoding;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class MigratorService
implements IMigratorService {
    private List<IMigratorContribution> contributions = new ArrayList<IMigratorContribution>();
    @Reference(target="(service.model.name=ch.elexis.core.findings.model)")
    private IModelService findingsModelService;
    @Reference
    private IFindingsService findingsService;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setMigratorContribution(IMigratorContribution contribution) {
        if (!this.contributions.contains(contribution)) {
            this.contributions.add(contribution);
        }
    }

    public void unsetMigratorContribution(IMigratorContribution contribution) {
        if (this.contributions.contains(contribution)) {
            this.contributions.remove(contribution);
        }
    }

    public void migratePatientsFindings(String patientId, Class<? extends IFinding> filter, ICoding coding) {
        if (patientId != null && !patientId.isEmpty()) {
            if (filter.isAssignableFrom(IEncounter.class)) {
                this.migratePatientEncounters(patientId);
            }
            if (filter.isAssignableFrom(ICondition.class)) {
                this.migratePatientCondition(patientId);
            }
            if (filter.isAssignableFrom(IObservation.class) && coding != null) {
                if (IObservation.ObservationCode.ANAM_PERSONAL.isSame(coding)) {
                    this.migratePatientPersAnamnese(patientId);
                } else if (IObservation.ObservationCode.ANAM_RISK.isSame(coding)) {
                    this.migratePatientRiskfactors(patientId);
                }
            }
            if (filter.isAssignableFrom(IFamilyMemberHistory.class)) {
                this.migratePatientFamAnamnese(patientId);
            }
            if (filter.isAssignableFrom(IAllergyIntolerance.class)) {
                this.migrateAllergyIntolerance(patientId);
            }
            for (IMigratorContribution iMigratorContribution : this.contributions) {
                if (!iMigratorContribution.canHandlePatientsFindings(filter, coding)) continue;
                iMigratorContribution.migratePatientsFindings(patientId, filter, coding);
            }
        }
    }

    public void migrateConsultationsFindings(String consultationId, Class<? extends IFinding> filter) {
        if (consultationId != null && !consultationId.isEmpty() && filter.isAssignableFrom(IEncounter.class)) {
            this.migrateConsultationEncounter(consultationId);
        }
    }

    private void migratePatientPersAnamnese(String patientId) {
        String anamnese;
        Patient patient = Patient.load((String)patientId);
        if (patient != null && patient.exists() && (anamnese = patient.getPersAnamnese()) != null && !anamnese.isEmpty()) {
            List observations = this.findingsService.getPatientsFindings(patientId, IObservation.class);
            if ((observations = observations.parallelStream().filter(iFinding -> this.isPersAnamnese((IObservation)iFinding)).collect(Collectors.toList())).isEmpty()) {
                IObservation observation = (IObservation)this.findingsService.create(IObservation.class);
                observation.setPatientId(patientId);
                observation.setCategory(IObservation.ObservationCategory.SOCIALHISTORY);
                observation.setText(anamnese);
                observation.setCoding(Collections.singletonList(new TransientCoding(IObservation.ObservationCode.ANAM_PERSONAL)));
                this.findingsService.saveFinding((IFinding)observation);
            }
        }
    }

    private void migratePatientRiskfactors(String patientId) {
        String risk;
        Patient patient = Patient.load((String)patientId);
        if (patient != null && patient.exists() && (risk = patient.getRisk()) != null && !risk.isEmpty()) {
            List observations = this.findingsService.getPatientsFindings(patientId, IObservation.class);
            if ((observations = observations.parallelStream().filter(iFinding -> this.isRiskfactor((IObservation)iFinding)).collect(Collectors.toList())).isEmpty()) {
                IObservation observation = (IObservation)this.findingsService.create(IObservation.class);
                observation.setPatientId(patientId);
                observation.setCategory(IObservation.ObservationCategory.SOCIALHISTORY);
                observation.setText(risk);
                observation.setCoding(Collections.singletonList(new TransientCoding(IObservation.ObservationCode.ANAM_RISK)));
                this.findingsService.saveFinding((IFinding)observation);
            }
        }
    }

    private void migratePatientCondition(String patientId) {
        String diagnosis;
        Patient patient = Patient.load((String)patientId);
        if (patient != null && patient.exists() && (diagnosis = patient.getDiagnosen()) != null && !diagnosis.isEmpty()) {
            List conditions = this.findingsService.getPatientsFindings(patientId, ICondition.class);
            if ((conditions = conditions.parallelStream().filter(iFinding -> this.isDiagnose((ICondition)iFinding)).collect(Collectors.toList())).isEmpty()) {
                ICondition condition = (ICondition)this.findingsService.create(ICondition.class);
                condition.setPatientId(patientId);
                condition.setCategory(ICondition.ConditionCategory.PROBLEMLISTITEM);
                condition.setText(diagnosis);
                this.findingsService.saveFinding((IFinding)condition);
            }
        }
    }

    private void migratePatientFamAnamnese(String patientId) {
        List iFindings;
        String anamnese;
        Patient patient = Patient.load((String)patientId);
        if (patient != null && patient.exists() && (anamnese = patient.getFamilyAnamnese()) != null && !anamnese.isEmpty() && (iFindings = this.findingsService.getPatientsFindings(patientId, IFamilyMemberHistory.class)).isEmpty()) {
            IFamilyMemberHistory familyMemberHistory = (IFamilyMemberHistory)this.findingsService.create(IFamilyMemberHistory.class);
            familyMemberHistory.setPatientId(patientId);
            familyMemberHistory.setText(anamnese);
            this.findingsService.saveFinding((IFinding)familyMemberHistory);
        }
    }

    private void migrateAllergyIntolerance(String patientId) {
        List iFindings;
        String allergies;
        Patient patient = Patient.load((String)patientId);
        if (patient != null && patient.exists() && (allergies = patient.getAllergies()) != null && !allergies.isEmpty() && (iFindings = this.findingsService.getPatientsFindings(patientId, IAllergyIntolerance.class)).isEmpty()) {
            IAllergyIntolerance allergyIntolerance = (IAllergyIntolerance)this.findingsService.create(IAllergyIntolerance.class);
            allergyIntolerance.setPatientId(patientId);
            allergyIntolerance.setText(allergies);
            this.findingsService.saveFinding((IFinding)allergyIntolerance);
        }
    }

    private boolean isDiagnose(ICondition iFinding) {
        return iFinding.getCategory() == ICondition.ConditionCategory.PROBLEMLISTITEM;
    }

    private boolean isPersAnamnese(IObservation iFinding) {
        if (iFinding instanceof IObservation && iFinding.getCategory() == IObservation.ObservationCategory.SOCIALHISTORY) {
            for (ICoding code : iFinding.getCoding()) {
                if (!IObservation.ObservationCode.ANAM_PERSONAL.isSame(code)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRiskfactor(IObservation iFinding) {
        if (iFinding.getCategory() == IObservation.ObservationCategory.SOCIALHISTORY) {
            for (ICoding code : iFinding.getCoding()) {
                if (!IObservation.ObservationCode.ANAM_RISK.isSame(code)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Konsultation> findAllConsultationsForPatient(Patient patient) {
        ArrayList<Konsultation> ret = new ArrayList<Konsultation>();
        Fall[] faelle = patient.getFaelle();
        if (faelle != null && faelle.length > 0) {
            Fall[] fallArray = faelle;
            int n = faelle.length;
            int n2 = 0;
            while (n2 < n) {
                Fall fall = fallArray[n2];
                ret.addAll(Arrays.asList(fall.getBehandlungen(false)));
                ++n2;
            }
        }
        return ret;
    }

    private void migratePatientEncounters(String patientId) {
        Patient patient = Patient.load((String)patientId);
        if (patient != null && patient.exists()) {
            List<Konsultation> consultations = this.findAllConsultationsForPatient(patient);
            consultations.stream().forEach(cons -> this.migrateEncounter((Konsultation)cons));
        }
    }

    private void migrateConsultationEncounter(String consultationId) {
        Konsultation cons = Konsultation.load((String)consultationId);
        if (cons != null && cons.exists()) {
            this.migrateEncounter(cons);
        }
    }

    private void migrateEncounter(Konsultation cons) {
        String patientId = cons.getFall().getPatient().getId();
        IQuery query = this.findingsModelService.getQuery(IEncounter.class);
        query.and("patientid", IQuery.COMPARATOR.EQUALS, (Object)patientId);
        query.and("consultationid", IQuery.COMPARATOR.EQUALS, (Object)cons.getId());
        List encounters = query.execute();
        if (encounters.isEmpty()) {
            this.createEncounter(cons);
        } else {
            this.updateEncounter((IEncounter)encounters.get(0), cons);
        }
    }

    private void createEncounter(Konsultation cons) {
        IEncounter encounter = (IEncounter)this.findingsService.create(IEncounter.class);
        this.updateEncounter(encounter, cons);
    }

    private void updateEncounter(IEncounter encounter, Konsultation cons) {
        VersionedResource vr;
        Patient patient;
        Fall fall;
        encounter.setConsultationId(cons.getId());
        encounter.setMandatorId(cons.getMandant().getId());
        LocalDate encounterDate = new TimeTool(cons.getDatum()).toLocalDate();
        if (encounterDate != null) {
            encounter.setStartTime(encounterDate.atStartOfDay());
            encounter.setEndTime(encounterDate.atTime(23, 59, 59));
        }
        if ((fall = cons.getFall()) != null && (patient = fall.getPatient()) != null) {
            encounter.setPatientId(patient.getId());
        }
        if ((vr = cons.getEintrag()) != null) {
            Samdas samdas = new Samdas(vr.getHead());
            encounter.setText(samdas.getRecordText());
        }
        List coding = encounter.getType();
        if (!ModelUtil.isSystemInList((String)CodingSystem.ELEXIS_ENCOUNTER_TYPE.getSystem(), (List)coding)) {
            coding.add(new TransientCoding(CodingSystem.ELEXIS_ENCOUNTER_TYPE.getSystem(), "text", "Nicht strukturierte Konsultation"));
            encounter.setType(coding);
        }
        this.findingsService.saveFinding((IFinding)encounter);
    }
}

