/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.dataaccess;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFamilyMemberHistory;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.codes.ICodingService;
import ch.elexis.core.findings.fhir.po.dataaccess.TextUtil;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Result;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class FindingsDataAccessor
implements IDataAccess {
    public static final String FINDINGS_PATIENT_DIAGNOSIS = "Patient Diagnosen";
    public static final String FINDINGS_PATIENT_PERSANAM = "Patient PersAnam";
    public static final String FINDINGS_PATIENT_ALLERGIES = "Patient Allergien";
    public static final String FINDINGS_PATIENT_FAMANAM = "Patient FamAnam";
    public static final String FINDINGS_PATIENT_RISK = "Patient Risk";
    private IFindingsService findingsService;
    private ICodingService codingService;
    ArrayList<IDataAccess.Element> elementsList;
    private IDataAccess.Element[] elements = new IDataAccess.Element[]{new IDataAccess.Element(IDataAccess.TYPE.STRING, "Patient Diagnosen", "[Befunde:-:-:Patient Diagnosen]", null, 0), new IDataAccess.Element(IDataAccess.TYPE.STRING, "Patient PersAnam", "[Befunde:-:-:Patient PersAnam]", null, 0), new IDataAccess.Element(IDataAccess.TYPE.STRING, "Patient Allergien", "[Befunde:-:-:Patient Allergien]", null, 0), new IDataAccess.Element(IDataAccess.TYPE.STRING, "Patient FamAnam", "[Befunde:-:-:Patient FamAnam]", null, 0), new IDataAccess.Element(IDataAccess.TYPE.STRING, "Patient Risk", "[Befunde:-:-:Patient Risk]", null, 0)};

    public FindingsDataAccessor() {
        this.elementsList = new ArrayList();
        int i = 0;
        while (i < this.elements.length) {
            this.elementsList.add(this.elements[i]);
            ++i;
        }
        this.findingsService = (IFindingsService)this.getService(IFindingsService.class);
        this.codingService = (ICodingService)this.getService(ICodingService.class);
    }

    private Object getService(Class<?> clazz) {
        ServiceReference serviceReference;
        BundleContext context = FrameworkUtil.getBundle(FindingsDataAccessor.class).getBundleContext();
        if (context != null && (serviceReference = context.getServiceReference(clazz.getName())) != null) {
            return context.getService(serviceReference);
        }
        return null;
    }

    public String getName() {
        return "Befunde strukturiert";
    }

    public String getDescription() {
        return "Befunde strukturiert";
    }

    public List<IDataAccess.Element> getList() {
        return this.elementsList;
    }

    public Result<Object> getObject(String descriptor, PersistentObject dependentObject, String dates, String[] params) {
        Result<Object> result = new Result<Object>((Object)"");
        Patient patient = null;
        patient = dependentObject instanceof Patient ? (Patient)dependentObject : (Patient)ElexisEventDispatcher.getSelected(Patient.class);
        if (patient != null) {
            if (FINDINGS_PATIENT_DIAGNOSIS.equalsIgnoreCase(descriptor)) {
                result = this.getDiagnosisText(patient);
            } else if (FINDINGS_PATIENT_PERSANAM.equalsIgnoreCase(descriptor)) {
                result = this.getPersAnamText(patient);
            } else if (FINDINGS_PATIENT_ALLERGIES.equalsIgnoreCase(descriptor)) {
                result = this.getAllergiesText(patient);
            } else if (FINDINGS_PATIENT_FAMANAM.equalsIgnoreCase(descriptor)) {
                result = this.getFamAnamText(patient);
            } else if (FINDINGS_PATIENT_RISK.equalsIgnoreCase(descriptor)) {
                result = this.getRisk(patient);
            }
        }
        return result;
    }

    private Result<Object> getRisk(Patient patient) {
        List observations = this.findingsService.getPatientsFindings(patient.getId(), IObservation.class);
        observations = observations.parallelStream().filter(iFinding -> TextUtil.isRiskfactor(iFinding)).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        observations.stream().forEach(observation -> {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(TextUtil.getText(observation, this.codingService));
        });
        return new Result((Object)sb.toString());
    }

    private Result<Object> getFamAnamText(Patient patient) {
        List famanams = this.findingsService.getPatientsFindings(patient.getId(), IFamilyMemberHistory.class);
        StringBuilder sb = new StringBuilder();
        famanams.stream().forEach(famanam -> {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(TextUtil.getText(famanam, this.codingService));
        });
        return new Result((Object)sb.toString());
    }

    private Result<Object> getAllergiesText(Patient patient) {
        List allergies = this.findingsService.getPatientsFindings(patient.getId(), IAllergyIntolerance.class);
        StringBuilder sb = new StringBuilder();
        allergies.stream().forEach(allergy -> {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(TextUtil.getText(allergy, this.codingService));
        });
        return new Result((Object)sb.toString());
    }

    private Result<Object> getPersAnamText(Patient patient) {
        List observations = this.findingsService.getPatientsFindings(patient.getId(), IObservation.class);
        observations = observations.parallelStream().filter(iFinding -> TextUtil.isPersAnamnese(iFinding)).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        observations.stream().forEach(observation -> {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(TextUtil.getText(observation, this.codingService));
        });
        return new Result((Object)sb.toString());
    }

    private Result<Object> getDiagnosisText(Patient patient) {
        List findings = this.findingsService.getPatientsFindings(patient.getId(), ICondition.class);
        List<ICondition> conditions = this.getDiagnosis(findings);
        StringBuilder sb = new StringBuilder();
        conditions.stream().forEach(condition -> {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(TextUtil.getText(condition, this.codingService));
        });
        return new Result((Object)sb.toString());
    }

    private List<ICondition> getDiagnosis(List<ICondition> findings) {
        ArrayList<ICondition> ret = new ArrayList<ICondition>();
        findings.stream().forEach(finding -> {
            ICondition iCondition = finding;
            if (iCondition.getCategory().equals((Object)ICondition.ConditionCategory.PROBLEMLISTITEM)) {
                ret.add(iCondition);
            }
        });
        ret.sort((left, right) -> {
            LocalDate lRecorded = left.getDateRecorded().orElse(LocalDate.of(1970, Month.JANUARY, 1));
            LocalDate rRecorded = right.getDateRecorded().orElse(LocalDate.of(1970, Month.JANUARY, 1));
            return rRecorded.compareTo(lRecorded);
        });
        return ret;
    }
}

