/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.data.Artikel;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class ArticleDefaultSignature
extends PersistentObject {
    public static final String FLD_ATC_CODE = "atccode";
    public static final String FLD_ARTICLE = "article";
    public static final String FLD_TYPE = "type";
    public static final String FLD_SIG_MORNING = "morning";
    public static final String FLD_SIG_NOON = "noon";
    public static final String FLD_SIG_EVENING = "evening";
    public static final String FLD_SIG_NIGHT = "night";
    public static final String FLD_SIG_COMMENT = "comment";
    public static final String EXT_FLD_MEDICATIONTYPE = "medicationType";
    public static final String EXT_FLD_DISPOSALTYPE = "disposalType";
    public static final String EXT_FLD_FREETEXT = "textSignature";
    public static final String TABLENAME = "default_signatures";

    static {
        ArticleDefaultSignature.addMapping(TABLENAME, FLD_ATC_CODE, FLD_ARTICLE, FLD_TYPE, FLD_SIG_MORNING, FLD_SIG_NOON, FLD_SIG_EVENING, FLD_SIG_NIGHT, FLD_SIG_COMMENT, "ExtInfo");
    }

    protected ArticleDefaultSignature() {
    }

    protected ArticleDefaultSignature(String id) {
        super(id);
    }

    public ArticleDefaultSignature(Artikel article, String atcCode) {
        this.create(null);
        if (article != null) {
            this.set(FLD_ARTICLE, article.getEAN() + "$" + article.getPharmaCode() + "$" + article.storeToString());
        }
        if (atcCode != null) {
            this.set(FLD_ATC_CODE, atcCode);
        }
    }

    public static ArticleDefaultSignature load(String id) {
        return new ArticleDefaultSignature(id);
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        String atcCode = this.get(FLD_ATC_CODE);
        Artikel article = this.getArticle();
        if (atcCode != null && !atcCode.isEmpty()) {
            sb.append("ATC [" + atcCode + "] ");
        } else if (article != null) {
            sb.append("ARTICLE [" + article.getLabel() + "] ");
        }
        sb.append(this.getSignatureMorning()).append("-").append(this.getSignatureNoon()).append("-").append(this.getSignatureEvening()).append("-").append(this.getSignatureNight()).append(" ").append(this.getSignatureComment());
        return null;
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    @Nullable
    public static ArticleDefaultSignature getDefaultsignatureForArticle(@Nullable Artikel artikel) {
        if (artikel == null) {
            return null;
        }
        Query qbe = new Query(ArticleDefaultSignature.class);
        qbe.add(FLD_ARTICLE, "LIKE", "%" + artikel.storeToString());
        List resultArticle = qbe.execute();
        if (!resultArticle.isEmpty()) {
            return (ArticleDefaultSignature)resultArticle.get(0);
        }
        return ArticleDefaultSignature.getDefaultSignatureForATCCode(artikel.getATC_code());
    }

    public static ArticleDefaultSignature getDefaultSignatureForATCCode(String atcCode) {
        Query qbe = new Query(ArticleDefaultSignature.class);
        qbe.add(FLD_ATC_CODE, "LIKE", atcCode);
        List execute = qbe.execute();
        return !execute.isEmpty() ? (ArticleDefaultSignature)execute.get(0) : null;
    }

    public String getSignatureMorning() {
        return ArticleDefaultSignature.checkNull(this.get(FLD_SIG_MORNING));
    }

    public void setSignatureMorning(String sm) {
        this.set(FLD_SIG_MORNING, sm);
    }

    public String getSignatureNoon() {
        return ArticleDefaultSignature.checkNull(this.get(FLD_SIG_NOON));
    }

    public void setSignatureNoon(String sm) {
        this.set(FLD_SIG_NOON, sm);
    }

    public String getSignatureEvening() {
        return ArticleDefaultSignature.checkNull(this.get(FLD_SIG_EVENING));
    }

    public void setSignatureEvening(String sm) {
        this.set(FLD_SIG_EVENING, sm);
    }

    public String getSignatureNight() {
        return ArticleDefaultSignature.checkNull(this.get(FLD_SIG_NIGHT));
    }

    public void setSignatureNight(String sm) {
        this.set(FLD_SIG_NIGHT, sm);
    }

    public String getSignatureComment() {
        return ArticleDefaultSignature.checkNull(this.get(FLD_SIG_COMMENT));
    }

    public void setSignatureComment(String sm) {
        this.set(FLD_SIG_COMMENT, sm);
    }

    public EntryType getMedicationType() {
        String typeNumber = (String)this.getExtInfoStoredObjectByKey(EXT_FLD_MEDICATIONTYPE);
        if (typeNumber != null && !typeNumber.isEmpty()) {
            return EntryType.byNumeric((int)Integer.parseInt(typeNumber));
        }
        return EntryType.UNKNOWN;
    }

    public void setMedicationType(EntryType type) {
        this.setExtInfoStoredObjectByKey(EXT_FLD_MEDICATIONTYPE, Integer.toString(type.numericValue()));
    }

    public EntryType getDisposalType() {
        String typeNumber = (String)this.getExtInfoStoredObjectByKey(EXT_FLD_DISPOSALTYPE);
        if (typeNumber != null && !typeNumber.isEmpty()) {
            return EntryType.byNumeric((int)Integer.parseInt(typeNumber));
        }
        return EntryType.UNKNOWN;
    }

    public void setDisposalType(EntryType type) {
        this.setExtInfoStoredObjectByKey(EXT_FLD_DISPOSALTYPE, Integer.toString(type.numericValue()));
    }

    public Artikel getArticle() {
        PersistentObjectFactory factory;
        PersistentObject ret;
        String[] parts;
        String articleString = this.get(FLD_ARTICLE);
        if (articleString != null && !articleString.isEmpty() && (parts = articleString.split("\\$")).length == 3 && (ret = (factory = new PersistentObjectFactory()).createFromString(parts[2])) instanceof Artikel) {
            return (Artikel)ret;
        }
        return null;
    }

    public String getAtcCode() {
        return this.get(FLD_ATC_CODE);
    }

    public String getSignatureFreeText() {
        return (String)this.getExtInfoStoredObjectByKey(EXT_FLD_FREETEXT);
    }

    public void setSignatureFreeText(String text) {
        if (text == null) {
            text = "";
        }
        this.setExtInfoStoredObjectByKey(EXT_FLD_FREETEXT, text);
    }

    public static class ArticleSignature {
        private ArticleDefaultSignature defaultSignature;
        private Artikel article;
        private String atcCode;
        private String morning;
        private String noon;
        private String evening;
        private String night;
        private String freeText;
        private String comment;
        private EntryType medicationType;
        private EntryType disposalType;
        private TimeTool endDate;

        public static ArticleSignature fromDefault(ArticleDefaultSignature defaultSignature) {
            ArticleSignature signature = new ArticleSignature(defaultSignature.getArticle(), defaultSignature.getAtcCode());
            signature.setMorning(defaultSignature.getSignatureMorning());
            signature.setNoon(defaultSignature.getSignatureNoon());
            signature.setEvening(defaultSignature.getSignatureEvening());
            signature.setNight(defaultSignature.getSignatureNight());
            signature.setFreeText(defaultSignature.getSignatureFreeText());
            signature.setComment(defaultSignature.getSignatureComment());
            signature.setMedicationType(defaultSignature.getMedicationType());
            signature.setDisposalType(defaultSignature.getDisposalType());
            signature.defaultSignature = defaultSignature;
            return signature;
        }

        public ArticleSignature(Artikel article, String atcCode) {
            this.article = article;
            this.atcCode = atcCode;
        }

        public ArticleDefaultSignature toDefault() {
            if (this.defaultSignature != null) {
                this.defaultSignature.setSignatureMorning(this.morning);
                this.defaultSignature.setSignatureNoon(this.noon);
                this.defaultSignature.setSignatureEvening(this.evening);
                this.defaultSignature.setSignatureNight(this.night);
                this.defaultSignature.setSignatureFreeText(this.freeText);
                this.defaultSignature.setSignatureComment(this.comment);
                if (this.medicationType != null) {
                    this.defaultSignature.setMedicationType(this.medicationType);
                }
                if (this.disposalType != null) {
                    this.defaultSignature.setDisposalType(this.disposalType);
                }
                if (this.atcCode != null && !this.atcCode.isEmpty()) {
                    this.defaultSignature.set(ArticleDefaultSignature.FLD_ATC_CODE, this.atcCode);
                    this.defaultSignature.set(ArticleDefaultSignature.FLD_ARTICLE, null);
                } else if (this.article != null) {
                    this.defaultSignature.set(ArticleDefaultSignature.FLD_ATC_CODE, null);
                    this.defaultSignature.set(ArticleDefaultSignature.FLD_ARTICLE, this.article.storeToString());
                }
            }
            return this.defaultSignature;
        }

        public void delete() {
            if (this.defaultSignature != null) {
                this.defaultSignature.delete();
            }
        }

        public String getFreeText() {
            return this.freeText;
        }

        public void setFreeText(String text) {
            this.freeText = text;
        }

        public String getMorning() {
            return this.morning;
        }

        public void setMorning(String morning) {
            this.morning = morning;
        }

        public String getNoon() {
            return this.noon;
        }

        public void setNoon(String noon) {
            this.noon = noon;
        }

        public String getEvening() {
            return this.evening;
        }

        public void setEvening(String evening) {
            this.evening = evening;
        }

        public String getNight() {
            return this.night;
        }

        public void setNight(String night) {
            this.night = night;
        }

        public String getSignatureAsDosisString() {
            String freeText = this.getFreeText();
            if (freeText != null && !freeText.isEmpty()) {
                return freeText;
            }
            String[] values = new String[]{this.morning, this.noon, this.evening, this.night};
            StringBuilder sb = new StringBuilder();
            if (this.signatureInfoExists(values)) {
                int i = 0;
                while (i < values.length) {
                    String string;
                    String string2 = string = values[i] == null || values[i].isEmpty() ? "0" : values[i];
                    if (i > 0) {
                        sb.append("-");
                    }
                    sb.append(string);
                    ++i;
                }
            }
            return sb.toString();
        }

        private boolean signatureInfoExists(String[] values) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                if (val != null && !val.isEmpty()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public EntryType getMedicationType() {
            return this.medicationType;
        }

        public void setMedicationType(EntryType medicationType) {
            this.medicationType = medicationType;
        }

        public EntryType getDisposalType() {
            return this.disposalType;
        }

        public void setDisposalType(EntryType disposalType) {
            this.disposalType = disposalType;
        }

        public void setAtcCode(String code) {
            this.atcCode = code;
            this.article = null;
        }

        public void setArticle(Artikel article) {
            this.article = article;
            this.atcCode = null;
        }

        public boolean isAtc() {
            return this.atcCode != null && !this.atcCode.isEmpty();
        }

        public boolean isPersistent() {
            return this.defaultSignature != null;
        }

        public void createPersistent() {
            if (this.isPersistent()) {
                return;
            }
            this.defaultSignature = this.isAtc() ? new ArticleDefaultSignature(null, this.atcCode) : new ArticleDefaultSignature(this.article, null);
        }

        public TimeTool getEndDate() {
            return this.endDate;
        }

        public void setEndDate(TimeTool endDate) {
            this.endDate = endDate;
        }
    }
}

