/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.nopo.adapter;

import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.data.Artikel;
import ch.rgw.tools.Money;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public class ArtikelAdapter
extends Artikel {
    private IArticle article;

    public ArtikelAdapter(IArticle article) {
        this.article = article;
    }

    @Override
    public String getId() {
        return this.article.getId();
    }

    @Override
    public int getAbgabeEinheit() {
        return this.article.getSellingSize();
    }

    @Override
    public String getCode() {
        return this.article.getCode();
    }

    @Override
    public String getCodeSystemCode() {
        return this.article.getCodeSystemCode();
    }

    @Override
    public String getCodeSystemName() {
        return this.article.getCodeSystemName();
    }

    @Override
    public String getName() {
        return this.article.getName();
    }

    @Override
    public String getPharmaCode() {
        Object value;
        String ret = "";
        try {
            Method method = this.article.getClass().getMethod("getPHAR", new Class[0]);
            ret = (String)method.invoke((Object)this.article, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException method) {
            // empty catch block
        }
        if (StringUtils.isBlank((CharSequence)ret) && (value = this.article.getExtInfo((Object)"Pharmacode")) instanceof String && ((String)value).length() == 7) {
            ret = (String)value;
        }
        return StringUtils.defaultString((String)ret);
    }

    @Override
    public String getEAN() {
        return this.article.getGtin();
    }

    @Override
    public String getGTIN() {
        return this.article.getGtin();
    }

    @Override
    public String getATC_code() {
        return this.article.getAtcCode();
    }

    @Override
    public int getPackungsGroesse() {
        return this.article.getPackageSize();
    }

    @Override
    public boolean isProduct() {
        return this.article.isProduct();
    }

    @Override
    public Money getVKPreis() {
        return this.article.getSellingPrice();
    }

    @Override
    public String getPackungsGroesseDesc() {
        return this.article.getPackageUnit();
    }

    @Override
    public String get(String field) {
        if ("Name".equals(field)) {
            return this.getName();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLabel() {
        return this.article.getLabel();
    }

    @Override
    public String storeToString() {
        return StoreToStringServiceHolder.getStoreToString(this.article);
    }

    @Override
    public boolean set(String field, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean set(String[] fields, String ... values) {
        throw new UnsupportedOperationException();
    }
}

