/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.DBConnection;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;

public class TestInitializer {
    public static final String FLAVOR_H2_MEM = "h2";
    public static final String FLAVOR_MYSQL = "mysql";
    public static final String FLAVOR_POSTGRES = "postgresql";

    public static JdbcLink initTestDBConnection(String dbflavor) {
        JdbcLink link = null;
        if (dbflavor == FLAVOR_H2_MEM) {
            link = new JdbcLink("org.h2.Driver", "jdbc:h2:mem:elexisFromScratch;DB_CLOSE_DELAY=-1", FLAVOR_H2_MEM);
        } else if (dbflavor == FLAVOR_MYSQL) {
            link = JdbcLink.createMySqlLink((String)"localhost", (String)"unittests");
        } else if (dbflavor == FLAVOR_POSTGRES) {
            link = JdbcLink.createPostgreSQLLink((String)"localhost", (String)"unittests");
        }
        if (link == null) {
            return link;
        }
        try {
            boolean connectionOk;
            String userName = dbflavor == FLAVOR_POSTGRES ? "elexistest" : "elexisTest";
            String password = "elexisTest";
            if (dbflavor == FLAVOR_H2_MEM) {
                userName = "sa";
                password = "";
            }
            if (connectionOk = link.connect(userName, password)) {
                return link;
            }
        }
        catch (Exception jle) {
            jle.printStackTrace();
            link = null;
        }
        return link;
    }

    protected static void executeDBScript(DBConnection connection, String filename) throws IOException {
        JdbcLink.Stm stm = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream is = PersistentObject.class.getResourceAsStream(filename);){
                stm = connection.getStatement();
                boolean success = stm.execScript(is, true, true);
                if (!success) {
                    Assert.fail((String)"Error executing script!");
                    throw new IOException();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            connection.releaseStatement(stm);
            throw throwable;
        }
        connection.releaseStatement(stm);
    }

    public static JdbcLink initDemoDbConnection() {
        File demo;
        Object demoDBLocation = System.getProperty("demo.database.location");
        if (demoDBLocation == null) {
            demoDBLocation = String.valueOf(CoreHub.getWritableUserDir()) + File.separator + "demoDB";
        }
        if ((demo = new File((String)demoDBLocation)).exists() && demo.isDirectory()) {
            JdbcLink link = JdbcLink.createH2Link((String)(demo.getAbsolutePath() + File.separator + "db"));
            try {
                boolean connectionOk = link.connect("sa", "");
                if (connectionOk) {
                    return link;
                }
            }
            catch (Exception jle) {
                jle.printStackTrace();
                Object var2_2 = null;
            }
        }
        return null;
    }
}

