/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.xml.ws.util.JAXWSUtils;
import jakarta.xml.ws.WebEndpoint;
import jakarta.xml.ws.WebServiceClient;
import jakarta.xml.ws.WebServiceException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import javax.xml.namespace.QName;

final class SCAnnotations {
    final ArrayList<QName> portQNames = new ArrayList();
    final ArrayList<Class> classes = new ArrayList();

    SCAnnotations(final Class<?> sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                WebServiceClient wsc = sc.getAnnotation(WebServiceClient.class);
                if (wsc == null) {
                    throw new WebServiceException("Service Interface Annotations required, exiting...");
                }
                String tns = wsc.targetNamespace();
                try {
                    JAXWSUtils.getFileOrURL(wsc.wsdlLocation());
                }
                catch (IOException e) {
                    throw new WebServiceException(e);
                }
                for (Method method : sc.getDeclaredMethods()) {
                    Class<?> seiClazz;
                    WebEndpoint webEndpoint = method.getAnnotation(WebEndpoint.class);
                    if (webEndpoint != null) {
                        String endpointName = webEndpoint.name();
                        QName portQName = new QName(tns, endpointName);
                        SCAnnotations.this.portQNames.add(portQName);
                    }
                    if ((seiClazz = method.getReturnType()) == Void.TYPE) continue;
                    SCAnnotations.this.classes.add(seiClazz);
                }
                return null;
            }
        });
    }
}

