/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal.spi;

import com.equo.chromium.swt.internal.spi.SchemeHandler;
import com.equo.chromium.swt.internal.spi.SchemeHandlerRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.cef.browser.CefFrame;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;

public class DelegatingCefResourceHandler
implements CefResourceHandler {
    private InputStream responseData;
    private Boolean processRequest;
    private final SchemeHandler schemeHandler;

    public DelegatingCefResourceHandler(SchemeHandler schemeHandler) {
        this.schemeHandler = schemeHandler;
    }

    public void processRequest(CefRequest request, CefFrame frame) {
        try {
            SchemeHandlerRequest schemeHandlerRequest = new SchemeHandlerRequest(request, frame);
            boolean shouldProcessRequest = this.schemeHandler.processRequest(schemeHandlerRequest);
            this.processRequest = shouldProcessRequest;
        }
        catch (AbstractMethodError | NoSuchMethodError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    @Override
    public boolean processRequest(CefRequest request, CefCallback callback) {
        boolean shouldProcessRequest;
        if (this.processRequest == null) {
            HashMap<String, String> headers = new HashMap<String, String>();
            request.getHeaderMap(headers);
            boolean shouldProcessRequest2 = this.schemeHandler.processRequest(request.getURL(), request.getMethod(), headers);
            this.processRequest = shouldProcessRequest2;
        }
        if ((shouldProcessRequest = this.processRequest.booleanValue()) && callback != null) {
            callback.Continue();
        }
        return shouldProcessRequest;
    }

    @Override
    public void getResponseHeaders(CefResponse response, IntRef responseLength, StringRef redirectUrl) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        response.getHeaderMap(responseHeaders);
        this.responseData = this.schemeHandler.getResponseData(responseHeaders);
        String userStatusCodeStringify = (String)responseHeaders.remove("X-Status-Code");
        String contentType = (String)responseHeaders.get("Content-Type");
        int statusCode = this.parseStatusCode(this.responseData, userStatusCodeStringify);
        if (statusCode != 404) {
            if (contentType != null) {
                String mimeType = contentType;
                String charset = null;
                int index = contentType.indexOf(";");
                if (index != -1) {
                    mimeType = contentType.substring(0, index);
                    if ((index = contentType.indexOf("charset=", index + 1)) != -1) {
                        charset = this.findCharset(contentType.substring(index));
                    }
                }
                response.setMimeType(mimeType);
                if (charset != null) {
                    response.setCharset(charset);
                } else {
                    Charset defaultCharset = this.schemeHandler.getDefaultCharset(mimeType);
                    if (defaultCharset != null) {
                        response.setCharset(defaultCharset.toString());
                    }
                }
            }
            response.setHeaderMap(responseHeaders);
        }
        response.setStatus(statusCode);
    }

    private Integer parseStatusCode(InputStream responseData, String userStatusCodeStringify) {
        if (userStatusCodeStringify != null) {
            try {
                Integer userStatusCode = Integer.valueOf(userStatusCodeStringify);
                if (userStatusCode != null && userStatusCode > 99 && userStatusCode < 600) {
                    return userStatusCode;
                }
            }
            catch (Exception e) {
                return 500;
            }
        }
        if (responseData == null) {
            return 404;
        }
        if (userStatusCodeStringify == null) {
            return 200;
        }
        return 404;
    }

    private String findCharset(String contentType) {
        StringBuilder charset = new StringBuilder();
        int i = contentType.indexOf("=") + 1;
        while (i < contentType.length()) {
            if (contentType.charAt(i) != '\"') {
                if (contentType.charAt(i) == ';') {
                    return charset.toString();
                }
                charset.append(contentType.charAt(i));
            }
            ++i;
        }
        if (charset.length() != 0) {
            return charset.toString();
        }
        return null;
    }

    @Override
    public boolean readResponse(byte[] dataOut, int bytesToRead, IntRef bytesRead, CefCallback callback) {
        int bytesReadPrim;
        block4: {
            if (this.responseData == null) {
                return false;
            }
            try {
                bytesReadPrim = this.responseData.read(dataOut, 0, bytesToRead);
                if (bytesReadPrim != -1) break block4;
                this.cancel();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.cancel();
                bytesRead.set(0);
                return false;
            }
        }
        bytesRead.set(bytesReadPrim);
        return true;
    }

    @Override
    public void cancel() {
        try {
            try {
                if (this.responseData != null) {
                    this.responseData.close();
                }
            }
            catch (IOException iOException) {
                this.responseData = null;
            }
        }
        finally {
            this.responseData = null;
        }
    }
}

