/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.equo.chromium.swt.internal.Chromium;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FindDialog
extends Dialog {
    private boolean isOpen = false;
    private Chromium.ExtraApi extraApi;
    private Control browser;
    private Shell parent;
    private Shell shell;
    private Text find;
    private Button caseSensitive;
    private Point locationInBrowser;

    public FindDialog(Chromium.ExtraApi extraApi, Shell shell) {
        super(shell);
        this.extraApi = extraApi;
    }

    public void open() {
        this.isOpen = true;
        this.browser = this.extraApi.getChromium().browser;
        this.parent = this.getParent();
        this.createShell();
        this.createFindText();
        this.createButtons();
        this.shell.pack();
        this.setInitialLocation(this.getBrowserLimits());
        this.locationInBrowser = Display.getCurrent().map(null, this.browser, this.shell.getLocation());
        this.shell.open();
        DragListener dragListener = new DragListener();
        this.shell.addMouseListener((MouseListener)dragListener);
        this.addFindListeners();
        BrowserDragListener browserDragListener = new BrowserDragListener();
        BrowserResizeListener browserResizeListener = new BrowserResizeListener();
        this.parent.addListener(20, (Listener)browserDragListener);
        this.parent.addListener(10, (Listener)browserDragListener);
        this.browser.addListener(11, (Listener)browserResizeListener);
        PaintListener paintListener = this.listenForReparenting();
        this.browser.addPaintListener(paintListener);
        Listener hideListener = this.createHideOrShowListener(false);
        Listener showListener = this.createHideOrShowListener(true);
        this.browser.getDisplay().addFilter(23, hideListener);
        this.browser.getDisplay().addFilter(22, showListener);
        this.browser.addListener(12, event -> {
            if (!this.shell.isDisposed()) {
                this.shell.close();
            }
        });
        this.shell.addListener(21, event -> {
            this.isOpen = false;
            this.extraApi.getChromium().findDialog = null;
            this.shell.removeMouseListener((MouseListener)dragListener);
            this.parent.removeListener(20, (Listener)browserDragListener);
            this.parent.removeListener(10, (Listener)browserDragListener);
            this.browser.removeListener(11, (Listener)browserResizeListener);
            this.browser.getDisplay().removeFilter(23, hideListener);
            this.browser.getDisplay().removeFilter(22, showListener);
            this.browser.removePaintListener(paintListener);
        });
    }

    private PaintListener listenForReparenting() {
        return new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (FindDialog.this.parent != FindDialog.this.browser.getShell() && FindDialog.this.parent.getBounds() != FindDialog.this.browser.getShell().getBounds() && !FindDialog.this.shell.isDisposed()) {
                    FindDialog.this.shell.close();
                }
            }
        };
    }

    private void createButtons() {
        this.createButton(8, "\u0245").addListener(13, event -> this.findText(this.isNotShift(event.stateMask), this.caseSensitive.getSelection()));
        this.createButton(8, "V").addListener(13, event -> this.findText(!this.isNotShift(event.stateMask), this.caseSensitive.getSelection()));
        this.caseSensitive = this.createButton(2, "Aa");
        this.caseSensitive.addListener(13, event -> this.findText(this.caseSensitive.getSelection(), this.caseSensitive.getSelection()));
        this.createButton(8, "\u2715").addListener(13, event -> this.shell.close());
    }

    private Button createButton(int style, String text) {
        Button button = new Button((Composite)this.shell, style);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, false);
        if ("cocoa".equals(SWT.getPlatform())) {
            gridData.heightHint = 35;
            gridData.widthHint = 40;
        }
        button.setLayoutData((Object)gridData);
        button.setText(text);
        return button;
    }

    private Listener createHideOrShowListener(boolean show) {
        return event -> {
            if (this.isAncestor(event.widget, this.browser) && !this.shell.isDisposed()) {
                this.shell.setVisible(show ? this.browser.getVisible() : show);
            }
        };
    }

    private boolean isAncestor(Widget widget, Control browser) {
        while (browser.getParent() != null) {
            if (browser.getParent() == widget) {
                return true;
            }
            browser = browser.getParent();
        }
        return false;
    }

    private void createShell() {
        this.shell = new Shell(this.parent, 0);
        GridLayout layout = new GridLayout(8, false);
        this.shell.setLayout((Layout)layout);
    }

    private void addFindListeners() {
        this.find.addModifyListener(e -> this.extraApi.find(this.find.getText(), true, this.caseSensitive.getSelection()));
        this.find.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    FindDialog.this.findText(FindDialog.this.isNotShift(e.stateMask), FindDialog.this.caseSensitive.getSelection());
                }
            }
        });
    }

    protected boolean isNotShift(int stateMask) {
        return (stateMask & 0x20000) == 0;
    }

    protected void findText(boolean forward, boolean caseSensitive) {
        this.extraApi.find(this.find.getText(), forward, caseSensitive);
    }

    private void createFindText() {
        this.find = new Text((Composite)this.shell, 2048);
        GridData gridData = new GridData(0x1000000, 0x1000000, false, true);
        if ("cocoa".equals(SWT.getPlatform())) {
            gridData.grabExcessVerticalSpace = false;
            gridData.heightHint = 22;
        }
        gridData.widthHint = "cocoa".equals(SWT.getPlatform()) ? 170 : 150;
        this.find.setLayoutData((Object)gridData);
    }

    private void setInitialLocation(Rectangle limits) {
        this.shell.setLocation(limits.x + this.browser.getBounds().width - this.shell.getBounds().width, limits.y);
    }

    private Rectangle getBrowserLimits() {
        return Display.getCurrent().map((Control)this.browser.getParent(), null, this.browser.getBounds());
    }

    protected Point checkLocationWithinBrowser(Rectangle newLimits, Point shellLocation) {
        int maxX = newLimits.x + newLimits.width - this.shell.getBounds().width;
        int maxY = newLimits.y + newLimits.height - this.shell.getBounds().height;
        if (shellLocation.x < newLimits.x) {
            shellLocation.x = newLimits.x;
        } else if (shellLocation.x > maxX) {
            shellLocation.x = maxX;
        }
        if (shellLocation.y < newLimits.y) {
            shellLocation.y = newLimits.y;
        } else if (shellLocation.y > maxY) {
            shellLocation.y = maxY;
        }
        return shellLocation;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void checkShellVisibility(Rectangle browserBounds, Rectangle shellBounds) {
        boolean shellHeightFitsInBrowser;
        boolean shellWidthFitsInBrowser;
        boolean bl = shellWidthFitsInBrowser = browserBounds.x + browserBounds.width >= shellBounds.width;
        shellWidthFitsInBrowser = shellWidthFitsInBrowser ? Display.getCurrent().getBounds().width - browserBounds.x > shellBounds.width : false;
        boolean bl2 = shellHeightFitsInBrowser = browserBounds.y + browserBounds.height >= shellBounds.height;
        shellHeightFitsInBrowser = shellHeightFitsInBrowser ? Display.getCurrent().getBounds().height - browserBounds.y > shellBounds.height : false;
        boolean shellFitsInResizedBrowser = shellBounds.height < browserBounds.height && shellBounds.width < browserBounds.width;
        this.shell.setVisible(shellWidthFitsInBrowser && shellHeightFitsInBrowser && shellFitsInResizedBrowser);
    }

    class BrowserDragListener
    implements Listener {
        BrowserDragListener() {
        }

        public void handleEvent(Event event) {
            Point shellLocation = Display.getCurrent().map(FindDialog.this.browser, null, FindDialog.this.locationInBrowser);
            FindDialog.this.shell.setLocation(shellLocation);
            FindDialog.this.checkShellVisibility(FindDialog.this.getBrowserLimits(), FindDialog.this.shell.getBounds());
        }
    }

    class BrowserResizeListener
    implements Listener {
        BrowserResizeListener() {
        }

        public void handleEvent(Event event) {
            Point shellLocation = FindDialog.this.checkLocationWithinBrowser(FindDialog.this.getBrowserLimits(), FindDialog.this.shell.getLocation());
            FindDialog.this.shell.setLocation(shellLocation);
            FindDialog.this.locationInBrowser = Display.getCurrent().map(null, FindDialog.this.browser, shellLocation);
            FindDialog.this.checkShellVisibility(FindDialog.this.getBrowserLimits(), FindDialog.this.shell.getBounds());
        }
    }

    class DragListener
    implements MouseListener,
    MouseMoveListener {
        private Point dragOffset;

        DragListener() {
        }

        public void mouseDown(MouseEvent e) {
            this.dragOffset = new Point(e.x, e.y);
            FindDialog.this.shell.addMouseMoveListener((MouseMoveListener)this);
        }

        public void mouseUp(MouseEvent e) {
            this.dragOffset = null;
            FindDialog.this.shell.removeMouseMoveListener((MouseMoveListener)this);
        }

        public void mouseMove(MouseEvent e) {
            if (this.dragOffset != null) {
                Point newLocation = new Point(e.x, e.y);
                newLocation = FindDialog.this.shell.toDisplay(newLocation);
                newLocation.x -= this.dragOffset.x;
                newLocation.y -= this.dragOffset.y;
                Rectangle limits = Display.getCurrent().map((Control)FindDialog.this.browser.getParent(), null, FindDialog.this.browser.getBounds());
                newLocation = FindDialog.this.checkLocationWithinBrowser(limits, newLocation);
                FindDialog.this.shell.setLocation(newLocation);
                FindDialog.this.locationInBrowser = Display.getCurrent().map(null, FindDialog.this.browser, FindDialog.this.shell.getLocation());
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }
}

