/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.ChromiumBrowser;
import com.equo.chromium.Storage;
import com.equo.chromium.internal.Engine;
import com.equo.chromium.internal.Subscriber;
import com.equo.chromium.swt.Log;
import com.equo.chromium.swt.internal.spi.CommRouterHandler;
import com.equo.chromium.swt.internal.spi.CommunicationManager;
import com.equo.chromium.swt.internal.spi.ScriptExtension;
import com.equo.chromium.utils.EventAction;
import com.equo.chromium.utils.EventType;
import com.equo.chromium.utils.PdfPrintSettings;
import com.equo.chromium.utils.StorageType;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefCallback;
import org.cef.callback.CefCompletionCallback;
import org.cef.callback.CefDevToolsMessageObserverAdapter;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefQueryCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefFindHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.cef.handler.CefPrintHandlerAdapter;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.misc.Rectangle;
import org.cef.network.CefRequest;

public abstract class IndependentBrowser
implements ChromiumBrowser {
    private CefClient clientHandler;
    private CefBrowser browser;
    private CefRequestContext requestContext;
    private CompletableFuture<Boolean> created = new CompletableFuture();
    private boolean ignoreCertificateErrors = false;
    private List<ChromiumBrowser.ConsoleListener> consoleListeners = new ArrayList<ChromiumBrowser.ConsoleListener>();
    private String lastSearch = null;
    private static final String DATA_TEXT_URL = "data:text/html;base64,";
    private Storage localStorage;
    private Storage sessionStorage;
    private static ExecutorService executor = null;
    private int messageId = 0;
    private volatile Subscriber subscriber = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscriber getSubscriber() {
        if (this.subscriber == null) {
            IndependentBrowser independentBrowser = this;
            synchronized (independentBrowser) {
                if (this.subscriber == null) {
                    this.subscriber = new Subscriber(this);
                }
            }
        }
        return this.subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService getExecutor() {
        if (executor != null) return executor;
        Class<IndependentBrowser> clazz = IndependentBrowser.class;
        synchronized (IndependentBrowser.class) {
            if (executor != null) return executor;
            executor = Executors.newSingleThreadExecutor(r -> {
                Thread thread = new Thread(r, "chromium-MessageRoute");
                thread.setDaemon(true);
                return thread;
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return executor;
        }
    }

    @Override
    public CompletableFuture<Boolean> isCreated() {
        return this.created;
    }

    protected CefBrowser getBrowser() {
        return this.browser;
    }

    protected void setBrowser(CefBrowser browser) {
        this.browser = browser;
    }

    protected CefClient getClientHandler() {
        return this.clientHandler;
    }

    protected void setClientHandler(CefClient clientHandler) {
        this.clientHandler = clientHandler;
    }

    protected void createClient() {
        this.clientHandler = Engine.createClient();
        this.clientHandler.setDisposeAction(() -> {
            CefBrowser browser = this.getBrowser();
            if (browser != null) {
                browser.setReference(null);
                this.disposeInBrowser();
            }
            this.clientHandler.removeLifeSpanHandler();
            this.clientHandler.removeDisplayHandler();
            this.clientHandler.removeRequestHandler();
            this.clientHandler.removeLoadHandler();
            this.clientHandler.removeFindHandler();
            this.clientHandler.removePrintHandler();
            this.clientHandler.removeDialogHandler();
            this.clientHandler.removeFocusHandler();
            this.clientHandler.removeDownloadHandler();
            this.clientHandler.removeJSDialogHandler();
            if (this.subscriber != null) {
                this.subscriber.dispose();
                this.subscriber = null;
            }
            if (executor != null && !this.getExecutor().isShutdown()) {
                this.getExecutor().shutdown();
                executor = null;
            }
        });
        this.clientHandler.addLifeSpanHandler(new CefLifeSpanHandlerAdapter(){

            @Override
            public void onAfterCreated(CefBrowser browser) {
                if (Engine.getDebuggingPort() > 0 && Boolean.getBoolean("chromium.debug")) {
                    IndependentBrowser.this.getDevtoolsUrl().thenAccept(devToolsUrl -> IndependentBrowser.this.debugPrint("DevTools browser url: " + devToolsUrl));
                }
                IndependentBrowser.this.getSubscriber().onAfterCreatedNotify(browser);
            }
        });
        this.clientHandler.addRequestHandler(new CefRequestHandlerAdapter(){

            @Override
            public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefCallback callback) {
                if (IndependentBrowser.this.isIgnoreCertificateErrors()) {
                    callback.Continue();
                    return true;
                }
                if (IndependentBrowser.this.handleCertificateProperty()) {
                    return false;
                }
                callback.cancel();
                return true;
            }
        });
        this.clientHandler.addDisplayHandler(new CefDisplayHandlerAdapter(){

            @Override
            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                IndependentBrowser.this.getSubscriber().onConsoleMessageNotify(level, message, source, line);
                return IndependentBrowser.this.onConsoleMessage(browser, level, message, source, line);
            }

            @Override
            public void onFullscreenModeChange(CefBrowser browser, boolean fullscreen) {
                IndependentBrowser.this.getSubscriber().onFullscreenModeChangeNotify(fullscreen);
            }
        });
        this.clientHandler.addLoadHandler(new CefLoadHandler(){

            @Override
            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                IndependentBrowser.this.getSubscriber().onLoadingStateChangeNotify(isLoading, browser.getURL());
            }

            @Override
            public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                IndependentBrowser.this.getSubscriber().onLoadStartNotify();
            }

            @Override
            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                IndependentBrowser.this.getSubscriber().onLoadErrorNotify(errorCode.getCode());
            }

            @Override
            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                IndependentBrowser.this.getSubscriber().onLoadEndNotify(frame);
            }
        });
        this.clientHandler.addFindHandler(new CefFindHandler(){

            @Override
            public void onFindResult(CefBrowser browser, int identifier, int count, Rectangle selectionRect, int activeMatchOrdinal, boolean finalUpdate) {
                if (finalUpdate) {
                    IndependentBrowser.this.getSubscriber().onFindResultNotify(count, activeMatchOrdinal);
                }
            }
        });
        this.clientHandler.addDisplayHandler(new CefDisplayHandlerAdapter(){

            @Override
            public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
                IndependentBrowser.this.getSubscriber().onAddressChangeNotify(browser.isLoading(), url);
            }
        });
        this.clientHandler.addPrintHandler(new CefPrintHandlerAdapter(){});
        CommunicationManager commManager = CommunicationManager.get();
        if (commManager != null) {
            CefMessageRouter commRouter = CommRouterHandler.createRouter();
            commRouter.addHandler(new CommRouterHandler(commManager), true);
            this.clientHandler.addMessageRouter(commRouter);
        }
        if (!Boolean.getBoolean("chromium.disable_script_extensions")) {
            Iterator<ScriptExtension> scriptExtensions = ScriptExtension.get();
            scriptExtensions.forEachRemaining(scriptExtensionProvider -> {
                List<CefMessageRouter> routers = ScriptExtension.createRouter(scriptExtensionProvider.getScriptExtensions());
                routers.stream().forEach(router -> this.clientHandler.addMessageRouter((CefMessageRouter)router));
            });
        }
    }

    protected void disposeInBrowser() {
    }

    public static void subscribeOnAfterCreated(EventAction eventAction) {
        Subscriber.subscribeOnAfterCreated(eventAction);
    }

    public long subscribe(EventType eventType, EventAction action) {
        return this.getSubscriber().subscribe(eventType, action);
    }

    public boolean unSubscribe(long idEvent) {
        return this.getSubscriber().unSubscribe(idEvent);
    }

    public void unSubscribeAll() {
        this.getSubscriber().unSubscribeAll();
    }

    protected CefRequestContext createRequestContext() {
        this.requestContext = this.isIgnoreCertificateErrors() ? CefRequestContext.createContext(null) : null;
        return this.requestContext;
    }

    protected CefRequestContext getRequestContext() {
        return this.requestContext;
    }

    protected boolean handleCertificateProperty() {
        String derpem = System.getProperty("chromium.ssl", "");
        if (!derpem.isEmpty()) {
            if (Files.isReadable(Paths.get(derpem, new String[0]))) {
                try {
                    byte[] derpemBytes = Files.readAllBytes(Paths.get(derpem, new String[0]));
                    System.setProperty("chromium.ssl.cert", new String(derpemBytes, "ASCII").replaceAll("\\r\\n", "\n"));
                }
                catch (IOException e) {
                    this.debugPrint("Failed to read file " + derpem);
                    e.printStackTrace();
                }
            } else {
                this.debugPrint("Cannot read file '" + derpem + "', trying as string");
                System.setProperty("chromium.ssl.cert", derpem.replaceAll("\\r\\n", "\n"));
            }
            return true;
        }
        return false;
    }

    private void debugPrint(String log) {
        Log.debug(log, this.getBrowser());
    }

    protected boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
        boolean prevent = false;
        for (ChromiumBrowser.ConsoleListener listener : this.consoleListeners) {
            if (!listener.message(level.ordinal(), message, source, line)) continue;
            prevent = true;
        }
        return prevent;
    }

    @Override
    public boolean isClosed() {
        return this.getBrowser().isClosedOrClosing();
    }

    @Override
    public boolean setUrl(String url) {
        this.created.thenRun(() -> this.browser.loadURL(url));
        return true;
    }

    @Override
    public boolean setText(String html) {
        this.created.thenRun(() -> {
            String texturl = DATA_TEXT_URL + Base64.getEncoder().encodeToString(html.getBytes());
            this.browser.loadURL(texturl);
        });
        return true;
    }

    @Override
    public void find(String search, boolean forward, boolean matchCase) {
        if (search == null || search.isEmpty()) {
            this.getBrowser().stopFinding(true);
        } else {
            if (this.lastSearch != null && !this.lastSearch.contains(search)) {
                this.getBrowser().stopFinding(true);
            }
            this.getBrowser().find(search, forward, matchCase, true);
            this.lastSearch = search;
        }
    }

    @Override
    public void zoom(double zoomLevel) {
        this.getBrowser().setZoomLevel(zoomLevel);
        this.getSubscriber().notifySubscribers(EventType.onZoomChanged);
    }

    @Override
    public double getZoom() {
        return this.getBrowser().getZoomLevel();
    }

    @Override
    public void executeJavaScript(String script) {
        this.created.thenRun(() -> this.getBrowser().executeJavaScript(script, "", 0));
    }

    @Override
    public void executeJavacript(String script) {
        this.executeJavaScript(script);
    }

    @Override
    public void addConsoleListener(ChromiumBrowser.ConsoleListener listener) {
        this.consoleListeners.add(listener);
    }

    @Override
    public void removeConsoleListener(ChromiumBrowser.ConsoleListener listener) {
        this.consoleListeners.remove(listener);
    }

    @Override
    public CompletableFuture<byte[]> captureScreenshot() {
        return this.captureScreenshot(0, 0, 0, 0, 1);
    }

    @Override
    public CompletableFuture<byte[]> captureScreenshot(int x, int y, int width, int height, int scale) {
        final CompletableFuture<byte[]> screenshotResult = new CompletableFuture<byte[]>();
        new CefDevToolsMessageObserverAdapter(this.getBrowser()){

            @Override
            public void onDevToolsMethodResult(CefBrowser cefBrowser, int messageId, boolean success, String result, int resultSize) {
                try {
                    try {
                        JsonObject json = (JsonObject)Jsoner.deserialize(result);
                        screenshotResult.complete(json.getOrDefault("data", "").getBytes(StandardCharsets.UTF_8));
                    }
                    catch (JsonException e) {
                        screenshotResult.complete("".getBytes(StandardCharsets.UTF_8));
                        this.dispose();
                    }
                }
                finally {
                    this.dispose();
                }
            }
        };
        JsonObject jsonMessage = new JsonObject();
        jsonMessage.put("id", this.messageId++);
        jsonMessage.put("method", "Page.captureScreenshot");
        JsonObject clip = new JsonObject();
        if (width > 0 && height > 0) {
            JsonObject viewport = new JsonObject();
            viewport.put("x", x);
            viewport.put("y", y);
            viewport.put("width", width);
            viewport.put("height", height);
            viewport.put("scale", scale);
            clip.put("clip", viewport);
            jsonMessage.put("params", clip);
        }
        String message = jsonMessage.toJson();
        this.getBrowser().sendDevToolsMessage(message, message.length());
        return screenshotResult;
    }

    @Override
    public void ignoreCertificateErrors(boolean enable) {
        this.ignoreCertificateErrors = enable;
        if (!enable && this.getBrowser() != null) {
            CefCompletionCallback callback = new CefCompletionCallback(){

                @Override
                public void onComplete() {
                    Log.debug("certificate exceptions cleared");
                }
            };
            if (this.getRequestContext() == null) {
                CefRequestContext.getGlobalContext().clearCertificateExceptions(callback);
            } else {
                this.getRequestContext().clearCertificateExceptions(callback);
            }
        }
    }

    public boolean isIgnoreCertificateErrors() {
        return this.ignoreCertificateErrors;
    }

    @Override
    public List<Object> getErrors() {
        return new ArrayList<Object>();
    }

    @Override
    public boolean close() {
        this.isCreated().thenRun(() -> {
            CefBrowser browser = this.getBrowser();
            if (browser != null) {
                browser.setCloseAllowed();
                browser.close(true);
                CefClient client = browser.getClient();
                if (client != null) {
                    client.dispose();
                }
            }
        });
        return true;
    }

    @Override
    public Object getUIComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLoading() {
        return this.getBrowser().isLoading();
    }

    @Override
    public void goBack() {
        this.getBrowser().goBack();
    }

    @Override
    public void goForward() {
        this.getBrowser().goForward();
    }

    @Override
    public boolean canGoBack() {
        return this.getBrowser().canGoBack();
    }

    @Override
    public boolean canGoForward() {
        return this.getBrowser().canGoForward();
    }

    @Override
    public void reload() {
        this.getBrowser().reload();
    }

    @Override
    public void stop() {
        this.getBrowser().stopLoad();
    }

    @Override
    public CompletableFuture<String> text() {
        final CompletableFuture<String> result = new CompletableFuture<String>();
        this.getBrowser().getMainFrame().getSource(new CefStringVisitor(){

            @Override
            public void visit(String text) {
                result.complete(text);
            }
        });
        return result;
    }

    @Override
    public String getUrl() {
        return this.getBrowser().getURL();
    }

    @Override
    public CompletableFuture<String> getDevtoolsUrl() {
        int port = Engine.getDebuggingPort();
        if (port == 0) {
            CompletableFuture<String> failed = new CompletableFuture<String>();
            failed.completeExceptionally(new IllegalStateException("No debug port specified. DevTools URL cannot be created."));
            return failed;
        }
        return this.sendDevToolsMessage("Target.getTargetInfo", new ArrayList<Map.Entry<String, Object>>(), "targetInfo").thenApply(result -> {
            String targetId = (String)((JsonObject)result).get("targetId");
            return "http://localhost:" + port + "/devtools/inspector.html?ws=localhost:" + port + "/devtools/page/" + targetId;
        });
    }

    public long getNativeWindowHandle() {
        return this.getBrowser().getNativeWindowHandle();
    }

    public CompletableFuture<Object> sendDevToolsMessage(String devToolsMethod, List<Map.Entry<String, Object>> params, final String wanted) {
        final CompletableFuture<Object> messageResult = new CompletableFuture<Object>();
        this.created.thenRun(() -> {
            final int id = this.messageId++;
            new CefDevToolsMessageObserverAdapter(this.getBrowser()){

                @Override
                public void onDevToolsMethodResult(CefBrowser cefBrowser, int messageId, boolean success, String result, int resultSize) {
                    IndependentBrowser.this.debugPrint("onDevToolsMethodResult: " + result);
                    if (id != messageId) {
                        return;
                    }
                    try {
                        try {
                            JsonObject json = (JsonObject)Jsoner.deserialize(result);
                            messageResult.complete(wanted == null || wanted.isEmpty() ? json : json.get(wanted));
                        }
                        catch (JsonException e) {
                            messageResult.completeExceptionally(e.getCause());
                            this.dispose();
                        }
                    }
                    finally {
                        this.dispose();
                    }
                }
            };
            JsonObject jsonMessage = new JsonObject();
            jsonMessage.put("id", id);
            jsonMessage.put("method", devToolsMethod);
            jsonMessage.put("params", this.createJsonObject(params));
            String devToolsMessage = jsonMessage.toJson();
            this.getBrowser().sendDevToolsMessage(devToolsMessage, devToolsMessage.length());
        });
        return messageResult;
    }

    private JsonObject createJsonObject(List<Map.Entry<String, Object>> params) {
        JsonObject jsonParams = new JsonObject();
        for (Map.Entry<String, Object> entry : params) {
            this.putValue(jsonParams, entry.getKey(), entry.getValue());
        }
        return jsonParams;
    }

    private JsonObject createJsonObjectFromMap(Map<?, ?> map) {
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry<?, ?> subEntry : map.entrySet()) {
            String subKey = String.valueOf(subEntry.getKey());
            Object subValue = subEntry.getValue();
            this.putValue(jsonObject, subKey, subValue);
        }
        return jsonObject;
    }

    private void putValue(JsonObject jsonObject, String key, Object value) {
        if (value instanceof Map) {
            jsonObject.put(key, this.createJsonObjectFromMap((Map)value));
        } else {
            jsonObject.put(key, value);
        }
    }

    public void addMessageRoute(String queryFunctionName, String cancelQueryFunctionName, final Function<String, String> result) {
        this.isCreated().thenRun(() -> {
            CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig(queryFunctionName, cancelQueryFunctionName);
            CefMessageRouter messageRouter_ = CefMessageRouter.create(config);
            CefMessageRouterHandlerAdapter newHandler = new CefMessageRouterHandlerAdapter(){

                @Override
                public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                    try {
                        IndependentBrowser.this.getExecutor().submit(() -> callback.success((String)result.apply(request)));
                        return true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            };
            messageRouter_.addHandler(newHandler, false);
            this.getClientHandler().addMessageRouter(messageRouter_);
        });
    }

    @Override
    public void showDevTools() {
        this.isCreated().thenRun(() -> this.getBrowser().getDevTools().createImmediately());
    }

    @Override
    public CompletableFuture<Boolean> printToPdf(String path, PdfPrintSettings settings) {
        final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        CefPdfPrintSettings pdfPrintSettings = new CefPdfPrintSettings();
        if (settings != null) {
            pdfPrintSettings.display_header_footer = settings.display_header_footer;
            pdfPrintSettings.footer_template = settings.footer_template;
            pdfPrintSettings.header_template = settings.header_template;
            pdfPrintSettings.landscape = settings.landscape;
            pdfPrintSettings.print_background = settings.print_background;
            pdfPrintSettings.page_ranges = settings.page_ranges;
            pdfPrintSettings.paper_width = settings.paper_width;
            pdfPrintSettings.paper_height = settings.paper_height;
            pdfPrintSettings.prefer_css_page_size = settings.prefer_css_page_size;
            pdfPrintSettings.scale = settings.scale;
            pdfPrintSettings.margin_top = settings.margin_top;
            pdfPrintSettings.margin_right = settings.margin_right;
            pdfPrintSettings.margin_bottom = settings.margin_bottom;
            pdfPrintSettings.margin_left = settings.margin_left;
            if (settings.margin_type != null) {
                pdfPrintSettings.margin_type = CefPdfPrintSettings.MarginType.valueOf(settings.margin_type.name());
            }
        }
        this.isCreated().thenRun(() -> this.getBrowser().printToPDF(path, pdfPrintSettings, new CefPdfPrintCallback(){

            @Override
            public void onPdfPrintFinished(String path, boolean ok) {
                result.complete(ok);
            }
        }));
        return result;
    }

    @Override
    public CompletableFuture<Boolean> printToPdf(String path) {
        return this.printToPdf(path, null);
    }

    public static void checkToolkit(Engine.BrowserType browserType) {
        if (Engine.browserTypeInitialized == null || browserType == Engine.browserTypeInitialized) {
            return;
        }
        throw new UnsupportedOperationException("You cannot initialize such browsers, because browsers of type " + (Object)((Object)Engine.browserTypeInitialized) + " are already initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Storage getLocalStorage() {
        if (this.localStorage != null) return this.localStorage;
        Class<Storage> clazz = Storage.class;
        synchronized (Storage.class) {
            if (this.localStorage != null) return this.localStorage;
            this.localStorage = new Storage(this, StorageType.LOCAL);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.localStorage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Storage getSessionStorage() {
        if (this.sessionStorage != null) return this.sessionStorage;
        Class<Storage> clazz = Storage.class;
        synchronized (Storage.class) {
            if (this.sessionStorage != null) return this.sessionStorage;
            this.sessionStorage = new Storage(this, StorageType.SESSION);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sessionStorage;
        }
    }
}

