/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.IFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class Tree<T> {
    public IFilter filter;
    protected Tree<T> parent;
    protected Tree<T> first;
    protected Tree<T> next;
    public T contents;

    public Tree(Tree<T> p, T elem) {
        this.contents = elem;
        this.parent = p;
        this.first = null;
        this.filter = null;
        if (this.parent != null) {
            this.next = this.parent.first;
            this.parent.first = this;
        }
    }

    public Tree(Tree<T> parent, T elem, Comparator<T> comp) {
        this.parent = parent;
        this.contents = elem;
        if (parent != null) {
            this.next = parent.first;
            Tree<T> prev = null;
            while (this.next != null && comp.compare(this.next.contents, elem) < 0) {
                prev = this.next;
                this.next = this.next.next;
            }
            if (prev == null) {
                parent.first = this;
            } else {
                prev.next = this;
            }
        }
    }

    public Tree(Tree<T> p, T elem, IFilter f) {
        this(p, elem);
        this.filter = f;
    }

    public void setFilter(IFilter f) {
        this.filter = f;
        Tree<T> cursor = this.first;
        while (cursor != null) {
            cursor.setFilter(f);
            cursor = cursor.next;
        }
    }

    public Tree<T> add(T elem) {
        Tree<T> ret = new Tree<T>(this, elem, this.filter);
        return ret;
    }

    public void remove(Tree<T> subtree) {
        if (this.first == null) {
            return;
        }
        if (this.first.equals(subtree)) {
            this.first = subtree.next;
            return;
        }
        Tree<T> runner = this.first;
        while (!runner.next.equals(subtree)) {
            runner = runner.next;
            if (runner != null) continue;
            return;
        }
        runner.next = subtree.next;
    }

    public synchronized Tree<T> move(Tree<T> newParent) {
        Tree<T> oldParent = this.parent;
        if (oldParent != null) {
            oldParent.remove(this);
        }
        this.parent = newParent;
        this.next = newParent.first;
        newParent.first = this;
        return this;
    }

    public synchronized void merge(Tree<T> newChild) {
        Tree<T> tExist = this.find(newChild.contents, false);
        if (tExist != null) {
            Tree<T> ts = newChild.first;
            while (ts != null) {
                tExist.merge(ts);
                ts = ts.next;
            }
            if (newChild.first == null) {
                newChild.getParent().remove(newChild);
            }
        } else {
            newChild.move(this);
        }
    }

    public synchronized void clear() {
        for (Tree<T> t : this.getChildren()) {
            this.remove(t);
        }
    }

    public Collection<Tree<T>> getChildren() {
        ArrayList<Tree<T>> al = new ArrayList<Tree<T>>();
        Tree<T> cursor = this.first;
        while (cursor != null) {
            if (this.filter == null) {
                al.add(cursor);
            } else if (this.filter.select(cursor.contents) || cursor.hasChildren()) {
                al.add(cursor);
            }
            cursor = cursor.next;
        }
        return al;
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public Tree<T> getFirstChild() {
        return this.first;
    }

    public Tree<T> getNextSibling() {
        return this.next;
    }

    public boolean hasChildren() {
        if (this.filter == null) {
            return this.first != null;
        }
        Tree<T> cursor = this.first;
        while (cursor != null) {
            if (this.filter.select(cursor.contents) || cursor.hasChildren()) {
                return true;
            }
            cursor = cursor.next;
        }
        return false;
    }

    public Tree<T>[] toArray() {
        return (Tree[])this.getAll().toArray();
    }

    public Collection<Tree<T>> getAll() {
        ArrayList<Tree<T>> al = new ArrayList<Tree<T>>();
        Tree<T> child = this.first;
        while (child != null) {
            al.add(child);
            al.addAll(child.getAll());
            child = child.next;
        }
        return al;
    }

    public Tree<T> find(Object o, boolean deep) {
        for (Tree<T> t : this.getChildren()) {
            Tree<T> ct;
            if (t.contents.equals(o)) {
                return t;
            }
            if (!deep || (ct = t.find(o, true)) == null) continue;
            return ct;
        }
        return null;
    }
}

