/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class PasswordEncryptionService {
    public boolean authenticate(char[] attemptedPassword, byte[] encryptedPassword, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] encryptedAttemptedPassword = this.getEncryptedPassword(attemptedPassword, salt);
        return Arrays.equals(encryptedPassword, encryptedAttemptedPassword);
    }

    public boolean authenticate(char[] attemptedPassword, String encryptedPassword, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException, DecoderException {
        return this.authenticate(attemptedPassword, Hex.decodeHex((char[])encryptedPassword.toCharArray()), Hex.decodeHex((char[])salt.toCharArray()));
    }

    public byte[] getEncryptedPassword(char[] password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String algorithm = "PBKDF2WithHmacSHA1";
        int derivedKeyLength = 160;
        int iterations = 20000;
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, derivedKeyLength);
        SecretKeyFactory f = SecretKeyFactory.getInstance(algorithm);
        return f.generateSecret(spec).getEncoded();
    }

    public String getEncryptedPasswordAsHexString(String password, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException, DecoderException {
        byte[] encryptedPassword = this.getEncryptedPassword(password.toCharArray(), Hex.decodeHex((char[])salt.toCharArray()));
        return Hex.encodeHexString((byte[])encryptedPassword);
    }

    public byte[] generateSalt() throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        return salt;
    }

    public String generateSaltAsHexString() throws NoSuchAlgorithmException {
        return Hex.encodeHexString((byte[])this.generateSalt());
    }
}

