/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IDocumentTemplate;
import ch.elexis.core.model.ITag;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;

public interface IDocumentStore {
    public String getId();

    public String getName();

    public List<IDocument> getDocuments(@NonNull String var1, @Nullable String var2, @Nullable ICategory var3, @Nullable List<ITag> var4);

    public List<IDocumentTemplate> getDocumentTemplates(boolean var1);

    public Optional<IDocument> loadDocument(String var1);

    public Optional<InputStream> loadContent(IDocument var1);

    public IDocument createDocument(@NonNull String var1, String var2, String var3);

    public IDocument saveDocument(IDocument var1) throws ElexisException;

    public IDocument saveDocument(IDocument var1, InputStream var2) throws ElexisException;

    public void removeDocument(IDocument var1);

    public List<ICategory> getCategories();

    public ICategory getCategoryDefault();

    default public Optional<ICategory> getCategoryByName(String name) {
        return this.getCategories().stream().filter(c -> name.equalsIgnoreCase(c.getName())).findFirst();
    }

    public ICategory createCategory(String var1);

    public void removeCategory(IDocument var1, String var2) throws IllegalStateException;

    public void renameCategory(ICategory var1, String var2);

    public void removeCategory(ICategory var1, @Nullable ICategory var2);

    default public boolean isAllowed(Capability restricted) {
        return true;
    }

    public Optional<Object> getPersistenceObject(IDocument var1);

    public static enum Capability {
        CATEGORY,
        KEYWORDS;

    }
}

