/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mediorder;

import ch.elexis.core.mediorder.MediorderEntryState;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.IStickerService;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.util.List;
import java.util.Optional;

public class MediorderUtil {
    public static MediorderEntryState determineState(IStockEntry stockEntry) {
        int minimumStock = stockEntry.getMinimumStock();
        int maximumStock = stockEntry.getMaximumStock();
        int currentStock = stockEntry.getCurrentStock();
        MediorderEntryState state = MediorderEntryState.INVALID;
        if (minimumStock > 0 && maximumStock > 0 && currentStock > 0) {
            state = currentStock > maximumStock ? MediorderEntryState.INVALID : (currentStock == minimumStock ? MediorderEntryState.IN_STOCK : MediorderEntryState.PARTIALLY_IN_STOCK);
        } else if (minimumStock > 0 && maximumStock > 0 && currentStock == 0) {
            IOrderService orderService = OsgiServiceUtil.getService(IOrderService.class).orElseThrow(() -> new IllegalStateException("no order service found"));
            IOrderEntry order = orderService.findOpenOrderEntryForStockEntry(stockEntry);
            OsgiServiceUtil.ungetService(orderService);
            if (order != null) {
                state = minimumStock == maximumStock ? MediorderEntryState.ORDERED : MediorderEntryState.PARTIALLY_ORDERED;
                state.setOrderEntry(order);
            }
            ICoverageService coverageService = OsgiServiceUtil.getService(ICoverageService.class).orElseThrow(() -> new IllegalStateException("no coverage service found"));
            Optional<List> encounter = coverageService.getLatestOpenCoverage(stockEntry.getStock().getOwner().asIPatient()).flatMap(coverageService::getLatestEncounter);
            OsgiServiceUtil.ungetService(coverageService);
            boolean alreadyBilled = encounter.map(IEncounter::getBilled).orElse(List.of()).stream().anyMatch(bill -> stockEntry.getArticle().getId().equals(bill.getBillable().getId()));
            if (alreadyBilled) {
                state = MediorderEntryState.IN_STOCK;
                return state;
            }
            state = minimumStock == maximumStock ? MediorderEntryState.REQUESTED : (minimumStock > maximumStock ? MediorderEntryState.PARTIALLY_REQUESTED : MediorderEntryState.INVALID);
        } else if (minimumStock == 0 && maximumStock > 0 && currentStock == 0) {
            state = MediorderEntryState.AWAITING_REQUEST;
        }
        state.setStockEntry(stockEntry);
        return state;
    }

    public static int calculateStockState(IStock stock) {
        boolean allEnabledForPea = true;
        boolean hasInStock = false;
        boolean hasPartiallyInStock = false;
        boolean hasOtherStatus = false;
        for (IStockEntry entry : stock.getStockEntries()) {
            MediorderEntryState entryState = MediorderUtil.determineState(entry);
            switch (entryState) {
                case AWAITING_REQUEST: {
                    break;
                }
                case IN_STOCK: {
                    hasInStock = true;
                    break;
                }
                case PARTIALLY_IN_STOCK: {
                    hasPartiallyInStock = true;
                    allEnabledForPea = false;
                    break;
                }
                case INVALID: 
                case ORDERED: 
                case PARTIALLY_ORDERED: {
                    allEnabledForPea = false;
                    hasOtherStatus = true;
                    break;
                }
                default: {
                    allEnabledForPea = false;
                    hasOtherStatus = true;
                }
            }
        }
        if (hasPartiallyInStock) {
            return 2;
        }
        if (hasInStock && allEnabledForPea) {
            IModelService coreModelService = OsgiServiceUtil.getService(IModelService.class, "(service.model.name=ch.elexis.core.model)").orElseThrow(() -> new IllegalStateException("no model service found"));
            IStickerService stickerService = OsgiServiceUtil.getService(IStickerService.class).orElseThrow(() -> new IllegalStateException("no stock service found"));
            try {
                boolean hasSticker = stickerService.hasSticker(stock.getOwner().asIPatient(), coreModelService.load("mediorderMailSent", ISticker.class).orElseThrow(() -> new IllegalStateException("no mediorderMailSend sticker found")));
                int n = hasSticker ? 4 : 1;
                return n;
            }
            finally {
                OsgiServiceUtil.ungetService(coreModelService);
                OsgiServiceUtil.ungetService(stickerService);
            }
        }
        if (hasInStock && hasOtherStatus) {
            return 2;
        }
        if (allEnabledForPea) {
            return 0;
        }
        return 3;
    }
}

