/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PersistenceException
extends RuntimeException {
    private final IStatus status;
    private final int errCode;
    public static final int NOT_DEFINED = 0;
    public static final int DB_CONNECTION_NOT_CONFIGURED = 1;

    public PersistenceException(String message) {
        super(message);
        this.errCode = 0;
        this.status = new Status(4, "Persistence", message);
    }

    public PersistenceException(IStatus status) {
        super(status.getMessage());
        this.errCode = 0;
        this.status = status;
    }

    public PersistenceException(int errCode) {
        this.status = null;
        this.errCode = errCode;
    }

    @Override
    public Throwable getCause() {
        return this.status.getException();
    }

    public final IStatus getStatus() {
        return this.status;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream output) {
        PrintStream printStream = output;
        synchronized (printStream) {
            super.printStackTrace(output);
            PersistenceException.printChildren(this.status, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter output) {
        PrintWriter printWriter = output;
        synchronized (printWriter) {
            super.printStackTrace(output);
            PersistenceException.printChildren(this.status, output);
        }
    }

    public static void printChildren(IStatus status, PrintStream output) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            output.println("Contains: " + children[i].getMessage());
            Throwable exception = children[i].getException();
            if (exception != null) {
                exception.printStackTrace(output);
            }
            PersistenceException.printChildren(children[i], output);
            ++i;
        }
    }

    public static void printChildren(IStatus status, PrintWriter output) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            output.println("Contains: " + children[i].getMessage());
            output.flush();
            Throwable exception = children[i].getException();
            if (exception != null) {
                exception.printStackTrace(output);
            }
            PersistenceException.printChildren(children[i], output);
            ++i;
        }
    }
}

