/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ac.internal;

import ch.elexis.core.ac.ACEAccessBitMap;
import ch.elexis.core.ac.ACEAccessBitMapConstraint;
import ch.elexis.core.ac.Right;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;

public class ACEAccessBitMapJsonAdapter
implements JsonSerializer<ACEAccessBitMap>,
JsonDeserializer<ACEAccessBitMap> {
    public JsonElement serialize(ACEAccessBitMap value, Type typeOfSrc, JsonSerializationContext context) {
        boolean[] has = new boolean[3];
        Object[] constraint = new String[3];
        Arrays.fill(constraint, "");
        byte[] accessRightMap = value.getAccessRightMap();
        int i = 0;
        while (i < accessRightMap.length) {
            byte b = accessRightMap[i];
            if ((b & ACEAccessBitMapConstraint.NONE.bitMapping) != 0) {
                constraint[0] = String.valueOf(constraint[0]) + Right.values()[i].token;
                has[0] = true;
            }
            if ((b & ACEAccessBitMapConstraint.AOBO.bitMapping) != 0) {
                constraint[1] = String.valueOf(constraint[1]) + Right.values()[i].token;
                has[1] = true;
            }
            if ((b & ACEAccessBitMapConstraint.SELF.bitMapping) != 0) {
                constraint[2] = String.valueOf(constraint[2]) + Right.values()[i].token;
                has[2] = true;
            }
            ++i;
        }
        int count = 0;
        count += has[0] ? 1 : 0;
        count += has[1] ? 1 : 0;
        int n = has[2] ? 1 : 0;
        JsonArray array = new JsonArray();
        if ((count += n) > 1) {
            this.performWrite((String[])constraint, has, array);
        } else {
            this.performWrite((String[])constraint, has, array);
        }
        return array.size() == 1 ? array.get(0) : array;
    }

    public ACEAccessBitMap deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String[] rights;
        if (jsonElement.isJsonArray()) {
            JsonArray array = jsonElement.getAsJsonArray();
            ArrayList a = new ArrayList(1);
            array.forEach(entry -> {
                boolean bl = a.add(entry.getAsString());
            });
            rights = a.toArray(new String[a.size()]);
        } else {
            rights = new String[]{jsonElement.getAsString()};
        }
        return new ACEAccessBitMap(this.buildAccessRightMap(rights));
    }

    private byte[] buildAccessRightMap(String[] rights) {
        byte[] accessRightMap = new byte[Right.values().length];
        Arrays.asList(rights).forEach(entry -> {
            String denominator;
            int indexOf = entry.indexOf(58);
            ACEAccessBitMapConstraint constraint = null;
            if (indexOf > 1) {
                denominator = entry.substring(0, indexOf);
                String _constraint = entry.substring(indexOf + 1);
                constraint = ACEAccessBitMapConstraint.valueOf(_constraint.toUpperCase());
            } else {
                denominator = entry;
            }
            int n = Right.CREATE.ordinal();
            byArray[n] = (byte)(accessRightMap[n] ^ this.multiplyFindConstraint(Right.CREATE, constraint, denominator));
            int n2 = Right.READ.ordinal();
            byArray[n2] = (byte)(accessRightMap[n2] ^ this.multiplyFindConstraint(Right.READ, constraint, denominator));
            int n3 = Right.UPDATE.ordinal();
            byArray[n3] = (byte)(accessRightMap[n3] ^ this.multiplyFindConstraint(Right.UPDATE, constraint, denominator));
            int n4 = Right.DELETE.ordinal();
            byArray[n4] = (byte)(accessRightMap[n4] ^ this.multiplyFindConstraint(Right.DELETE, constraint, denominator));
            int n5 = Right.EXECUTE.ordinal();
            byArray[n5] = (byte)(accessRightMap[n5] ^ this.multiplyFindConstraint(Right.EXECUTE, constraint, denominator));
            int n6 = Right.VIEW.ordinal();
            byArray[n6] = (byte)(accessRightMap[n6] ^ this.multiplyFindConstraint(Right.VIEW, constraint, denominator));
            int n7 = Right.EXPORT.ordinal();
            byArray[n7] = (byte)(accessRightMap[n7] ^ this.multiplyFindConstraint(Right.EXPORT, constraint, denominator));
            int n8 = Right.IMPORT.ordinal();
            byArray[n8] = (byte)(accessRightMap[n8] ^ this.multiplyFindConstraint(Right.IMPORT, constraint, denominator));
            int n9 = Right.REMOVE.ordinal();
            byArray[n9] = (byte)(accessRightMap[n9] ^ this.multiplyFindConstraint(Right.REMOVE, constraint, denominator));
        });
        return accessRightMap;
    }

    private byte multiplyFindConstraint(Right right, ACEAccessBitMapConstraint constraint, String denominator) {
        int isApplied = denominator.indexOf(right.token);
        if (isApplied < 0) {
            return 0;
        }
        if (ACEAccessBitMapConstraint.SELF == constraint) {
            return ACEAccessBitMapConstraint.SELF.bitMapping;
        }
        if (ACEAccessBitMapConstraint.AOBO == constraint) {
            return ACEAccessBitMapConstraint.AOBO.bitMapping;
        }
        return ACEAccessBitMapConstraint.NONE.bitMapping;
    }

    private void performWrite(String[] constraint, boolean[] has, JsonArray array) {
        if (has[2]) {
            array.add(constraint[2] + ":self");
        }
        if (has[1]) {
            array.add(constraint[1] + ":aobo");
        }
        if (has[0]) {
            array.add(constraint[0]);
        }
    }
}

