/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.textsystem;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.commands.LoadTemplateCommand;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.ITextTemplateRequirement;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.textsystem.Messages;
import ch.elexis.core.ui.views.textsystem.model.TextTemplate;
import ch.elexis.core.ui.views.textsystem.provider.TextTemplateFilter;
import ch.elexis.core.ui.views.textsystem.provider.TextTemplateViewerComparator;
import ch.elexis.data.Brief;
import ch.elexis.data.Mandant;
import ch.elexis.data.Query;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextTemplateView
extends ViewPart {
    public static final String ID = "ch.elexis.views.textsystem.TextTemplateView";
    private ITextPlugin plugin = null;
    private TableColumnLayout tableLayout;
    private Table table;
    private TableViewer tableViewer;
    private Text txtSearch;
    private TextTemplateFilter searchFilter;
    private TextTemplateViewerComparator comparator;
    private List<TextTemplate> templates;
    private List<TextTemplate> requiredTemplates;
    protected StructuredViewer viewer;
    static Logger log = LoggerFactory.getLogger(TextTemplateView.class);

    @Optional
    @Inject
    void reloadLetter(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IDocumentLetter.class.isAssignableFrom(clazz)) {
            this.refresh();
        }
    }

    public TextTemplateView() {
        this.initActiveTextPlugin();
        this.loadRequiredAndExistingTemplates();
    }

    private void loadRequiredAndExistingTemplates() {
        this.requiredTemplates = new ArrayList<TextTemplate>();
        if (this.plugin == null) {
            return;
        }
        List requirements = Extensions.getClasses((String)"ch.elexis.core.ui.TextTemplateRequirement", (String)"element");
        for (ITextTemplateRequirement txtTemplateReq : requirements) {
            String[] names = txtTemplateReq.getNamesOfRequiredTextTemplate();
            String[] descriptions = txtTemplateReq.getDescriptionsOfRequiredTextTemplate();
            int i = 0;
            while (i < names.length) {
                TextTemplate tt = new TextTemplate(names[i], descriptions[i], this.plugin.getMimeType(), true);
                this.requiredTemplates.add(tt);
                ++i;
            }
        }
        this.refresh();
    }

    private TextTemplate createTextTemplateReference(Brief template) {
        for (TextTemplate sysTemplate : this.requiredTemplates) {
            String mandId = template.getAdressat().getId();
            if (!sysTemplate.getName().equals(template.getBetreff()) || !sysTemplate.getMimeType().equals(template.getMimeType()) || mandId != null && !mandId.isEmpty()) continue;
            sysTemplate.addSystemTemplateReference(template);
            return sysTemplate;
        }
        TextTemplate formTemplate = new TextTemplate(template.getBetreff(), "", template.getMimeType());
        formTemplate.addFormTemplateReference(template);
        return formTemplate;
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        if (this.plugin == null) {
            this.createTextPluginMissingForm(composite);
            return;
        }
        Label lblSearch = new Label(composite, 0);
        lblSearch.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSearch.setText("Suchen: ");
        this.txtSearch = new Text(composite, 2176);
        this.txtSearch.setLayoutData((Object)new GridData(768));
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                TextTemplateView.this.searchFilter.setSearchTerm(TextTemplateView.this.txtSearch.getText());
                TextTemplateView.this.tableViewer.refresh();
            }
        });
        Composite tableArea = new Composite(composite, 0);
        tableArea.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.tableLayout = new TableColumnLayout();
        tableArea.setLayout((Layout)this.tableLayout);
        this.tableViewer = new TableViewer(tableArea, 68098);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        this.createColumns(composite);
        this.table = this.tableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput(this.templates);
        this.searchFilter = new TextTemplateFilter();
        this.tableViewer.addFilter((ViewerFilter)this.searchFilter);
        this.comparator = new TextTemplateViewerComparator();
        this.tableViewer.setComparator((ViewerComparator)this.comparator);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IHandlerService handlerService = (IHandlerService)TextTemplateView.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand(LoadTemplateCommand.ID, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        Menu popupMenu = menuManager.createContextMenu((Control)this.tableViewer.getTable());
        this.table.setMenu(popupMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        Transfer[] transfer = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
        this.tableViewer.addDragSupport(1, transfer, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TextTemplateView.this.tableViewer.getSelection();
                for (Object object : selection.toList()) {
                    TextTemplate textTemplate = (TextTemplate)object;
                    if (textTemplate.getTemplate() != null) continue;
                    event.doit = false;
                    log.error("Error template doesn't exist");
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TextTemplateView.this.tableViewer.getSelection();
                if (!FileTransfer.getInstance().isSupportedType(event.dataType)) return;
                String[] files = new String[selection.size()];
                int i = 0;
                while (true) {
                    File file;
                    block17: {
                        if (i >= selection.size()) {
                            event.data = files;
                            return;
                        }
                        TextTemplate textTemplate = (TextTemplate)selection.toList().get(i);
                        file = new File(textTemplate.getName() + "." + textTemplate.getMimeType());
                        byte[] contents = textTemplate.getTemplate().loadBinary();
                        try {
                            Throwable throwable = null;
                            Object var9_11 = null;
                            try {
                                ByteArrayInputStream bais = new ByteArrayInputStream(contents);
                                try {
                                    try (FileOutputStream fos = new FileOutputStream(file);){
                                        FileTool.copyStreams((InputStream)bais, (OutputStream)fos);
                                    }
                                    if (bais == null) break block17;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (bais == null) throw throwable;
                                    bais.close();
                                    throw throwable;
                                }
                                bais.close();
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                    throw throwable;
                                }
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            log.error("Error creating template", (Throwable)e);
                        }
                    }
                    files[i] = file.getAbsolutePath();
                    log.debug("dragSetData; isSupportedType {} data {}", (Object)file.getAbsolutePath(), event.data);
                    ++i;
                }
            }
        });
    }

    private void createTextPluginMissingForm(Composite parent) {
        String expl = Messages.TextTemplateVeiw_NoTxtPluginDescription + Messages.Text_No_Plugin_loaded + Messages.Text_Plugin_Not_Configured + Messages.Text_External_Cmd_deleted;
        Form form = UiDesk.getToolkit().createForm(parent);
        form.setText(Messages.Core_Unable_to_create_text);
        form.setLayoutData((Object)SWTHelper.fillGrid(parent, 1));
        form.getBody().setLayout((Layout)new GridLayout(1, false));
        FormText ft = UiDesk.getToolkit().createFormText(form.getBody(), false);
        ft.setText(expl, true, false);
    }

    private void createColumns(Composite parent) {
        String[] titles = new String[]{"", "Name der Vorlage", "Typ", "Mandant", "Adressabfrage", "Drucker/Schacht", "Beschreibung"};
        int[] bounds = new int[]{30, 200, 170, 80, 90, 300, 600};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof TextTemplate) {
                    TextTemplate template = (TextTemplate)element;
                    if (!template.exists()) {
                        return Images.IMG_AUSRUFEZ.getImage();
                    }
                    if (template.isSystemTemplate()) {
                        return Images.IMG_DOC_SYS.getImage();
                    }
                }
                return null;
            }

            public String getText(Object element) {
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof TextTemplate) {
                    TextTemplate template = (TextTemplate)element;
                    if (!template.exists()) {
                        return "Vorlage nicht vorhanden";
                    }
                    if (template.isSystemTemplate()) {
                        return "Systemvorlage";
                    }
                    if (template.getMandantLabel().equals("Alle")) {
                        return "Formatvorlage";
                    }
                    return "Benutzerspezifische Vorlage";
                }
                return null;
            }
        });
        final ViewerComparator systemTemplateComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof TextTemplate && e2 instanceof TextTemplate) {
                    TextTemplate t1 = (TextTemplate)e1;
                    TextTemplate t2 = (TextTemplate)e2;
                    int result = Boolean.compare(t1.isSystemTemplate(), t2.isSystemTemplate());
                    return this.getSortedAscending(viewer) ? result : -result;
                }
                return 0;
            }

            private boolean getSortedAscending(Viewer viewer) {
                if (viewer.getData("systemTemplateSortAscending") != null) {
                    return (Boolean)viewer.getData("systemTemplateSortAscending");
                }
                return true;
            }
        };
        col.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTemplateView.this.tableViewer.setComparator(systemTemplateComparator);
                if (TextTemplateView.this.tableViewer.getComparator() == systemTemplateComparator) {
                    if (TextTemplateView.this.tableViewer.getData("systemTemplateSortAscending") != null) {
                        TextTemplateView.this.tableViewer.setData("systemTemplateSortAscending", (Object)((Boolean)TextTemplateView.this.tableViewer.getData("systemTemplateSortAscending") == false ? 1 : 0));
                    } else {
                        TextTemplateView.this.tableViewer.setData("systemTemplateSortAscending", (Object)Boolean.FALSE);
                    }
                    TextTemplateView.this.tableViewer.refresh();
                }
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TextTemplate) {
                    TextTemplate template = (TextTemplate)element;
                    return template.getName();
                }
                return super.getText(element);
            }

            public Color getForeground(Object element) {
                return TextTemplateView.this.getForegroundColor(element);
            }
        });
        col = this.createTableViewerColumn(titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TextTemplate) {
                    TextTemplate template = (TextTemplate)element;
                    return template.getMimeTypePrintname();
                }
                return super.getText(element);
            }

            public Color getForeground(Object element) {
                return TextTemplateView.this.getForegroundColor(element);
            }
        });
        col = this.createTableViewerColumn(titles[3], bounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TextTemplate) {
                    TextTemplate template = (TextTemplate)element;
                    return template.getMandantLabel();
                }
                return super.getText(element);
            }

            public Color getForeground(Object element) {
                return TextTemplateView.this.getForegroundColor(element);
            }
        });
        col.setEditingSupport((EditingSupport)new MandantEditingSupport(this.tableViewer));
        col = this.createTableViewerColumn(titles[4], bounds[4], 4);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                TextTemplate template;
                if (element instanceof TextTemplate && (template = (TextTemplate)element).askForAddress()) {
                    return Images.IMG_CHECKBOX.getImage();
                }
                return Images.IMG_CHECKBOX_UNCHECKED.getImage();
            }

            public String getText(Object element) {
                return null;
            }
        });
        col.setEditingSupport((EditingSupport)new AddressRequiredEditingSupport(this.tableViewer));
        col = this.createTableViewerColumn(titles[5], bounds[5], 5);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TextTemplate) {
                    TextTemplate template = (TextTemplate)element;
                    Object label = "";
                    String printer = template.getPrinter();
                    String tray = template.getTray();
                    if (printer != null) {
                        label = (String)label + printer;
                    }
                    if (tray != null) {
                        label = (String)label + "/ " + tray;
                    }
                    return label;
                }
                return super.getText(element);
            }

            public Color getForeground(Object element) {
                return TextTemplateView.this.getForegroundColor(element);
            }
        });
        col = this.createTableViewerColumn(titles[6], bounds[6], 6);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TextTemplate) {
                    TextTemplate template = (TextTemplate)element;
                    return template.getDescription();
                }
                return super.getText(element);
            }

            public Color getForeground(Object element) {
                return TextTemplateView.this.getForegroundColor(element);
            }
        });
    }

    private Color getForegroundColor(Object element) {
        TextTemplate template;
        if (element instanceof TextTemplate && !(template = (TextTemplate)element).exists()) {
            return UiDesk.getColor("grau");
        }
        return null;
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        this.tableLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(bound, 20, true));
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(false);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, colNumber));
        return viewerColumn;
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTemplateView.this.comparator.setColumn(index);
                int dir = TextTemplateView.this.comparator.getDirection();
                TextTemplateView.this.tableViewer.getTable().setSortDirection(dir);
                TextTemplateView.this.tableViewer.getTable().setSortColumn(column);
                TextTemplateView.this.tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void setFocus() {
    }

    private void initActiveTextPlugin() {
        if (this.plugin == null) {
            String ExtensionToUse = CoreHub.localCfg.get("briefe/Textmodul", null);
            IExtensionRegistry exr = Platform.getExtensionRegistry();
            IExtensionPoint exp = exr.getExtensionPoint("ch.elexis.core.ui.Text");
            if (exp != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = exp.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] elems;
                    IExtension ex = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = elems = ex.getConfigurationElements();
                    int n3 = elems.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement el = iConfigurationElementArray[n4];
                        if (ExtensionToUse == null || el.getAttribute("name").equals(ExtensionToUse)) {
                            try {
                                this.plugin = (ITextPlugin)el.createExecutableExtension("Klasse");
                            }
                            catch (Exception e) {
                                ExHandler.handle((Throwable)e);
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    public ITextPlugin getActiveTextPlugin() {
        return this.plugin;
    }

    public List<TextTemplate> getRequiredTextTemplates() {
        return this.requiredTemplates;
    }

    public void update(TextTemplate textTemplate) {
        int index = this.templates.indexOf(textTemplate);
        if (index == -1) {
            this.templates.add(textTemplate);
        } else {
            this.templates.set(index, textTemplate);
        }
        this.tableViewer.refresh();
    }

    private void refresh() {
        Query qbe = new Query(Brief.class);
        qbe.add("Typ", "=", "Vorlagen");
        List list = qbe.execute();
        ArrayList<TextTemplate> txtTemplates = new ArrayList<TextTemplate>();
        for (Brief template : list) {
            txtTemplates.add(this.createTextTemplateReference(template));
        }
        for (TextTemplate reqTemplate : this.requiredTemplates) {
            if (txtTemplates.contains(reqTemplate)) continue;
            txtTemplates.add(reqTemplate);
        }
        this.templates = txtTemplates;
        if (this.tableViewer != null && !this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.setInput(this.templates);
            this.tableViewer.refresh(true);
        }
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    class AddressRequiredEditingSupport
    extends EditingSupport {
        private TableViewer tableViewer;

        public AddressRequiredEditingSupport(TableViewer tableViewer) {
            super((ColumnViewer)tableViewer);
            this.tableViewer = tableViewer;
        }

        protected CellEditor getCellEditor(Object element) {
            return new CheckboxCellEditor((Composite)this.tableViewer.getTable(), 40);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            TextTemplate template = (TextTemplate)element;
            return template.askForAddress();
        }

        protected void setValue(Object element, Object value) {
            TextTemplate template = (TextTemplate)element;
            template.setAskForAddress((Boolean)value);
            this.tableViewer.update(element, null);
        }
    }

    class MandantEditingSupport
    extends EditingSupport {
        private TableViewer tableViewer;
        private List<Mandant> mandants;

        public MandantEditingSupport(TableViewer tableViewer) {
            super((ColumnViewer)tableViewer);
            this.tableViewer = tableViewer;
            this.mandants = new ArrayList<Mandant>();
        }

        protected CellEditor getCellEditor(Object element) {
            Query qbe = new Query(Mandant.class);
            this.mandants = qbe.execute();
            String[] mandantArray = new String[this.mandants.size() + 1];
            mandantArray[0] = "Alle";
            int i = 0;
            while (i < this.mandants.size()) {
                mandantArray[i + 1] = this.mandants.get(i).getLabel();
                ++i;
            }
            return new ComboBoxCellEditor((Composite)this.tableViewer.getTable(), mandantArray, 8);
        }

        protected boolean canEdit(Object element) {
            TextTemplate template = (TextTemplate)element;
            return !template.isSystemTemplate();
        }

        protected Object getValue(Object element) {
            TextTemplate template = (TextTemplate)element;
            Mandant mandant = template.getMandant();
            int index = this.mandants.indexOf(mandant);
            return index + 1;
        }

        protected void setValue(Object element, Object value) {
            TextTemplate template = (TextTemplate)element;
            int index = (Integer)value - 1;
            if (index == -1) {
                template.prepareRewrite();
                template.setMandant("");
                template.rewrite();
            } else {
                template.prepareRewrite();
                Mandant mandant = this.mandants.get(index);
                template.setMandant(mandant.getId());
                template.setSystemTemplate(false);
                template.rewrite();
            }
            this.tableViewer.update(element, null);
        }
    }
}

