/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.reminder.viewers;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.UiDesk;
import org.eclipse.swt.graphics.Color;

public enum ReminderColumnType {
    TYPE(Messages.Core_Type, 20),
    DATE(Messages.Core_Date, 70),
    RESPONSIBLE(Messages.EditReminderDialog_assigTo, 100),
    STATUS(Messages.Core_Status, 100),
    PATIENT(Messages.Core_Patient, 145),
    DESCRIPTION(Messages.Core_Subject, 400);

    private final String title;
    private final int defaultWidth;

    private ReminderColumnType(String title, int defaultWidth) {
        this.title = title;
        this.defaultWidth = defaultWidth;
    }

    public String getTitle() {
        return this.title;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public static String[] getAllTitles() {
        String[] titles = new String[ReminderColumnType.values().length];
        int i = 0;
        while (i < ReminderColumnType.values().length) {
            titles[i] = ReminderColumnType.values()[i].getTitle();
            ++i;
        }
        return titles;
    }

    public static enum ReminderColorType {
        IN_PROGRESS("IN_PROGRESS", "FFFFFF"),
        DUE("DUE", "FFFFFF"),
        OVERDUE("OVERDUE", "FFFFFF"),
        OPEN("OPEN", "FFFFFF"),
        CLOSED("CLOSED", "FFFFFF");

        private final String key;
        private final String defaultRGB;

        private ReminderColorType(String key, String defaultRGB) {
            this.key = key;
            this.defaultRGB = defaultRGB;
        }

        public Color getColor() {
            String prefPath = "reminder/colors/" + this.key;
            String rgb = ConfigServiceHolder.getUser((String)prefPath, (String)this.defaultRGB);
            return UiDesk.getColorFromRGB(rgb);
        }
    }
}

