/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.reminder.service;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IReminderResponsibleLink;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.ISubQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ReminderQueryService {
    public List<IReminder> load(Config cfg) {
        List contactList;
        IUserGroup group;
        IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
        if (cfg.popupOnLogin || cfg.popupOnPatientSelection) {
            query.startGroup();
            if (cfg.popupOnLogin) {
                query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_LOGIN);
            }
            if (cfg.popupOnPatientSelection) {
                query.or((EStructuralFeature)ModelPackage.Literals.IREMINDER__VISIBILITY, IQuery.COMPARATOR.EQUALS, (Object)Visibility.POPUP_ON_PATIENT_SELECTION);
            }
            query.andJoinGroups();
        }
        ContextServiceHolder.get().getActiveUserContact().ifPresent(activeContact -> {
            if (!config.showAll) {
                if (config.showSelfCreated) {
                    query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, activeContact);
                }
                if (config.assignedToMe) {
                    ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                    subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                    subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, activeContact);
                    query.exists(subQuery);
                }
            }
        });
        if (cfg.patient != null) {
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT, IQuery.COMPARATOR.EQUALS, (Object)cfg.patient);
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
        }
        if (cfg.noPatient) {
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
            query.andFeatureCompare((EStructuralFeature)ModelPackage.Literals.IREMINDER__CREATOR, IQuery.COMPARATOR.EQUALS, (EStructuralFeature)ModelPackage.Literals.IREMINDER__CONTACT);
        }
        if (cfg.group != null && (group = cfg.group) != null && !(contactList = group.getUsers().stream().map(u -> u.getAssignedContact()).filter(c -> c != null).collect(Collectors.toList())).isEmpty()) {
            for (IContact c2 : contactList) {
                ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
                subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
                subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, (Object)c2);
                query.exists(subQuery);
            }
            ISubQuery excludeQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
            excludeQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
            for (IContact c3 : contactList) {
                excludeQuery.and("responsible", IQuery.COMPARATOR.NOT_EQUALS, (Object)c3);
            }
            query.notExists(excludeQuery);
        }
        LocalDate today = LocalDate.now();
        if (cfg.showOnlyDue) {
            query.startGroup();
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)today);
            query.or((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.EQUALS, null);
            query.andJoinGroups();
        } else if (cfg.showNotYetDueReminders) {
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.GREATER_OR_EQUAL, (Object)today);
        } else if (cfg.filterDue && cfg.dueInDays > 0) {
            ReminderQueryService.applyDueDateFilter((IQuery<IReminder>)query, true, cfg.dueInDays);
        }
        return query.execute();
    }

    public static void applyDueDateFilter(IQuery<IReminder> query, boolean includeNoDue, int days) {
        if (days <= 0) {
            return;
        }
        LocalDate now = LocalDate.now();
        LocalDate dueDateDays = now.plusDays(days);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
        if (!includeNoDue) {
            query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.NOT_EQUALS, null);
        }
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.COMPARATOR.LESS_OR_EQUAL, (Object)dueDateDays);
    }

    public static class Config {
        public boolean showAll;
        public boolean showSelfCreated;
        public boolean assignedToMe;
        public boolean showOnlyDue;
        public boolean showNotYetDueReminders;
        public boolean popupOnLogin;
        public boolean popupOnPatientSelection;
        public boolean filterDue;
        public IUserGroup group;
        public IPatient patient;
        public boolean noPatient;
        public int dueInDays = -1;

        public Config showAll(boolean v) {
            this.showAll = v;
            return this;
        }

        public Config showSelfCreated(boolean v) {
            this.showSelfCreated = v;
            return this;
        }

        public Config assignedToMe(boolean v) {
            this.assignedToMe = v;
            return this;
        }

        public Config showOnlyDue(boolean v) {
            this.showOnlyDue = v;
            return this;
        }

        public Config showNotYetDueReminders(boolean v) {
            this.showNotYetDueReminders = v;
            return this;
        }

        public Config popupOnLogin(boolean v) {
            this.popupOnLogin = v;
            return this;
        }

        public Config popupOnPatientSelection(boolean v) {
            this.popupOnPatientSelection = v;
            return this;
        }

        public Config filterDue(boolean v) {
            this.filterDue = v;
            return this;
        }

        public Config group(IUserGroup g) {
            this.group = g;
            return this;
        }

        public Config patient(IPatient p) {
            this.patient = p;
            return this;
        }

        public Config noPatient(boolean v) {
            this.noPatient = v;
            return this;
        }

        public Config dueInDays(int days) {
            this.dueInDays = days;
            return this;
        }
    }
}

