/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung.invoice;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.views.rechnung.RnFilterDialog;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceListBottomComposite;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceListHeaderComposite;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceListSqlQuery;
import ch.elexis.data.DBConnection;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class InvoiceListContentProvider
implements IStructuredContentProvider {
    private List<InvoiceEntry> currentContent = new ArrayList<InvoiceEntry>();
    private TableViewer structuredViewer;
    private InvoiceListHeaderComposite invoiceListHeaderComposite;
    private InvoiceListBottomComposite invoiceListBottomComposite;
    private TimeTool invoiceDateFrom;
    private TimeTool invoiceDateTo;
    private TimeTool invoiceStateDateFrom;
    private TimeTool invoiceStateDateTo;
    private TimeTool invoiceOutputDateFrom;
    private TimeTool invoiceOutputDateTo;
    private static final String SQL_CONDITION_INVOICE_FALL_PATIENT = "r.fallid IN (SELECT fa.id FROM faelle fa WHERE fa.PatientID = ?)";
    private static final String SQL_CONDITION_INVOICE_NUMBER = "r.RnNummer = ?";
    private static final String SQL_CONDITION_INVOICE_MANDANT = "r.MandantId = ?";
    private static final String SQL_CONDITION_INVOICE_DATE_SINCE = "r.RnDatum >= ?";
    private static final String SQL_CONDITION_INVOICE_DATE_UNTIL = "r.RnDatum >= ? AND r.RnDatum <= ?";
    private static final String SQL_CONDITION_INVOICE_STATEDATE_SINCE = "r.StatusDatum >= ?";
    private static final String SQL_CONDITION_INVOICE_STATEDATE_UNTIL = "r.StatusDatum >= ? AND r.StatusDatum <= ?";
    private static final String SQL_CONDITION_INVOICE_STATE_IN = "r.RnStatus IN ( ? )";
    private static final String SQL_CONDITION_INVOICE_AMOUNT_UNTIL = "CAST(r.betrag AS SIGNED) >= ? AND CAST(r.betrag AS SIGNED) <= ?";
    private static final String SQL_CONDITION_INVOICE_AMOUNT_GREATER = "CAST(r.betrag AS SIGNED) >= ?";
    private static final String SQL_CONDITION_INVOICE_AMOUNT_LESSER = "CAST(r.betrag AS SIGNED) <= ?";
    private static final String SQL_CONDITION_INVOICE_TYPE_TP = "FallGarantId = FallKostentrID AND (SELECT istOrganisation FROM kontakt WHERE id = FallKostentrID) = '1'";
    private static final String SQL_CONDITION_INVOICE_TYPE_TG = "NOT(FallGarantId = FallKostentrID AND (SELECT istOrganisation FROM kontakt WHERE id = FallKostentrID) = '1') OR FallKostentrID is null";
    private static final String SQL_CONDITION_BILLING_SYSTEM = "FallGesetz = ?";
    public static String orderBy = "";
    private static int queryLimit = 1000;
    public Action rnFilterAction = new Action(Messages.Core_Filter_List, 2){
        {
            this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
            this.setToolTipText(Messages.RnActions_filterLIstTooltip);
        }

        public void run() {
            if (this.isChecked()) {
                RnFilterDialog rfd = new RnFilterDialog(UiDesk.getTopShell(), false);
                if (rfd.open() == 0) {
                    InvoiceListContentProvider.this.invoiceDateFrom = rfd.getInvoiceDateFrom();
                    InvoiceListContentProvider.this.invoiceDateTo = rfd.getInvoiceDateTo();
                    InvoiceListContentProvider.this.invoiceStateDateFrom = rfd.getInvoiceStateDateFrom();
                    InvoiceListContentProvider.this.invoiceStateDateTo = rfd.getInvoiceStateDateTo();
                    InvoiceListContentProvider.this.invoiceOutputDateFrom = rfd.getInvoiceOutputDateFrom();
                    InvoiceListContentProvider.this.invoiceOutputDateTo = rfd.getInvoiceOutputDateTo();
                }
            } else {
                InvoiceListContentProvider.this.invoiceDateFrom = null;
                InvoiceListContentProvider.this.invoiceDateTo = null;
                InvoiceListContentProvider.this.invoiceStateDateFrom = null;
                InvoiceListContentProvider.this.invoiceDateTo = null;
                InvoiceListContentProvider.this.invoiceOutputDateFrom = null;
                InvoiceListContentProvider.this.invoiceOutputDateTo = null;
            }
            InvoiceListContentProvider.this.reload();
        }
    };
    private final Runnable reloadRunnable = new Runnable(){

        @Override
        public void run() {
            HashSet<String> countPatients;
            int owingAmounts;
            int openAmounts;
            boolean limitReached;
            int countPatientsWoLimit;
            int countInvoicesWoLimit;
            block36: {
                InvoiceListContentProvider.this.currentContent.clear();
                DBConnection dbConnection = PersistentObject.getDefaultConnection();
                countInvoicesWoLimit = 0;
                countPatientsWoLimit = 0;
                InvoiceEntry.QueryBuilder queryBuilder = InvoiceListContentProvider.this.performPreparedStatementReplacements(InvoiceListSqlQuery.getSqlCountStats(true), false, false);
                PreparedStatement ps = queryBuilder.createPreparedStatement(dbConnection);
                try {
                    try {
                        Throwable throwable = null;
                        Object var7_10 = null;
                        try (ResultSet res = ps.executeQuery();){
                            while (res.next()) {
                                countInvoicesWoLimit = res.getInt(1);
                                countPatientsWoLimit = res.getInt(2);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        ElexisStatus elexisStatus = new ElexisStatus(4, "ch.elexis.core.data", 0, "Count stats failed", (Exception)e);
                        ElexisStatus.fire((ElexisStatus)elexisStatus);
                        System.out.println(ps);
                        dbConnection.releasePreparedStatement(ps);
                        return;
                    }
                }
                finally {
                    dbConnection.releasePreparedStatement(ps);
                }
                boolean bl = limitReached = queryLimit > 0 && countInvoicesWoLimit >= queryLimit;
                if (limitReached) {
                    InvoiceListContentProvider.this.invoiceListHeaderComposite.setLimitWarning(queryLimit);
                    MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)"Limit", (String)String.format(Messages.InvoiceListHeaderComposite_queryLimit_toolTipText, queryLimit));
                } else {
                    InvoiceListContentProvider.this.invoiceListHeaderComposite.setLimitWarning(null);
                    InvoiceListContentProvider.this.structuredViewer.getTable().setItemCount(countInvoicesWoLimit);
                }
                queryBuilder = InvoiceListContentProvider.this.performPreparedStatementReplacements(InvoiceListSqlQuery.getSqlFetch(), true, true);
                ps = queryBuilder.createPreparedStatement(dbConnection);
                System.out.println(ps);
                openAmounts = 0;
                owingAmounts = 0;
                countPatients = new HashSet<String>();
                try {
                    try {
                        Throwable throwable = null;
                        Object var11_21 = null;
                        try (ResultSet res = ps.executeQuery();){
                            while (res.next()) {
                                String invoiceId = res.getString(1);
                                String invoiceNumber = res.getString(2);
                                String dateFrom = res.getString(3);
                                String dateTo = res.getString(4);
                                int invoiceStatus = res.getInt(5);
                                int totalAmount = res.getInt(6);
                                String patientId = res.getString(7);
                                countPatients.add(patientId);
                                String patientName = res.getString(8) + " " + res.getString(9) + " (" + res.getString(10) + ")";
                                String dob = res.getString(11);
                                if (StringUtils.isNumeric((CharSequence)dob)) {
                                    patientName = patientName + ", " + new TimeTool(dob).toString(4);
                                }
                                String garantId = res.getString(14);
                                int openAmount = res.getInt(18);
                                openAmounts += openAmount;
                                owingAmounts += totalAmount - openAmount;
                                String invoiceStateDate = res.getString(19);
                                InvoiceEntry ie = new InvoiceEntry((StructuredViewer)InvoiceListContentProvider.this.structuredViewer, invoiceId, patientId, garantId, invoiceNumber, invoiceStatus, dateFrom, dateTo, totalAmount, openAmount, patientName, invoiceStateDate);
                                InvoiceListContentProvider.this.currentContent.add(ie);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        ElexisStatus elexisStatus = new ElexisStatus(4, "ch.elexis.core.data", 0, "Fetch results failed", (Exception)e);
                        ElexisStatus.fire((ElexisStatus)elexisStatus);
                        System.out.println(ps);
                        dbConnection.releasePreparedStatement(ps);
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    dbConnection.releasePreparedStatement(ps);
                    throw throwable;
                }
                dbConnection.releasePreparedStatement(ps);
            }
            if (limitReached) {
                InvoiceListContentProvider.this.invoiceListBottomComposite.update(countPatients.size() + " (" + Integer.toString(countPatientsWoLimit) + ")", queryLimit + " (" + Integer.toString(countInvoicesWoLimit) + ")", new Money(openAmounts).getAmountAsString(), new Money(owingAmounts).getAmountAsString());
            } else {
                InvoiceListContentProvider.this.invoiceListBottomComposite.update(Integer.toString(countPatientsWoLimit), Integer.toString(countInvoicesWoLimit), new Money(openAmounts).getAmountAsString(), new Money(owingAmounts).getAmountAsString());
            }
            this.applyPostFilter();
            InvoiceListContentProvider.this.structuredViewer.setInput(InvoiceListContentProvider.this.currentContent);
        }

        private void applyPostFilter() {
            if (InvoiceListContentProvider.this.invoiceOutputDateFrom != null) {
                int dateTo;
                int dateFrom = NumberUtils.toInt((String)InvoiceListContentProvider.this.invoiceOutputDateFrom.toString(9));
                int n = dateTo = InvoiceListContentProvider.this.invoiceOutputDateTo != null ? NumberUtils.toInt((String)InvoiceListContentProvider.this.invoiceOutputDateTo.toString(9)) : 0;
                if (dateFrom > 0) {
                    InvoiceListContentProvider.this.currentContent = InvoiceListContentProvider.this.currentContent.parallelStream().filter(i -> {
                        Rechnung r = Rechnung.getFromNr((String)i.getInvoiceNumber());
                        if (r != null) {
                            List outputs = r.getTrace("Ausgegeben");
                            for (String output : outputs) {
                                int date;
                                String[] datePart;
                                if (output == null || (datePart = output.split(",|\\.", 4)).length <= 2 || (date = NumberUtils.toInt((String)(datePart[2] + datePart[1] + datePart[0]))) < dateFrom || dateTo != 0 && date > dateTo) continue;
                                return true;
                            }
                        }
                        return false;
                    }).collect(Collectors.toList());
                }
            }
        }
    };

    public InvoiceListContentProvider(TableViewer tableViewerInvoiceList, InvoiceListHeaderComposite invoiceListHeaderComposite, InvoiceListBottomComposite invoiceListBottomComposite) {
        this.structuredViewer = tableViewerInvoiceList;
        this.invoiceListHeaderComposite = invoiceListHeaderComposite;
        this.invoiceListBottomComposite = invoiceListBottomComposite;
    }

    public void dispose() {
        this.structuredViewer = null;
        this.currentContent = null;
    }

    public void reload() {
        BusyIndicator.showWhile((Display)UiDesk.getDisplay(), (Runnable)this.reloadRunnable);
    }

    private InvoiceEntry.QueryBuilder performPreparedStatementReplacements(String preparedStatement, boolean includeLimitReplacement, boolean includeOrderReplacement) {
        InvoiceEntry.QueryBuilder queryBuilder = this.determinePreparedStatementConditionals();
        if (includeOrderReplacement) {
            preparedStatement = preparedStatement.replaceAll("REPLACE_WITH_ORDER", orderBy);
        }
        if (includeLimitReplacement) {
            if (queryLimit > 0) {
                queryBuilder.setMainQuery(preparedStatement.replaceAll("REPLACE_WITH_LIMIT", " LIMIT " + Integer.toString(queryLimit)));
            } else {
                queryBuilder.setMainQuery(preparedStatement.replaceAll("REPLACE_WITH_LIMIT", ""));
            }
        } else {
            queryBuilder.setMainQuery(preparedStatement);
        }
        return queryBuilder;
    }

    private InvoiceEntry.QueryBuilder determinePreparedStatementConditionals() {
        String billingSystem;
        String type;
        String totalAmount;
        String patientId;
        String invoiceId;
        IMandator selectedMandator;
        InvoiceEntry.QueryBuilder queryBuilder = InvoiceEntry.QueryBuilder.create();
        if (!AccessControlServiceHolder.get().evaluate(EvACE.of(IInvoice.class, (Right)Right.READ).and(Right.VIEW)) && (selectedMandator = ContextServiceHolder.getActiveMandatorOrNull()) != null) {
            queryBuilder.build(SQL_CONDITION_INVOICE_MANDANT, selectedMandator.getId());
        }
        if (this.invoiceDateFrom != null) {
            if (this.invoiceDateTo != null) {
                queryBuilder.build(SQL_CONDITION_INVOICE_DATE_UNTIL, this.invoiceDateFrom.toString(9), this.invoiceDateTo.toString(9));
            } else {
                queryBuilder.build(SQL_CONDITION_INVOICE_DATE_SINCE, this.invoiceDateFrom.toString(9));
            }
        }
        this.appendInvoiceStateDateConditionalIfNotNull(queryBuilder);
        Integer invoiceStateNo = this.invoiceListHeaderComposite.getSelectedInvoiceStateNo();
        if (invoiceStateNo != null) {
            if (InvoiceState.OWING.numericValue() == invoiceStateNo.intValue() || InvoiceState.TO_PRINT.numericValue() == invoiceStateNo.intValue()) {
                InvoiceState[] invoiceStates = InvoiceState.OWING.numericValue() == invoiceStateNo.intValue() ? InvoiceState.owingStates() : InvoiceState.toPrintStates();
                this.appendInvoiceStateDateConditionalIfNotNull(queryBuilder);
                List conditional = Arrays.asList(invoiceStates).stream().map(is -> Integer.toString(is.numericValue())).collect(Collectors.toList());
                String qmreplace = conditional.stream().map(s -> "?").collect(Collectors.joining(","));
                String replaceFirst = SQL_CONDITION_INVOICE_STATE_IN.replaceFirst("\\?", qmreplace);
                queryBuilder.build(replaceFirst, conditional);
            } else {
                queryBuilder.build(SQL_CONDITION_INVOICE_STATE_IN, Integer.toString(invoiceStateNo));
            }
        }
        if (StringUtils.isNumeric((CharSequence)(invoiceId = this.invoiceListHeaderComposite.getSelectedInvoiceId()))) {
            queryBuilder.build(SQL_CONDITION_INVOICE_NUMBER, invoiceId);
        }
        if ((patientId = this.invoiceListHeaderComposite.getSelectedPatientId()) != null) {
            queryBuilder.build(SQL_CONDITION_INVOICE_FALL_PATIENT, patientId);
        }
        if (StringUtils.isNotBlank((CharSequence)(totalAmount = this.invoiceListHeaderComposite.getSelectedTotalAmount()))) {
            String boundaryAmount = null;
            try {
                if (totalAmount.startsWith(">")) {
                    totalAmount = totalAmount.substring(1, totalAmount.length());
                    totalMoney = new Money(totalAmount);
                    queryBuilder.build(SQL_CONDITION_INVOICE_AMOUNT_GREATER, totalMoney.getCents());
                } else if (totalAmount.startsWith("<")) {
                    totalAmount = totalAmount.substring(1, totalAmount.length());
                    totalMoney = new Money(totalAmount);
                    queryBuilder.build(SQL_CONDITION_INVOICE_AMOUNT_LESSER, totalMoney.getCents());
                } else if (totalAmount.contains("-")) {
                    String[] split = totalAmount.split("-");
                    Money totalMoney = null;
                    if (split.length > 0) {
                        totalAmount = split[0];
                        totalMoney = new Money(totalAmount);
                    }
                    if (totalMoney != null && split.length > 1) {
                        boundaryAmount = split[1];
                        Money boundaryMoney = new Money(boundaryAmount);
                        queryBuilder.build(SQL_CONDITION_INVOICE_AMOUNT_UNTIL, totalMoney.getCents(), boundaryMoney.getCents());
                    }
                } else {
                    totalMoney = new Money(totalAmount);
                    queryBuilder.build(SQL_CONDITION_INVOICE_AMOUNT_UNTIL, totalMoney.getCents(), totalMoney.getCents());
                }
            }
            catch (ParseException totalMoney) {
                // empty catch block
            }
        }
        if ((type = this.invoiceListHeaderComposite.getSelectedInvoiceType()) != null) {
            InvoiceEntry.QueryBuilder qb = "TP".equals(type) ? queryBuilder.build(SQL_CONDITION_INVOICE_TYPE_TP, new Object[]{null}) : queryBuilder.build(SQL_CONDITION_INVOICE_TYPE_TG, new Object[]{null});
            qb.setInnerCondition(false);
        }
        if ((billingSystem = this.invoiceListHeaderComposite.getSelectedBillingSystem()) != null) {
            InvoiceEntry.QueryBuilder qb = queryBuilder.build(SQL_CONDITION_BILLING_SYSTEM, billingSystem);
            qb.setInnerCondition(false);
        }
        return queryBuilder;
    }

    private void appendInvoiceStateDateConditionalIfNotNull(InvoiceEntry.QueryBuilder queryBuilder) {
        if (this.invoiceStateDateFrom != null) {
            if (this.invoiceStateDateTo != null) {
                queryBuilder.build(SQL_CONDITION_INVOICE_STATEDATE_UNTIL, this.invoiceStateDateFrom.toString(9), this.invoiceStateDateTo.toString(9));
            } else {
                queryBuilder.build(SQL_CONDITION_INVOICE_STATEDATE_SINCE, this.invoiceStateDateFrom.toString(9));
            }
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            return this.currentContent.toArray();
        }
        return Collections.emptyList().toArray();
    }

    public void setSortOrderAndDirection(Object data, int sortDirection) {
        String sortDirectionString;
        String string = sortDirectionString = 128 == sortDirection ? "ASC" : "DESC";
        orderBy = "InvoiceNo".equals(data) ? "ORDER BY LENGTH(InvoiceNo) " + sortDirectionString + ",InvoiceNo " + sortDirectionString : ("RnDatumVon".equals(data) || "InvoiceTotal".equals(data) || "openAmount".equals(data) ? "ORDER BY " + String.valueOf(data) + " " + sortDirectionString : ("Bezeichnung1".equals(data) ? "ORDER BY PatName1 " + sortDirectionString + ", PatName2 " + sortDirectionString : ("StatusDatum".equals(data) ? "ORDER BY " + String.valueOf(data) + " " + sortDirectionString : "")));
        this.reload();
    }

    public void setQueryLimit(int queryLimit) {
        InvoiceListContentProvider.queryLimit = queryLimit;
    }

    public static class InvoiceEntry {
        private static ExecutorService executorService = Executors.newFixedThreadPool(8);
        private volatile boolean resolved = false;
        private volatile boolean resolving = false;
        private StructuredViewer viewer;
        private final String invoiceId;
        private final String patientId;
        private final String garantId;
        private String invoiceNumber;
        private InvoiceState invoiceState;
        private int totalAmount;
        private int openAmount;
        private TimeTool dateFrom;
        private TimeTool dateTo;
        private String patientName;
        private String payerType;
        private String billingSystem;
        private String garantLabel;
        private int invoiceStateSinceDays;

        public InvoiceEntry(StructuredViewer viewer, String invoiceId, String patientId, String garantId, String invoiceNumber, int invoiceStatus, String dateFrom, String dateTo, int totalAmount, int openAmount, String patientName, String stateDate) {
            this.viewer = viewer;
            this.invoiceId = invoiceId;
            this.patientId = patientId;
            this.garantId = garantId == null ? patientId : garantId;
            this.setInvoiceNumber(invoiceNumber);
            this.setInvoiceState(InvoiceState.fromState((int)invoiceStatus));
            this.setTotalAmount(totalAmount);
            this.setOpenAmount(openAmount);
            this.patientName = patientName;
            if (StringUtils.isNumeric((CharSequence)dateFrom)) {
                this.dateFrom = new TimeTool(dateFrom);
            }
            if (StringUtils.isNumeric((CharSequence)dateTo)) {
                this.dateTo = new TimeTool(dateTo);
            }
            if (StringUtils.isNumeric((CharSequence)stateDate)) {
                this.invoiceStateSinceDays = new TimeTool(stateDate).daysTo(new TimeTool());
            }
        }

        public synchronized boolean isResolved() {
            if (!this.resolved && !this.resolving) {
                this.resolving = true;
                executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
            }
            return this.resolved;
        }

        public void resolve() {
            executorService.execute(new ResolveLazyFieldsRunnable(null, this));
            while (!this.isResolved()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public synchronized void refresh() {
            this.resolved = false;
        }

        public String getInvoiceNumber() {
            return this.invoiceNumber;
        }

        public void setInvoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
        }

        public void setInvoiceState(InvoiceState invoiceState) {
            this.invoiceState = invoiceState;
        }

        public InvoiceState getInvoiceState() {
            return this.invoiceState;
        }

        public void setOpenAmount(int openAmount) {
            this.openAmount = openAmount;
        }

        public int getOpenAmount() {
            return this.openAmount;
        }

        public int getTotalAmount() {
            return this.totalAmount;
        }

        public void setTotalAmount(int totalAmount) {
            this.totalAmount = totalAmount;
        }

        public String getTreatmentPeriod() {
            if (this.dateFrom != null && this.dateTo != null) {
                return this.dateFrom.toString(15) + " - " + this.dateTo.toString(15);
            }
            return null;
        }

        public String getReceiverLabel() {
            return this.garantLabel;
        }

        public String getPayerType() {
            if (!this.isResolved()) {
                return "...";
            }
            return this.payerType;
        }

        public String getBillingSystem() {
            if (!this.isResolved()) {
                return "...";
            }
            return this.billingSystem;
        }

        public String getPatientName() {
            return this.patientName;
        }

        public String getInvoiceId() {
            return this.invoiceId;
        }

        public int getInvoiceStateSinceDays() {
            return this.invoiceStateSinceDays;
        }

        static class QueryBuilder {
            private boolean isInnerCondition = true;
            private String mainQuery;
            private String condition;
            private Object[] values;
            private List<QueryBuilder> queryBuilders;

            public static QueryBuilder create() {
                return new QueryBuilder();
            }

            private QueryBuilder() {
                this.queryBuilders = new ArrayList<QueryBuilder>();
            }

            private QueryBuilder(String condition, Object ... values) {
                this.condition = condition;
                this.values = values;
            }

            public QueryBuilder build(String query, Object ... values) {
                QueryBuilder queryBuilder = new QueryBuilder(query, values);
                this.queryBuilders.add(queryBuilder);
                return queryBuilder;
            }

            public void setInnerCondition(boolean isInnerCondition) {
                this.isInnerCondition = isInnerCondition;
            }

            public boolean isInnerCondition() {
                return this.isInnerCondition;
            }

            private Object[] getValue() {
                return this.values;
            }

            private String getCondition() {
                return this.condition;
            }

            public void setMainQuery(String mainQuery) {
                this.mainQuery = mainQuery;
            }

            public String getQuery() {
                if (this.queryBuilders != null && this.mainQuery != null) {
                    StringBuilder sbInner = new StringBuilder();
                    StringBuilder sbOuter = new StringBuilder();
                    for (QueryBuilder builder : this.queryBuilders) {
                        StringBuilder used;
                        StringBuilder stringBuilder = used = builder.isInnerCondition() ? sbInner : sbOuter;
                        if (used.length() > 0) {
                            used.append(" AND ");
                        }
                        used.append(builder.getCondition());
                    }
                    String mainQueryRet = sbInner.length() > 0 ? this.mainQuery.replace("REPLACE_WITH_INVOICE_INNER_CONDITION", " AND " + sbInner.toString()) : this.mainQuery.replace("REPLACE_WITH_INVOICE_INNER_CONDITION", "");
                    mainQueryRet = sbOuter.length() > 0 ? mainQueryRet.replace("REPLACE_WITH_OUTER_CONDITION", " WHERE " + sbOuter.toString()) : mainQueryRet.replace("REPLACE_WITH_OUTER_CONDITION", "");
                    return mainQueryRet;
                }
                return "";
            }

            public PreparedStatement createPreparedStatement(DBConnection dbConnection) {
                if (this.queryBuilders != null) {
                    String query = this.getQuery();
                    boolean isPostgres = "postgresql".equalsIgnoreCase(PersistentObject.getDefaultConnection().getDBFlavor());
                    if (isPostgres) {
                        query = query.replaceAll("SIGNED", "NUMERIC");
                    }
                    PreparedStatement ps = dbConnection.getPreparedStatement(query);
                    int i = 1;
                    for (QueryBuilder qb : this.queryBuilders) {
                        Object[] objectArray = qb.getValue();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object s = objectArray[n2];
                            try {
                                if (s instanceof String) {
                                    ps.setString(i++, (String)s);
                                } else if (s instanceof Long) {
                                    ps.setLong(i++, (Long)s);
                                } else if (s instanceof Integer) {
                                    ps.setInt(i++, (Integer)s);
                                } else if (s instanceof Double) {
                                    ps.setDouble(i++, (Double)s);
                                } else if (s instanceof List) {
                                    List _s = (List)s;
                                    for (Object object : _s) {
                                        ps.setString(i++, object.toString());
                                    }
                                }
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            ++n2;
                        }
                    }
                    return ps;
                }
                return null;
            }
        }

        private class ResolveLazyFieldsRunnable
        implements Runnable {
            private StructuredViewer viewer;
            private InvoiceEntry invoiceEntry;
            private Rechnung rechnung;
            private Fall fall;

            public ResolveLazyFieldsRunnable(StructuredViewer viewer, InvoiceEntry invoiceEntry2) {
                this.viewer = viewer;
                this.invoiceEntry = invoiceEntry2;
            }

            @Override
            public void run() {
                Fall f;
                Rechnung r = Rechnung.load((String)InvoiceEntry.this.invoiceId);
                if (r.exists()) {
                    this.rechnung = r;
                }
                if (this.rechnung != null && (f = this.rechnung.getFall()).exists()) {
                    this.fall = f;
                    this.resolvePayerType();
                    this.resolveLaw();
                    this.resolveGarantLabel();
                    this.invoiceEntry.resolved = true;
                    this.invoiceEntry.resolving = false;
                    if (this.viewer != null) {
                        this.updateViewer();
                    }
                }
            }

            private void resolveGarantLabel() {
                if (InvoiceEntry.this.garantLabel == null) {
                    InvoiceEntry.this.garantLabel = "?";
                    Kontakt recipient = this.fall.getInvoiceRecipient();
                    if (recipient != null) {
                        InvoiceEntry.this.garantLabel = recipient.getLabel();
                    }
                }
            }

            private void resolveLaw() {
                if (this.fall != null) {
                    InvoiceEntry.this.billingSystem = this.fall.getAbrechnungsSystem();
                }
            }

            private void resolvePayerType() {
                InvoiceEntry.this.payerType = "TG";
                if (this.fall != null) {
                    InvoiceEntry.this.payerType = this.fall.getTiersType() == Fall.Tiers.GARANT ? "TG" : "TP";
                }
            }

            private void updateViewer() {
                final Control control = this.viewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!control.isDisposed() && control.isVisible()) {
                                ResolveLazyFieldsRunnable.this.viewer.update((Object)ResolveLazyFieldsRunnable.this.invoiceEntry, null);
                            }
                        }
                    });
                }
            }
        }
    }
}

