/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences.inputs;

import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MultilineFieldEditor
extends StringFieldEditor {
    Text textField;
    int numOfLines;
    int flags = 2048;
    boolean isStringList;

    public MultilineFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, 3, 0, false, parent);
    }

    public MultilineFieldEditor(String name, String labelText, int numLines, int flags, boolean asStringList, Composite parent) {
        this.numOfLines = numLines;
        this.flags = 0x800 | flags;
        this.isStringList = asStringList;
        this.init(name, labelText);
        this.createControl(parent);
        GridData gd = (GridData)this.textField.getLayoutData();
        GC gc = new GC((Drawable)this.textField);
        Point pt = gc.textExtent("X");
        gc.dispose();
        gd.minimumHeight = pt.y * numLines;
        gd.heightHint = pt.y * numLines;
        gd.grabExcessHorizontalSpace = true;
        this.textField.setLayoutData((Object)gd);
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = SWTHelper.createText(parent, this.numOfLines, this.flags);
            this.textField.setFont(parent.getFont());
            this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    MultilineFieldEditor.this.valueChanged();
                }
            });
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    MultilineFieldEditor.this.textField = null;
                }
            });
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    protected void doLoad() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            if (this.isStringList) {
                value = value.replaceAll(",", "\n");
            }
            this.textField.setText(value);
        }
    }

    protected void doStore() {
        String value = this.textField.getText();
        if (this.isStringList) {
            value = value.replaceAll("[\\r\\n]+", ",");
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), value);
    }

    public String getStringValue() {
        String ret = super.getStringValue();
        if (this.isStringList) {
            return ret.replaceAll("[\\r\\n]+", ",");
        }
        return ret;
    }

    public void setStringValue(String value) {
        if (this.isStringList) {
            super.setStringValue(value.replaceAll(",", "\\n"));
        } else {
            super.setStringValue(value);
        }
    }
}

