/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences.inputs;

import ch.rgw.tools.TimeTool;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;

public class DateTimeFieldEditor
extends FieldEditor {
    public static int UNLIMITED = -1;
    private long oldValue;
    DateTime dateTimeField;
    Button checkControl;
    private int widthInChars = UNLIMITED;
    private String preferenceNameEnabled;
    private boolean useStringInPref;

    protected DateTimeFieldEditor() {
    }

    public DateTimeFieldEditor(String name, String labelText, Composite parent, boolean useStringInPref) {
        this(name, labelText, UNLIMITED, parent, useStringInPref);
    }

    public DateTimeFieldEditor(String name, String nameEnabled, String labelText, Composite parent, boolean useStringInPref) {
        this(name, nameEnabled, labelText, UNLIMITED, parent, useStringInPref);
    }

    public DateTimeFieldEditor(String name, String labelText, int width, Composite parent, boolean useStringInPref) {
        this(name, null, labelText, width, parent, useStringInPref);
    }

    public DateTimeFieldEditor(String name, String nameEnabled, String labelText, int width, Composite parent, boolean useStringInPref) {
        this.init(name, labelText);
        this.preferenceNameEnabled = nameEnabled;
        this.widthInChars = width;
        this.useStringInPref = useStringInPref;
        this.createControl(parent);
    }

    public void setPreferenceNameEnabled(String name) {
        this.preferenceNameEnabled = name;
    }

    public String getPreferenceNameEnabled() {
        return this.preferenceNameEnabled;
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.dateTimeField.getLayoutData();
        gd.horizontalSpan = numColumns - 2;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 2;
        if (this.widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this.dateTimeField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        composite.setLayoutData((Object)gd);
        boolean displayCheckControl = this.getPreferenceNameEnabled() != null;
        GridLayout gridLayout = new GridLayout(displayCheckControl ? 2 : 1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        if (displayCheckControl) {
            this.checkControl = new Button(composite, 32);
            this.checkControl.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            this.checkControl.setSelection(true);
            this.checkControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DateTimeFieldEditor.this.valueChanged();
                }
            });
        }
        this.dateTimeField = this.getDateTimeControl(composite);
        this.dateTimeField.setLayoutData((Object)new GridData(768));
    }

    protected void doLoad() {
        if (this.dateTimeField != null) {
            long value = this.getLongByPrefName(this.getPreferenceName(), false);
            this.doLoad(value);
            if (this.checkControl != null) {
                this.checkControl.setSelection(this.getPreferenceStore().getBoolean(this.getPreferenceNameEnabled()));
            }
            this.oldValue = value;
            this.valueChanged();
        }
    }

    private Date getDateByPrefName(String prefName) {
        if (this.useStringInPref) {
            String val = this.getPreferenceStore().getString(prefName);
            TimeTool t = new TimeTool(val);
            return t.getGregorianChange();
        }
        return new Date(this.getPreferenceStore().getLong(prefName));
    }

    private long getLongByPrefName(String prefName, boolean isDefault) {
        if (this.useStringInPref) {
            String val = isDefault ? this.getPreferenceStore().getDefaultString(prefName) : this.getPreferenceStore().getString(prefName);
            TimeTool t = new TimeTool(val);
            return t.getTimeAsLong();
        }
        return this.getPreferenceStore().getLong(prefName);
    }

    private void doStore(long value) {
        if (this.useStringInPref) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), new TimeTool(this.getValue()).toString(9));
        } else {
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.getValue());
        }
    }

    protected void doLoadDefault() {
        if (this.dateTimeField != null) {
            long value = this.getLongByPrefName(this.getPreferenceName(), true);
            this.doLoad(value);
            if (this.checkControl != null) {
                this.checkControl.setSelection(this.getPreferenceStore().getDefaultBoolean(this.getPreferenceNameEnabled()));
            }
        }
        this.valueChanged();
    }

    protected void doLoad(long value) {
        this.setValue(value);
    }

    protected void doStore() {
        this.doStore(this.getValue());
        if (this.checkControl != null) {
            this.getPreferenceStore().setValue(this.getPreferenceNameEnabled(), this.checkControl.getSelection());
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Date getDateValue() {
        if (this.dateTimeField != null) {
            return new Date(this.getValue());
        }
        return this.getDateByPrefName(this.getPreferenceName());
    }

    public boolean getSelection() {
        if (this.checkControl != null) {
            return this.checkControl.getSelection();
        }
        return this.getPreferenceStore().getBoolean(this.getPreferenceNameEnabled());
    }

    protected DateTime getDateTimeControl() {
        return this.dateTimeField;
    }

    public DateTime getDateTimeControl(Composite parent) {
        if (this.dateTimeField == null) {
            this.dateTimeField = new DateTime(parent, 65568);
            this.dateTimeField.setFont(parent.getFont());
            this.dateTimeField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DateTimeFieldEditor.this.valueChanged();
                }
            });
            this.dateTimeField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    DateTimeFieldEditor.this.dateTimeField = null;
                }
            });
        } else {
            this.checkParent((Control)this.dateTimeField, parent);
        }
        return this.dateTimeField;
    }

    public void setFocus() {
        if (this.dateTimeField != null) {
            this.dateTimeField.setFocus();
        }
    }

    public void setDateValue(long value) {
        if (this.dateTimeField != null) {
            this.oldValue = this.getValue();
            if (this.oldValue != value) {
                this.setValue(value);
                this.valueChanged();
            }
        }
    }

    public void setSelection(boolean selection) {
        if (this.checkControl != null) {
            this.checkControl.setSelection(selection);
            this.valueChanged();
        }
    }

    private long getValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, this.dateTimeField.getDay());
        calendar.set(2, this.dateTimeField.getMonth());
        calendar.set(1, this.dateTimeField.getYear());
        return calendar.getTimeInMillis();
    }

    private void setValue(long value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(value);
        this.dateTimeField.setDay(calendar.get(5));
        this.dateTimeField.setMonth(calendar.get(2));
        this.dateTimeField.setYear(calendar.get(1));
    }

    protected void valueChanged() {
        long newValue;
        this.setPresentsDefaultValue(false);
        if (this.checkControl != null) {
            this.dateTimeField.setEnabled(this.checkControl.getSelection());
        }
        if ((newValue = this.getValue()) != this.oldValue) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            this.oldValue = newValue;
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        if (this.checkControl != null) {
            this.checkControl.setEnabled(enabled);
        }
        this.getDateTimeControl(parent).setEnabled(enabled);
    }
}

