/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.data.util.MultiplikatorList;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.IBillingSystem;
import ch.elexis.core.model.ac.EvACEs;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.BillingSystemServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.provider.ILocalizedEnumLabelProvider;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.preferences.inputs.MultiplikatorEditor;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Fall;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Leistungscodes
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static Logger log = LoggerFactory.getLogger(Leistungscodes.class);
    private static final String DEFINITIONSDELIMITER = ";";
    private static final String ARGUMENTSSDELIMITER = ":";
    private static final String ITEMDELIMITER = "\t";
    private static final String FOURLINESPLACEHOLDER = "\n\n\n\nd";
    List<IConfigurationElement> list_RnOutputters = Extensions.getExtensions((String)"ch.elexis.core.data.RechnungsManager");
    List<IConfigurationElement> liste_CS_codes = Extensions.getExtensions((String)"ch.elexis.core.ui.Verrechnungscode");
    Table table;
    String[] tableCols = new String[]{Messages.Core_Name, Messages.Leistungscodes_defaultOutput, Messages.Core_Multiplicator};
    int[] tableWidths = new int[]{60, 120, 120, 70};
    Button bCheckZero;
    Button bStrictCheck;
    @Inject
    private IConfigService configService;

    public Leistungscodes() {
        CoreUiUtil.injectServicesWithContext((Object)((Object)this));
    }

    protected Control createContents(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(ret, 0);
        l1.setText(Messages.Leistungscodes_billingSystems);
        l1.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        SWTHelper.createHyperlink(ret, Messages.Core_New_ellipsis, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbrechnungsTypDialog at = new AbrechnungsTypDialog(Leistungscodes.this.getShell(), null);
                if (at.open() == 0) {
                    String[] result = at.getResult();
                    String key = "billing/systems/" + result[0];
                    log.info("Dialog.OK localized values: name {} leistung {} ausgabe {}", new Object[]{result[0], "", result[1]});
                    String rnOutputter = Leistungscodes.this.getDbAusgabeName(result[1]);
                    log.info("Dialog.OK dbNames values: name {} leistung {} ausgabe {}", new Object[]{result[0], "", rnOutputter});
                    Leistungscodes.this.configService.set(key + "/name", result[0]);
                    Leistungscodes.this.configService.set(key + "/standardausgabe", rnOutputter);
                    Leistungscodes.this.configService.set(key + "/standardgrund", result[8]);
                    Leistungscodes.this.configService.set(key + "/bedingungen", result[2]);
                    Leistungscodes.this.configService.set(key + "/fakultativ", result[3]);
                    Leistungscodes.this.configService.set(key + "/unused", result[4]);
                    Leistungscodes.this.configService.set(key + "/disabled", result[5]);
                    BillingSystem.setConfigurationValue((String)result[0], (String)"defaultBillingLaw", (String)result[6]);
                    BillingSystem.setConfigurationValue((String)result[0], (String)"noCostBearer", (String)result[7]);
                    Leistungscodes.this.reload();
                }
            }
        });
        SWTHelper.createHyperlink(ret, Messages.Core_Delete_ellipsis, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TableItem sel = Leistungscodes.this.table.getSelection()[0];
                String bName = sel.getText(0);
                if (SWTHelper.askYesNo(MessageFormat.format(Messages.Leistungscodes_reallyDelete, bName), Messages.Leistungscodes_notUndoable)) {
                    BillingSystem.removeAbrechnungssystem((String)bName);
                    Leistungscodes.this.reload();
                }
            }
        });
        this.table = new Table(ret, 65540);
        int i = 0;
        while (i < this.tableCols.length) {
            TableColumn tc = new TableColumn(this.table, 0);
            tc.setText(this.tableCols[i]);
            tc.setWidth(this.tableWidths[i]);
            ++i;
        }
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int idx = Leistungscodes.this.table.getSelectionIndex();
                if (idx != -1) {
                    TableItem sel = Leistungscodes.this.table.getItem(idx);
                    String ssel = sel.getText(0);
                    for (String s1 : Leistungscodes.this.configService.getSubNodes("billing/systems", true)) {
                        if (!s1.equals(ssel)) continue;
                        String[] pre = new String[10];
                        log.info("ssel {} cs {} rn {}", new Object[]{ssel, "", BillingSystem.getDefaultPrintSystem((String)s1)});
                        pre[0] = s1;
                        pre[1] = BillingSystem.getDefaultPrintSystem((String)s1);
                        pre[2] = BillingSystem.getRequirements((String)s1);
                        pre[3] = BillingSystem.getOptionals((String)s1);
                        pre[4] = BillingSystem.getUnused((String)s1);
                        pre[5] = Boolean.toString(BillingSystem.isDisabled((String)s1));
                        pre[6] = BillingSystem.getConfigurationValue((String)s1, (String)"defaultBillingLaw", (String)BillingLaw.KVG.name());
                        pre[7] = BillingSystem.getConfigurationValue((String)s1, (String)"noCostBearer", (String)Boolean.FALSE.toString());
                        pre[8] = BillingSystemServiceHolder.get().getDefaultInsuranceReason((IBillingSystem)BillingSystemServiceHolder.get().getBillingSystem(s1).get());
                        AbrechnungsTypDialog at = new AbrechnungsTypDialog(Leistungscodes.this.getShell(), pre);
                        if (at.open() != 0) continue;
                        String[] result = at.getResult();
                        log.info("DoubleClick Okay: name '{}'  localized leistung: '{}' ausgabe: '{}'", new Object[]{result[0], "", result[1]});
                        String rnOutputter = Leistungscodes.this.getDbAusgabeName(result[1]);
                        String key = "billing/systems/" + result[0];
                        log.info("Dialog.OK db values: name '{}' leistung '{}' ausgabe '{}' key '{}'", new Object[]{result[0], "", rnOutputter, key});
                        Leistungscodes.this.configService.set(key + "/name", result[0]);
                        Leistungscodes.this.configService.set(key + "/standardausgabe", rnOutputter);
                        Leistungscodes.this.configService.set(key + "/standardgrund", result[8]);
                        Leistungscodes.this.configService.set(key + "/bedingungen", result[2]);
                        Leistungscodes.this.configService.set(key + "/fakultativ", result[3]);
                        Leistungscodes.this.configService.set(key + "/unused", result[4]);
                        Leistungscodes.this.configService.set(key + "/disabled", result[5]);
                        BillingSystem.setConfigurationValue((String)result[0], (String)"defaultBillingLaw", (String)result[6]);
                        BillingSystem.setConfigurationValue((String)result[0], (String)"noCostBearer", (String)result[7]);
                        Leistungscodes.this.reload();
                    }
                }
            }
        });
        this.table.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, true));
        this.bCheckZero = new Button(ret, 32);
        this.bCheckZero.setText(Messages.Leistungscodes_checkZero);
        this.bCheckZero.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Leistungscodes.this.configService.setActiveUserContact("billing/zero_check", Leistungscodes.this.bCheckZero.getSelection());
            }
        });
        this.bCheckZero.setSelection(this.configService.getActiveUserContact("billing/zero_check", false));
        this.bCheckZero.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        this.bStrictCheck = new Button(ret, 32);
        this.bStrictCheck.setText(Messages.Leistungscodes_strictValidityCheck);
        this.bStrictCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Leistungscodes.this.configService.setActiveUserContact("billing/strict", Leistungscodes.this.bStrictCheck.getSelection());
            }
        });
        this.bStrictCheck.setSelection(this.configService.getActiveUserContact("billing/strict", true));
        this.bStrictCheck.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        final Button bOptify = new Button(ret, 32);
        bOptify.setText(Messages.Leistungscodes_checkPositions);
        bOptify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Leistungscodes.this.configService.setActiveUserContact("billing/optify", bOptify.getSelection());
            }
        });
        bOptify.setSelection(this.configService.getActiveUserContact("billing/optify", true));
        bOptify.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        final Button bAllowOverrideStrict = new Button(ret, 32);
        bAllowOverrideStrict.setText("Nur Warnung bei nicht zul\u00e4ssigen Leistungspositionen");
        bAllowOverrideStrict.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Leistungscodes.this.configService.setActiveUserContact("billing/allowoverride/strict", bAllowOverrideStrict.getSelection());
            }
        });
        bAllowOverrideStrict.setSelection(this.configService.getActiveUserContact("billing/allowoverride/strict", false));
        bAllowOverrideStrict.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        final Button bOptifyXray = new Button(ret, 32);
        bOptifyXray.setText(Messages.Leistungscodes_optifyXrayPositions);
        bOptifyXray.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Leistungscodes.this.configService.setActiveUserContact("billing/optify/XRAY", bOptifyXray.getSelection());
            }
        });
        bOptifyXray.setSelection(this.configService.getActiveUserContact("billing/optify/XRAY", true));
        bOptifyXray.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        final Button bObligation = new Button(ret, 32);
        bObligation.setText(Messages.Leistungscodes_separateObligations);
        bObligation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Leistungscodes.this.configService.setActiveUserContact("billing/obligation", bObligation.getSelection());
            }
        });
        bObligation.setSelection(this.configService.getActiveUserContact("billing/obligation", false));
        bObligation.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        final Button bRemoveOpenReminders = new Button(ret, 32);
        bRemoveOpenReminders.setText(Messages.Leistungscodes_removeOpenReminders);
        bRemoveOpenReminders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Leistungscodes.this.configService.set("rechnung/reminder/removeopen", bRemoveOpenReminders.getSelection());
            }
        });
        bRemoveOpenReminders.setSelection(this.configService.get("rechnung/reminder/removeopen", false));
        bRemoveOpenReminders.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        final Button bCoverageCopyForPatient = new Button(ret, 32);
        bCoverageCopyForPatient.setText(Messages.Leistungscodes_setCopyForPatient);
        bCoverageCopyForPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Leistungscodes.this.configService.set("coverage/copytopatient", bCoverageCopyForPatient.getSelection());
            }
        });
        bCoverageCopyForPatient.setSelection(this.configService.get("coverage/copytopatient", false));
        bCoverageCopyForPatient.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        this.reload();
        return ret;
    }

    public void reload() {
        List systeme = this.configService.getSubNodes("billing/systems", true);
        this.table.removeAll();
        if (systeme != null) {
            for (String s : systeme) {
                String cfgkey = "billing/systems/" + s + "/";
                TableItem it = new TableItem(this.table, 0);
                String name = this.configService.get(cfgkey + "name", "default");
                it.setText(0, name);
                String ausgabe = this.configService.get(cfgkey + "standardausgabe", "?");
                it.setText(1, this.getLocalizedAusgabe(ausgabe));
                StringBuilder sql = new StringBuilder();
                TimeTool actdat = new TimeTool();
                MultiplikatorList multis = new MultiplikatorList("VK_PREISE", name);
                String tp = Double.toString(multis.getMultiplikator(actdat));
                if (StringTool.isNothing((Object)tp)) {
                    if (CoreHub.getSystemLogLevel() > 4) {
                        SWTHelper.alert(Messages.Leistungscodes_didNotFindMulitplier, Messages.Leistungscodes_query + sql.toString());
                    }
                    tp = "1.0";
                }
                it.setText(2, tp);
            }
        }
    }

    private String getLocalizedAusgabe(String ausgabe) {
        Object localizedName = "unknown: " + ausgabe;
        for (IConfigurationElement ic : this.list_RnOutputters) {
            String name = ic.getAttribute("name");
            if (!name.contentEquals(ausgabe)) continue;
            localizedName = ic.getAttribute("localizedName");
            return localizedName == null ? name : localizedName;
        }
        return localizedName;
    }

    private String getDbAusgabeName(String ausgabe) {
        String dbName = "unknown: " + ausgabe;
        for (IConfigurationElement ic : this.list_RnOutputters) {
            String name = ic.getAttribute("name");
            String localizedName = ic.getAttribute("localizedName");
            if (!name.contentEquals(ausgabe) && (localizedName == null || !localizedName.contentEquals(ausgabe))) continue;
            return name;
        }
        return dbName;
    }

    private String getLocalizedLeistungscode(String code) {
        Object localizedName = "unknown: " + code;
        for (IConfigurationElement ic : this.liste_CS_codes) {
            String name = ic.getAttribute("name");
            if (!name.contentEquals(code)) continue;
            localizedName = ic.getAttribute("localizedName");
            return localizedName == null ? name : localizedName;
        }
        return localizedName;
    }

    public void init(IWorkbench workbench) {
    }

    private boolean fieldExistsAlready(String fieldName, ListDisplay<String> ... ldNoDuplicates) {
        String tempCaseID = "marlovits-14x@8w1";
        JdbcLink j = PersistentObject.getConnection();
        String minID = "";
        try {
            String mapped;
            minID = j.queryString("select id from faelle limit 1");
            Fall fall = Fall.load((String)minID);
            if (!fall.exists()) {
                j.exec("insert into faelle (id) values(" + JdbcLink.wrap((String)"marlovits-14x@8w1") + ")");
                minID = "marlovits-14x@8w1";
                fall = Fall.load((String)minID);
            }
            if ((mapped = fall.map(fieldName)).equalsIgnoreCase(fieldName)) {
                return true;
            }
            if (!mapped.substring(0, 8).equalsIgnoreCase("**ERROR:")) {
                return true;
            }
            ListDisplay<String>[] listDisplayArray = ldNoDuplicates;
            int n = ldNoDuplicates.length;
            int n2 = 0;
            while (n2 < n) {
                ListDisplay<String> ld = listDisplayArray[n2];
                for (String str : ld.getAll()) {
                    if (!str.split(ARGUMENTSSDELIMITER)[0].equalsIgnoreCase(fieldName)) continue;
                    return true;
                }
                ++n2;
            }
        }
        finally {
            if (minID.equalsIgnoreCase("marlovits-14x@8w1")) {
                j.exec("delete from faelle where id = " + JdbcLink.wrap((String)"marlovits-14x@8w1"));
            }
        }
        return false;
    }

    class AbrechnungsTypDialog
    extends TitleAreaDialog {
        Text tName;
        ComboViewer cbReason;
        Combo cbRechn;
        ComboViewer cbLaw;
        Button cbDisabled;
        Button bNoCostBearer;
        Label lbTaxp;
        String[] result;
        MultiplikatorEditor mke;
        ListDisplay<String> ldConstants;
        ListDisplay<String> ldRequirements;
        ListDisplay<String> ldOptional;
        ListDisplay<String> ldUnused;
        private Button bUseMultiForEigenleistung;

        AbrechnungsTypDialog(Shell shell, String[] abrdef) {
            super(shell);
            this.result = abrdef;
        }

        protected Control createDialogArea(Composite parent) {
            ScrolledComposite scroller = new ScrolledComposite(parent, 512);
            Composite ret = new Composite((Composite)scroller, 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, false, 1, true));
            ret.setLayout((Layout)new GridLayout(1, false));
            Composite upperPartComp = new Composite(ret, 0);
            upperPartComp.setLayoutData((Object)SWTHelper.getFillGridData(1, false, 1, false));
            upperPartComp.setLayout((Layout)new GridLayout(2, false));
            new Label(upperPartComp, 0).setText(Messages.Core_Name);
            this.tName = new Text(upperPartComp, 2048);
            this.tName.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.tName.setTextLimit(40);
            this.tName.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    AbrechnungsTypDialog.this.mke.reload(AbrechnungsTypDialog.this.tName.getText());
                    super.focusLost(e);
                }
            });
            new Label(upperPartComp, 0).setText(Messages.Leistungscodes_defaultReasonLabel);
            this.cbReason = new ComboViewer(upperPartComp, 8);
            this.cbReason.getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.cbReason.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.cbReason.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.cbReason.setInput((Object)new String[]{FallConstants.TYPE_DISEASE, FallConstants.TYPE_ACCIDENT, FallConstants.TYPE_MATERNITY, FallConstants.TYPE_PREVENTION, FallConstants.TYPE_BIRTHDEFECT, FallConstants.TYPE_OTHER});
            new Label(upperPartComp, 0).setText(Messages.Leistungscodes_defaultOutputLabel);
            this.cbRechn = new Combo(upperPartComp, 8);
            this.cbRechn.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            for (IConfigurationElement ic : Leistungscodes.this.list_RnOutputters) {
                String name = ic.getAttribute("name");
                if (name != null && name.equals("Fall-Standard")) continue;
                log.trace("cbRechn name {} -> {}", (Object)name, (Object)Leistungscodes.this.getLocalizedLeistungscode(name));
                this.cbRechn.add(Leistungscodes.this.getLocalizedAusgabe(name));
            }
            new Label(upperPartComp, 0).setText(Messages.Core_Law_Name);
            this.cbLaw = new ComboViewer(upperPartComp, 8);
            this.cbLaw.getCombo().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.cbLaw.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.cbLaw.setLabelProvider(ILocalizedEnumLabelProvider.getInstance());
            this.cbLaw.setInput((Object)BillingLaw.values());
            new Label(upperPartComp, 0);
            this.cbDisabled = new Button(upperPartComp, 32);
            this.cbDisabled.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            this.cbDisabled.setText(Messages.Leistungscodes_systemDisabled);
            new Label(upperPartComp, 0);
            this.bNoCostBearer = new Button(upperPartComp, 32);
            this.bNoCostBearer.setText(Messages.Leistungscodes_maskCostBearer);
            this.bNoCostBearer.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            new Label(ret, 258).setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            String name = "default";
            if (this.result != null) {
                log.info("set values: name {} leistung {} ausgabe {}", new Object[]{this.result[0], "", this.result[1]});
                this.tName.setText(this.result[0]);
                this.cbRechn.setText(Leistungscodes.this.getLocalizedAusgabe(this.result[1]));
                boolean checked = true;
                if (this.result[5] == null || this.result[5].isEmpty() || this.result[5].equalsIgnoreCase("0") || this.result[5].equalsIgnoreCase("false")) {
                    checked = false;
                }
                this.cbDisabled.setSelection(checked);
                this.cbLaw.setSelection((ISelection)new StructuredSelection((Object)BillingSystemServiceHolder.get().getBillingLaw(this.result[6])));
                this.bNoCostBearer.setSelection(Boolean.valueOf(this.result[7]).booleanValue());
                this.cbReason.setSelection((ISelection)new StructuredSelection((Object)this.result[8]));
                name = this.result[0];
            }
            GridLayout grid1 = new GridLayout(1, false);
            grid1.marginWidth = 0;
            grid1.marginTop = 0;
            grid1.marginBottom = 0;
            grid1.marginRight = 5;
            Composite middlePartComp = new Composite(ret, 0);
            middlePartComp.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            middlePartComp.setLayout((Layout)new GridLayout(2, true));
            Composite leftMiddlePart = new Composite(middlePartComp, 0);
            leftMiddlePart.setLayout((Layout)grid1);
            leftMiddlePart.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            Composite rightMiddlePart = new Composite(middlePartComp, 0);
            rightMiddlePart.setLayout((Layout)grid1);
            rightMiddlePart.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.lbTaxp = new Label(leftMiddlePart, 0);
            this.lbTaxp.setText(Messages.Core_Multiplicator);
            this.mke = new MultiplikatorEditor(leftMiddlePart, name);
            this.mke.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
            this.bUseMultiForEigenleistung = new Button(leftMiddlePart, 32);
            this.bUseMultiForEigenleistung.setText(Messages.Leistungscodes_useMultiplierForCustomServices);
            this.bUseMultiForEigenleistung.setSelection(MultiplikatorList.isEigenleistungUseMulti((String)this.tName.getText()));
            new Label(rightMiddlePart, 0).setText(Messages.Leistungscodes_caseConstants);
            this.ldConstants = new ListDisplay(rightMiddlePart, 0, new ListDisplay.LDListener(){

                @Override
                public String getLabel(Object o) {
                    return (String)o;
                }

                @Override
                public void hyperlinkActivated(String l) {
                    String msg2 = Messages.Leistungscodes_pleaseEnterNameAndValue;
                    InputDialog inp = new InputDialog(AbrechnungsTypDialog.this.getShell(), l + Messages.Leistungscodes_add, msg2, "", null);
                    if (inp.open() == 0) {
                        String[] req = inp.getValue().split("=");
                        if (req.length != 2) {
                            SWTHelper.showError(Messages.Leistungscodes_badEntry, Messages.Leistungscodes_explainEntry);
                        } else {
                            AbrechnungsTypDialog.this.ldConstants.add(inp.getValue());
                            String bs = AbrechnungsTypDialog.this.result[0];
                            if (bs == null) {
                                bs = AbrechnungsTypDialog.this.tName.getText();
                            }
                            if (StringTool.isNothing((Object)bs)) {
                                SWTHelper.showError(Messages.Leistungscodes_badEntryCaptiob, Messages.Leistungscodes_badEntryText);
                            } else {
                                BillingSystem.addBillingSystemConstant((String)bs, (String)inp.getValue());
                            }
                        }
                    }
                }
            });
            this.ldConstants.addHyperlinks(Messages.Leistungscodes_constantHL);
            if (this.result != null) {
                String[] stringArray = BillingSystem.getBillingSystemConstants((String)this.result[0]);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String con = stringArray[n2];
                    this.ldConstants.add(con);
                    ++n2;
                }
            }
            this.ldConstants.setToolTipText(Messages.Leistungscodes_fields_tooltip);
            this.ldConstants.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
            Action actionDel = new Action(){

                public String getText() {
                    return Messages.Core_Delete;
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public void run() {
                    String sel = AbrechnungsTypDialog.this.ldConstants.getSelection();
                    AbrechnungsTypDialog.this.ldConstants.remove(sel);
                    BillingSystem.removeBillingSystemConstant((String)AbrechnungsTypDialog.this.result[0], (String)sel);
                }
            };
            this.ldConstants.setMenu(new IAction[]{actionDel});
            this.ldConstants.addListenerToSelectionList(1, event -> {
                if (event.keyCode == 107) {
                    this.removeRequiredStringGesetzFromFallExtInfo();
                }
            });
            Label separator = new Label(middlePartComp, 258);
            separator.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            Composite lowerPartComp = new Composite(ret, 0);
            lowerPartComp.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
            lowerPartComp.setLayout((Layout)new GridLayout(2, false));
            String[] data = null;
            if (this.result != null && this.result.length > 3 && this.result[2] != null) {
                data = this.result[2].split(Leistungscodes.DEFINITIONSDELIMITER);
            }
            FieldDefsDisplay fdReq = new FieldDefsDisplay(lowerPartComp, 2048, data);
            fdReq.setLabel(Messages.Leistungscodes_necessaryData);
            fdReq.setData(this.tName.getText());
            this.ldRequirements = fdReq.getListDisplay();
            this.ldRequirements.setToolTipText(Messages.Leistungscodes_fields_tooltip);
            data = null;
            if (this.result != null && this.result.length > 4 && this.result[3] != null) {
                data = this.result[3].split(Leistungscodes.DEFINITIONSDELIMITER);
            }
            FieldDefsDisplay fdOpt = new FieldDefsDisplay(lowerPartComp, 2048, data);
            fdOpt.setLabel(Messages.Core_optional_data);
            this.ldOptional = fdOpt.getListDisplay();
            fdOpt.setToolTipText(Messages.Leistungscodes_fields_tooltip);
            if (AccessControlServiceHolder.get().evaluate(EvACEs.CASE_DEFINE_SPECIALS)) {
                data = null;
                if (this.result != null && this.result.length > 5 && this.result[4] != null) {
                    data = this.result[4].split(Leistungscodes.DEFINITIONSDELIMITER);
                }
                FieldDefsDisplay fdUnused = new FieldDefsDisplay(lowerPartComp, 2048, data);
                fdUnused.setLabel(Messages.Leistungscodes_unusedData);
                this.ldUnused = fdUnused.getListDisplay();
                fdUnused.addMoveToAction(this.ldRequirements, Messages.Leistungscodes_moveItemToRequiredData, Images.IMG_MOVETOUPPERLIST.getImageDescriptor(), true);
                fdUnused.addMoveToAction(this.ldOptional, Messages.Leistungscodes_moveItemToOptionalData, Images.IMG_MOVETOLOWERLIST.getImageDescriptor(), true);
                fdUnused.setNoDuplicatesList(this.ldRequirements, this.ldOptional);
                fdUnused.setNoDuplicatesCreateList(this.ldRequirements, this.ldOptional);
                fdUnused.setToolTipText(Messages.Leistungscodes_fields_tooltip);
            }
            fdReq.addMoveToAction(this.ldRequirements, Messages.Leistungscodes_moveItemToRequiredData, Images.IMG_MOVETOUPPERLIST.getImageDescriptor(), false);
            fdReq.addMoveToAction(this.ldOptional, Messages.Leistungscodes_moveItemToOptionalData, Images.IMG_MOVETOLOWERLIST.getImageDescriptor(), true);
            fdReq.setDeletedList(this.ldUnused);
            fdReq.setNoDuplicatesList(this.ldOptional);
            fdReq.setNoDuplicatesCreateList(this.ldRequirements, this.ldOptional);
            fdOpt.addMoveToAction(this.ldRequirements, Messages.Leistungscodes_moveItemToRequiredData, Images.IMG_MOVETOUPPERLIST.getImageDescriptor(), true);
            fdOpt.addMoveToAction(this.ldOptional, Messages.Leistungscodes_moveItemToOptionalData, Images.IMG_MOVETOLOWERLIST.getImageDescriptor(), false);
            fdOpt.setDeletedList(this.ldUnused);
            fdOpt.setNoDuplicatesList(this.ldRequirements);
            fdOpt.setNoDuplicatesCreateList(this.ldRequirements, this.ldOptional);
            Point retSize = ret.computeSize(-1, -1, true);
            ret.setSize(retSize.x, retSize.y);
            scroller.setContent((Control)ret);
            scroller.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            ScrollBar sbY = scroller.getVerticalBar();
            if (sbY != null) {
                sbY.setPageIncrement(ret.getSize().y);
                sbY.setIncrement(20);
            }
            return scroller;
        }

        private void removeRequiredStringGesetzFromFallExtInfo() {
            String selection = this.ldConstants.getSelection();
            if (selection != null && StringUtils.containsIgnoreCase((CharSequence)selection, (CharSequence)"Gesetz")) {
                String[] split = selection.split("=");
                String message = MessageFormat.format("Remove the selected field [{0}] from all Faelle?\nPlease validate that a law is set!", split[0]);
                boolean performDelete = MessageDialog.openQuestion((Shell)UiDesk.getTopShell(), (String)"Remove from Faelle", (String)message);
                if (performDelete) {
                    BusyIndicator.showWhile((Display)UiDesk.getDisplay(), () -> {
                        BillingSystem.removeExtInfoValueForAllFaelleOfBillingSystem((String)this.tName.getText(), Collections.singletonList(split[0]));
                        this.ldConstants.remove(selection);
                        BillingSystem.removeBillingSystemConstant((String)this.result[0], (String)selection);
                    });
                }
            }
        }

        public void create() {
            super.create();
            this.setTitle(Messages.Leistungscodes_defineBillingSystem);
            this.setMessage(Messages.Leistungscodes_pleaseEnterDataForBillingSystem);
            this.getShell().setText(Messages.Invoice_System);
        }

        protected void okPressed() {
            this.result = new String[10];
            this.result[0] = this.tName.getText();
            this.result[1] = this.cbRechn.getText();
            log.info("localized values: name {} leistung {} ausgabe {}", new Object[]{this.tName.getText(), "", this.cbRechn.getText()});
            this.result[2] = StringTool.join(this.ldRequirements.getAll(), (String)Leistungscodes.DEFINITIONSDELIMITER);
            this.result[3] = StringTool.join(this.ldOptional.getAll(), (String)Leistungscodes.DEFINITIONSDELIMITER);
            if (this.ldUnused != null) {
                this.result[4] = StringTool.join(this.ldUnused.getAll(), (String)Leistungscodes.DEFINITIONSDELIMITER);
            }
            String string = this.result[5] = this.cbDisabled.getSelection() ? "1" : "0";
            if (this.bUseMultiForEigenleistung.getSelection()) {
                if (!MultiplikatorList.isEigenleistungUseMulti((String)this.tName.getText())) {
                    MultiplikatorList.setEigenleistungUseMulti((String)this.tName.getText());
                }
            } else if (MultiplikatorList.isEigenleistungUseMulti((String)this.tName.getText())) {
                MultiplikatorList.removeEigenleistungUseMulti((String)this.tName.getText());
            }
            this.result[6] = ((BillingLaw)this.cbLaw.getStructuredSelection().getFirstElement()).name();
            this.result[7] = Boolean.toString(this.bNoCostBearer.getSelection());
            this.result[8] = (String)this.cbReason.getStructuredSelection().getFirstElement();
            super.okPressed();
        }

        public String[] getResult() {
            return this.result;
        }
    }

    class AbrechnungsTypDialog_InputDialog
    extends Dialog {
        String cDialogTitle;
        String cDialogMessage;
        ListDisplay<String>[] cNoDuplicatesList;
        Text tName;
        String cInitialValue;
        Text tTextEditor;
        boolean cHasTextEditor;
        String cTextEditorValue;
        boolean cTextNeeded;
        Button chNumeric;
        boolean cHasNumericCheckbox;
        boolean cIsNumericChecked;
        Button chMultiline;
        boolean cHasStyledCheckbox;
        boolean cIsStyledChecked;
        Button chStyled;
        boolean cHasMultilineCheckbox;
        boolean cIsMultilineChecked;
        String[] result;
        Combo changeCombo;
        String[] cChangeTypeItems;
        String cCurrentFieldType;
        String cBilllingSystemDisabled;

        public AbrechnungsTypDialog_InputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, ListDisplay<String>[] noDuplicatesList, String text, boolean isNumericChecked, boolean isStyledChecked, boolean isMultilineChecked, String[] changeTypeItems) {
            super(parentShell);
            this.tName = null;
            this.tTextEditor = null;
            this.chNumeric = null;
            this.chMultiline = null;
            this.chStyled = null;
            this.result = null;
            this.cCurrentFieldType = dialogTitle.replaceAll("\\.\\.\\..*", "") + "...";
            this.cDialogTitle = dialogTitle.replaceAll("\\.\\.\\.", "");
            this.cDialogMessage = dialogMessage;
            this.cInitialValue = initialValue;
            this.cNoDuplicatesList = noDuplicatesList;
            this.cTextEditorValue = text;
            this.cIsNumericChecked = isNumericChecked;
            this.cIsStyledChecked = isStyledChecked;
            this.cIsMultilineChecked = isMultilineChecked;
            if (changeTypeItems != null) {
                int i = 0;
                while (i < changeTypeItems.length) {
                    changeTypeItems[i] = changeTypeItems[i].replaceAll("\\.\\.\\.", "");
                    ++i;
                }
            }
            this.cChangeTypeItems = changeTypeItems;
            this.calcFieldPresence();
        }

        protected void calcFieldPresence() {
            this.cHasTextEditor = false;
            this.cTextNeeded = true;
            this.cHasNumericCheckbox = false;
            this.cHasStyledCheckbox = false;
            this.cHasMultilineCheckbox = false;
            if (!this.cCurrentFieldType.equalsIgnoreCase(Messages.Leistungscodes_contactHL)) {
                if (this.cCurrentFieldType.equalsIgnoreCase(Messages.Leistungscodes_textHL)) {
                    this.cHasStyledCheckbox = true;
                    this.cHasMultilineCheckbox = true;
                } else if (!this.cCurrentFieldType.equalsIgnoreCase(Messages.GlobalActions_Redate)) {
                    if (this.cCurrentFieldType.equalsIgnoreCase(Messages.Leistungscodes_comboHL)) {
                        this.cHasTextEditor = true;
                        this.cHasNumericCheckbox = true;
                    } else if (this.cCurrentFieldType.equalsIgnoreCase(Messages.Core_List_ellipsis)) {
                        this.cHasTextEditor = true;
                        this.cHasNumericCheckbox = true;
                    } else if (this.cCurrentFieldType.equalsIgnoreCase(Messages.Leistungscodes_checkboxHL)) {
                        this.cHasTextEditor = true;
                        this.cTextNeeded = false;
                    } else if (this.cCurrentFieldType.equalsIgnoreCase(Messages.Leistungscodes_radioHL)) {
                        this.cHasTextEditor = true;
                        this.cHasNumericCheckbox = true;
                    }
                }
            }
        }

        protected Control createDialogArea(final Composite parent) {
            Control[] controls;
            Control[] controlArray = controls = parent.getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            Composite ret = new Composite(parent, 0);
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, false, 1, true));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 5;
            gridLayout.marginTop = 7;
            gridLayout.marginBottom = 5;
            gridLayout.marginLeft = 5;
            gridLayout.marginRight = 5;
            ret.setLayout((Layout)gridLayout);
            Label label = new Label(ret, 0);
            label.setText(this.cDialogMessage);
            label.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            this.tName = new Text(ret, 2048);
            this.tName.setText(this.cInitialValue);
            this.tName.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            Label spacer = new Label(ret, 0);
            spacer.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            if (this.cHasTextEditor) {
                Label teLabel = new Label(ret, 0);
                teLabel.setText(Messages.Leistungscodes_EnterItems);
                teLabel.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
                this.tTextEditor = new Text(ret, 2562);
                this.tTextEditor.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, true));
                this.tTextEditor.setText(Leistungscodes.FOURLINESPLACEHOLDER);
                this.tTextEditor.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            }
            if (this.cHasNumericCheckbox) {
                this.chNumeric = new Button(ret, 32);
                this.chNumeric.setText(Messages.Leistungscodes_SaveAsNumeric);
                this.chNumeric.setSelection(this.cIsNumericChecked);
                this.chNumeric.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            }
            if (this.cHasMultilineCheckbox) {
                this.chMultiline = new Button(ret, 32);
                this.chMultiline.setText(Messages.Leistungscodes_SaveAsMultiplelinesText);
                this.chMultiline.setSelection(this.cIsMultilineChecked);
                this.chMultiline.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            }
            if (this.cHasStyledCheckbox & CoreHub.getLoggedInContact().getLabel().equalsIgnoreCase("a")) {
                this.chStyled = new Button(ret, 32);
                this.chStyled.setText(Messages.Leistungscodes_SaveAsStyledText);
                this.chStyled.setSelection(this.cIsStyledChecked);
                this.chStyled.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            }
            if (this.cChangeTypeItems != null) {
                new Label(ret, 258).setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
                Label currentTypeLabel = new Label(ret, 0);
                currentTypeLabel.setText("Aktueller Feldtyp: ");
                Label currentType = new Label(ret, 0);
                currentType.setText(this.cCurrentFieldType.replaceAll("\\.\\.\\.", ""));
                Label changeLabel = new Label(ret, 0);
                changeLabel.setText(Messages.Leistungscodes_changeFieldTypeTo);
                this.changeCombo = new Combo(ret, 0);
                this.changeCombo.setItems(this.cChangeTypeItems);
                this.changeCombo.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        Combo selCombo = (Combo)e.widget;
                        String selectedFieldType = selCombo.getText();
                        AbrechnungsTypDialog_InputDialog.this.cCurrentFieldType = selectedFieldType + "...";
                        AbrechnungsTypDialog_InputDialog.this.cDialogTitle = AbrechnungsTypDialog_InputDialog.this.cCurrentFieldType.replaceAll("\\.\\.\\.", "");
                        AbrechnungsTypDialog_InputDialog.this.calcFieldPresence();
                        AbrechnungsTypDialog_InputDialog.this.createDialogArea(parent);
                        AbrechnungsTypDialog_InputDialog.this.createButtonBar(parent);
                        parent.layout(true);
                        AbrechnungsTypDialog_InputDialog.this.initializeBounds();
                        if (AbrechnungsTypDialog_InputDialog.this.tTextEditor != null) {
                            AbrechnungsTypDialog_InputDialog.this.tTextEditor.setText(AbrechnungsTypDialog_InputDialog.this.cTextEditorValue);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(this.cDialogTitle);
            if (this.tTextEditor != null) {
                this.tTextEditor.setText(this.cTextEditorValue);
            }
        }

        protected void okPressed() {
            this.result = new String[9];
            this.result[0] = this.tName.getText();
            String string = this.result[1] = this.tTextEditor == null || this.tTextEditor.isDisposed() ? "" : this.tTextEditor.getText();
            String string2 = this.chNumeric == null || this.chNumeric.isDisposed() ? "0" : (this.result[2] = this.chNumeric.getSelection() ? "1" : "0");
            String string3 = this.chMultiline == null || this.chMultiline.isDisposed() ? "0" : (this.result[3] = this.chMultiline.getSelection() ? "1" : "0");
            this.result[4] = this.chStyled == null || this.chStyled.isDisposed() ? "0" : (this.chStyled.getSelection() ? "1" : "0");
            this.result[5] = this.cCurrentFieldType;
            this.result[6] = this.cBilllingSystemDisabled;
            Object errorString = "";
            if (this.result[0].isEmpty()) {
                errorString = (String)errorString + Messages.Leistungscodes_ErrorNameMissing;
            }
            if (this.result[0].indexOf(Leistungscodes.ARGUMENTSSDELIMITER) >= 0 || this.result[0].indexOf(Leistungscodes.DEFINITIONSDELIMITER) >= 0 || this.result[0].indexOf(Leistungscodes.ITEMDELIMITER) >= 0) {
                errorString = (String)errorString + Messages.Leistungscodes_ErrorNameNoSpecialChars;
            }
            if (!this.cInitialValue.equalsIgnoreCase(this.result[0]) && Leistungscodes.this.fieldExistsAlready(this.result[0], this.cNoDuplicatesList)) {
                errorString = (String)errorString + Messages.Leistungscodes_ErrorFieldAlreadyExists;
            }
            if (!(!this.cHasTextEditor || !this.cTextNeeded || this.result[1].length() > 4 && this.result[1].substring(0, 4).equalsIgnoreCase("SQL:") || this.result[1].length() > 7 && this.result[1].substring(0, 7).equalsIgnoreCase("SCRIPT:"))) {
                String tmp = this.result[1].replaceAll("\r\n", Leistungscodes.DEFINITIONSDELIMITER);
                tmp = tmp.replaceAll("\n", Leistungscodes.DEFINITIONSDELIMITER);
                if ((tmp = tmp.replaceAll("\r", Leistungscodes.DEFINITIONSDELIMITER)).isEmpty() || tmp.split(Leistungscodes.DEFINITIONSDELIMITER).length < 2) {
                    errorString = (String)errorString + Messages.Leistungscodes_ErrorAtLeast2Items;
                }
                if (!tmp.isEmpty() && (tmp.substring(0, 1).equalsIgnoreCase(Leistungscodes.DEFINITIONSDELIMITER) || tmp.indexOf(";;") >= 0)) {
                    errorString = (String)errorString + Messages.Leistungscodes_ErrorNoEmptyItemsAllowed;
                }
                if (this.result[1].indexOf(Leistungscodes.ARGUMENTSSDELIMITER) >= 0 || this.result[1].indexOf(Leistungscodes.DEFINITIONSDELIMITER) >= 0 || this.result[1].indexOf(Leistungscodes.ITEMDELIMITER) >= 0) {
                    errorString = (String)errorString + Messages.Leistungscodes_ErrorItemsNoSpecialChars;
                }
            }
            if (((String)errorString).isEmpty()) {
                super.okPressed();
            } else {
                SWTHelper.alert(Messages.Leistungscodes_ErrorMessageTitlebar, (String)errorString);
            }
        }

        public String[] getResult() {
            return this.result;
        }
    }

    class FieldDefsDisplay
    extends Composite {
        static final int MOVEITEMUP = 0;
        static final int MOVEITEMDOWN = 1;
        static final int DELETEITEM = 3;
        static final int EDITITEM = 4;
        static final int LASTFIXEDITEM = 5;
        Label label;
        ListDisplay<String> listDisplay;
        org.eclipse.swt.widgets.List list;
        ToolBar toolBar;
        ListDisplay<String> deletedList;
        ListDisplay<String>[] noDuplicatesList;
        ListDisplay<String>[] noDuplicatesListCreate;
        Short additionalItemsCount;
        List<ListDisplay<String>> moveTo_DestinationLists;
        IAction[] actions;

        public void setNoDuplicatesList(ListDisplay<String> ... listArray) {
            this.noDuplicatesList = listArray;
        }

        public void setNoDuplicatesCreateList(ListDisplay<String> ... listArray) {
            this.noDuplicatesListCreate = listArray;
        }

        public void setLabel(String labelText) {
            this.label.setText(labelText);
        }

        public ListDisplay<String> getListDisplay() {
            return this.listDisplay;
        }

        public void setDeletedList(ListDisplay<String> unusedList) {
            this.deletedList = unusedList;
        }

        public void addMoveToAction(ListDisplay<String> destinationList, String toolTipText, ImageDescriptor imageDescriptor, boolean enabled) {
            if (this.toolBar != null) {
                Short newItemIx = (short)(5 + this.additionalItemsCount + 1);
                this.moveTo_DestinationLists.add(destinationList);
                this.addToolItem(this.toolBar, imageDescriptor.createImage(), toolTipText, newItemIx.shortValue(), enabled);
                ListPopUpMenuAction newAction = new ListPopUpMenuAction(toolTipText, imageDescriptor, toolTipText, newItemIx.shortValue(), destinationList, enabled);
                IAction[] extended = new IAction[5 + this.additionalItemsCount + 1 + 1];
                System.arraycopy(this.actions, 0, extended, 0, 5 + this.additionalItemsCount + 1);
                extended[5 + this.additionalItemsCount.shortValue() + 1] = newAction;
                this.actions = extended;
                this.listDisplay.setMenu(this.actions);
                this.additionalItemsCount = (short)(this.additionalItemsCount + 1);
            }
        }

        private FieldDefsDisplay(Composite parent, int style, String[] listItems) {
            super(parent, 0);
            this.deletedList = null;
            this.noDuplicatesList = null;
            this.noDuplicatesListCreate = null;
            this.additionalItemsCount = 0;
            this.moveTo_DestinationLists = new ArrayList<ListDisplay<String>>(30);
            this.actions = new IAction[6];
            this.setLayoutData(SWTHelper.getFillGridData(2, true, 1, true));
            GridLayout navGridMain = new GridLayout(2, false);
            navGridMain.marginWidth = 0;
            navGridMain.marginHeight = 0;
            this.setLayout((Layout)navGridMain);
            this.label = new Label((Composite)this, 0);
            this.label.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
            this.listDisplay = new ListDisplay(this, 0, new ListDisplay.LDListener(){

                @Override
                public void hyperlinkActivated(String l) {
                    FieldDefsDisplay.this._FieldsHyperlinkActivated(l, "");
                }

                @Override
                public String getLabel(Object o) {
                    return FieldDefsDisplay.this._FieldsGetLabel(o);
                }
            });
            this.listDisplay.addHyperlinks(Messages.Leistungscodes_contactHL, Messages.Leistungscodes_textHL, Messages.GlobalActions_Redate, Messages.Leistungscodes_comboHL, Messages.Core_List_ellipsis, Messages.Leistungscodes_checkboxHL, Messages.Leistungscodes_radioHL);
            this.listDisplay.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
            if (listItems != null) {
                String[] stringArray = listItems;
                int n = listItems.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    this.listDisplay.add(item);
                    ++n2;
                }
            }
            this.listDisplay.setToolTipText(Messages.Leistungscodes_fields_tooltip);
            Composite navigator = new Composite((Composite)this, 0);
            GridLayout navGrid = new GridLayout(1, false);
            navGrid.marginWidth = 0;
            navGrid.marginHeight = 0;
            navGrid.marginTop = 0;
            navigator.setLayout((Layout)navGrid);
            navigator.setLayoutData((Object)SWTHelper.getFillGridData(1, false, 1, true));
            this.toolBar = new ToolBar(navigator, 0x800A00);
            this.toolBar.setData("listDisplay", this.listDisplay);
            this.listDisplay.setData("toolbar", this.toolBar);
            this.addToolItem(this.toolBar, Images.IMG_ARROWUP.getImage(), Messages.Leistungscodes_moveItemUp, 0, true);
            this.addToolItem(this.toolBar, Images.IMG_ARROWDOWN.getImage(), Messages.Leistungscodes_moveItemDown, 1, true);
            this.addToolItem(this.toolBar, null, Messages.Leistungscodes_moveItemDown, -1, false);
            this.addToolItem(this.toolBar, Images.IMG_REMOVEITEM.getImage(), Messages.Leistungscodes_deleteItem, 3, true);
            this.addToolItem(this.toolBar, Images.IMG_EDIT.getImage(), Messages.Leistungscodes_editItem, 4, true);
            this.addToolItem(this.toolBar, null, Messages.Leistungscodes_moveItemDown, -1, false);
            ListPopUpMenuAction moveItemUpAction = new ListPopUpMenuAction(Messages.Leistungscodes_moveItemUp, Images.IMG_ARROWUP.getImageDescriptor(), Messages.Leistungscodes_moveItemUp, 0, this.listDisplay, true);
            ListPopUpMenuAction moveItemDownAction = new ListPopUpMenuAction(Messages.Leistungscodes_moveItemDown, Images.IMG_ARROWDOWN.getImageDescriptor(), Messages.Leistungscodes_moveItemDown, 1, this.listDisplay, true);
            ListPopUpMenuAction delItemAction = new ListPopUpMenuAction(Messages.Core_Delete, Images.IMG_REMOVEITEM.getImageDescriptor(), Messages.Leistungscodes_removeConstraintTT, 3, this.listDisplay, true);
            ListPopUpMenuAction changeItemAction = new ListPopUpMenuAction(Messages.Leistungscodes_editItem, Images.IMG_EDIT.getImageDescriptor(), Messages.Leistungscodes_editItem, 4, this.listDisplay, true);
            this.actions[0] = moveItemUpAction;
            this.actions[1] = moveItemDownAction;
            this.actions[2] = null;
            this.actions[3] = delItemAction;
            this.actions[4] = changeItemAction;
            this.actions[5] = null;
            this.listDisplay.setMenu(this.actions);
            this.enableDisableItems();
            final org.eclipse.swt.widgets.List child = this.getListPart(this.listDisplay);
            if (child != null) {
                child.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        FieldDefsDisplay.this.enableDisableItems();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                child.addMouseListener(new MouseListener(){

                    public void mouseDoubleClick(MouseEvent e) {
                        String sel = FieldDefsDisplay.this.listDisplay.getSelection();
                        FieldDefsDisplay.this._FieldsHyperlinkActivated("", sel);
                    }

                    public void mouseDown(MouseEvent e) {
                        if (e.button != 1) {
                            int itemIx = e.y / child.getItemHeight() + child.getTopIndex();
                            if (itemIx >= child.getItemCount() - 1) {
                                itemIx = child.getItemCount() - 1;
                            }
                            child.setSelection(itemIx);
                        }
                        FieldDefsDisplay.this.enableDisableItems();
                    }

                    public void mouseUp(MouseEvent e) {
                    }
                });
                child.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (e.keyCode == 107) {
                            this.moveCostBearerFromExtInfoToDBRow(child);
                        }
                    }

                    private void moveCostBearerFromExtInfoToDBRow(org.eclipse.swt.widgets.List child2) {
                        String[] selection = child2.getSelection();
                        if (selection != null && selection.length == 1) {
                            String fieldName;
                            String[] fields = selection[0].split(Leistungscodes.ARGUMENTSSDELIMITER);
                            String fieldType = fields[0];
                            String string = fieldName = StringUtils.isNotBlank((CharSequence)fields[1]) ? fields[1].trim() : null;
                            if ("K".equals(fieldType.substring(0, 1)) && fieldName != null && FieldDefsDisplay.this.getData() != null) {
                                String message = MessageFormat.format("Move the selected field [{0}] to cost bearer table for billing systems [{1}]?", fieldName, FieldDefsDisplay.this.getData());
                                boolean performMove = MessageDialog.openQuestion((Shell)UiDesk.getTopShell(), (String)"Move to cost bearer table", (String)message);
                                if (performMove) {
                                    BusyIndicator.showWhile((Display)UiDesk.getDisplay(), () -> {
                                        BillingSystem.moveCostBearerFromExtinfoToDBRow((String)((String)FieldDefsDisplay.this.getData()), (String)fieldName);
                                        FieldDefsDisplay.this.deleteListItem();
                                    });
                                }
                            }
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
            }
        }

        private void addToolItem(ToolBar parent, Image image, String toolTipText, int actionType, boolean enabled) {
            if (actionType == -1) {
                ToolItem toolItem = new ToolItem(parent, 2);
                toolItem.setEnabled(false);
            } else {
                ImageRegistry imageRegistry = UiDesk.getImageRegistry();
                ToolItem toolItem = new ToolItem(parent, 8);
                toolItem.setToolTipText(toolTipText);
                toolItem.setImage(image);
                toolItem.setData("type", (Object)actionType);
                toolItem.addSelectionListener((SelectionListener)new toolBarSelectionListener());
                toolItem.setEnabled(enabled);
            }
        }

        private void enableDisableItems() {
            ToolBar toolBar = (ToolBar)this.listDisplay.getData("toolbar");
            org.eclipse.swt.widgets.List list = this.getListPart(this.listDisplay);
            Menu menu = list.getMenu();
            boolean menuHasItems = menu.getItems().length > 0;
            int selIx = list.getSelectionIndex();
            int maxIx = list.getItemCount();
            boolean enabled = false;
            if (selIx > 0) {
                enabled = true;
            }
            toolBar.getItem(0).setEnabled(enabled);
            if (menuHasItems) {
                menu.getItem(0).setEnabled(enabled);
            }
            enabled = false;
            if (selIx < maxIx - 1) {
                enabled = true;
            }
            if (selIx == -1) {
                enabled = false;
            }
            toolBar.getItem(1).setEnabled(enabled);
            if (menuHasItems) {
                menu.getItem(1).setEnabled(enabled);
            }
            enabled = true;
            if (selIx == -1) {
                enabled = false;
            }
            toolBar.getItem(3).setEnabled(enabled);
            toolBar.getItem(4).setEnabled(enabled);
            if (menuHasItems) {
                menu.getItem(3).setEnabled(enabled);
            }
            if (menuHasItems) {
                menu.getItem(4).setEnabled(enabled);
            }
        }

        private org.eclipse.swt.widgets.List getListPart(ListDisplay<String> listDisplay) {
            Control[] children = listDisplay.getChildren();
            int li = 0;
            while (li < children.length) {
                Control child = children[li];
                if (child.getClass().toString().equalsIgnoreCase("class org.eclipse.swt.widgets.List")) {
                    return (org.eclipse.swt.widgets.List)child;
                }
                ++li;
            }
            return null;
        }

        public void changeItemType() {
            if (this.listDisplay.getSelection() == null) {
                SWTHelper.alert("", Messages.Leistungscodes_mustSelectALine);
            }
        }

        public void moveListItem(int step) {
            if (this.listDisplay.getSelection() == null) {
                SWTHelper.alert("", Messages.Leistungscodes_mustSelectALine);
            } else {
                if (step == 0) {
                    return;
                }
                String sel = this.listDisplay.getSelection();
                List<String> allRequirements = this.listDisplay.getAll();
                int selIx = allRequirements.indexOf(sel);
                int listSize = allRequirements.size();
                boolean conditionOk = false;
                if (step < 0 && selIx > -step - 1) {
                    conditionOk = true;
                }
                if (step > 0 && selIx <= listSize - step) {
                    conditionOk = true;
                }
                if (conditionOk) {
                    allRequirements.set(selIx, allRequirements.get(selIx + step));
                    allRequirements.set(selIx + step, sel);
                    Object[] tmp = allRequirements.toArray();
                    int i = 0;
                    while (i < listSize) {
                        this.listDisplay.remove(allRequirements.get(0));
                        ++i;
                    }
                    i = 0;
                    while (i < tmp.length) {
                        this.listDisplay.add((String)tmp[i]);
                        ++i;
                    }
                    this.listDisplay.setSelection(selIx + step);
                }
            }
        }

        public void deleteListItem() {
            String sel = this.listDisplay.getSelection();
            if (sel == null) {
                SWTHelper.alert("", Messages.Leistungscodes_mustSelectALine);
            } else if (SWTHelper.askYesNo("", Messages.Leistungscodes_reallyWantToDeleteItem)) {
                if (this.deletedList != null && !this.deletedList.equals(this.listDisplay)) {
                    this.deletedList.add(sel);
                }
                this.listDisplay.remove(sel);
            }
        }

        public String _FieldsGetLabel(Object o) {
            String[] l = ((String)o).split(Leistungscodes.ARGUMENTSSDELIMITER);
            if (l.length > 1) {
                String opt;
                String type = Messages.Core_Date_with_colon;
                if (l[1].equals("T")) {
                    type = Messages.Leistungscodes_text;
                } else if (l[1].equals("K")) {
                    type = Messages.Leistungscodes_contact;
                } else if (l[1].equals("D")) {
                    type = Messages.Core_Date_with_colon;
                } else if (l[1].equals("TM")) {
                    type = Messages.Leistungscodes_textMultipleLines;
                } else if (l[1].equals("TS")) {
                    type = Messages.Leistungscodes_textStyled;
                } else if (l[1].equals("CS")) {
                    type = Messages.Leistungscodes_combo;
                } else if (l[1].equals("CN")) {
                    type = Messages.Leistungscodes_comboNumeric;
                } else if (l[1].equals("LS")) {
                    type = Messages.Leistungscodes_list;
                } else if (l[1].equals("LN")) {
                    type = Messages.Leistungscodes_ListNumeric;
                } else if (l[1].equals("X")) {
                    type = Messages.Leistungscodes_checkbox;
                } else if (l[1].equals("RS")) {
                    type = Messages.Leistungscodes_radiogroup;
                } else if (l[1].equals("RN")) {
                    type = Messages.Leistungscodes_radiogroupNumeric;
                }
                String string = opt = l.length >= 3 ? "   (" + l[2].replaceAll(Leistungscodes.ITEMDELIMITER, "; ") + ")" : "";
                if (opt.trim().equalsIgnoreCase("(SQL)")) {
                    opt = l.length >= 4 ? "   (SQL: " + l[3].replaceAll(Leistungscodes.ITEMDELIMITER, "; ") + ")" : "";
                    return type + " " + l[0] + opt;
                }
                return type + " " + l[0] + opt;
            }
            String opt = l.length >= 3 ? "   (" + l[2].replaceAll(Leistungscodes.ITEMDELIMITER, "; ") + ")" : "";
            return "?  " + l[0] + opt;
        }

        public void _FieldsHyperlinkActivated(String l, String fieldToBeChanged) {
            String ll = l;
            boolean isChanging = false;
            String fieldName = "";
            String fieldType = "";
            String optionsIn = "";
            boolean isNumericChecked = false;
            boolean isStyledChecked = false;
            boolean isMultilineChecked = false;
            if (ll.isEmpty()) {
                isChanging = true;
                String[] fields = fieldToBeChanged.split(Leistungscodes.ARGUMENTSSDELIMITER);
                fieldName = fields[0];
                fieldType = fields[1];
                optionsIn = fields.length > 2 ? fields[2] : "";
                optionsIn = optionsIn.replaceAll(Leistungscodes.ITEMDELIMITER, "\n");
                if (fieldType.equalsIgnoreCase("K")) {
                    ll = Messages.Leistungscodes_contactHL;
                } else if (fieldType.substring(0, 1).equalsIgnoreCase("T")) {
                    ll = Messages.Leistungscodes_textHL;
                } else if (fieldType.substring(0, 1).equalsIgnoreCase("D")) {
                    ll = Messages.GlobalActions_Redate;
                } else if (fieldType.substring(0, 1).equalsIgnoreCase("C")) {
                    ll = Messages.Leistungscodes_comboHL;
                } else if (fieldType.substring(0, 1).equalsIgnoreCase("L")) {
                    ll = Messages.Core_List_ellipsis;
                } else if (fieldType.substring(0, 1).equalsIgnoreCase("X")) {
                    ll = Messages.Leistungscodes_checkboxHL;
                } else if (fieldType.substring(0, 1).equalsIgnoreCase("R")) {
                    ll = Messages.Leistungscodes_radioHL;
                }
                if (fieldType.length() >= 2) {
                    if (fieldType.equalsIgnoreCase("TM")) {
                        isMultilineChecked = true;
                    } else if (fieldType.equalsIgnoreCase("TS")) {
                        isStyledChecked = true;
                    } else if (fieldType.substring(1, 2).equalsIgnoreCase("N")) {
                        isNumericChecked = true;
                    }
                }
            }
            String msg2 = Messages.Leistungscodes_pleaseEnterName;
            String[] changeItems = new String[]{Messages.Leistungscodes_contactHL, Messages.Leistungscodes_textHL, Messages.GlobalActions_Redate, Messages.Leistungscodes_comboHL, Messages.Core_List_ellipsis, Messages.Leistungscodes_checkboxHL, Messages.Leistungscodes_radioHL};
            AbrechnungsTypDialog_InputDialog inputDlg = new AbrechnungsTypDialog_InputDialog(this.getShell(), ll + (isChanging ? Messages.Core_doChange : Messages.Leistungscodes_add), msg2, fieldName, this.noDuplicatesListCreate, optionsIn, isNumericChecked, isStyledChecked, isMultilineChecked, (String[])(isChanging ? changeItems : null));
            if (inputDlg.open() == 0) {
                boolean hasStyled;
                String[] result = inputDlg.getResult();
                Object req = result[0];
                String options = result[1];
                ll = result[5];
                if (options.length() > 4) {
                    options.substring(0, 4).equalsIgnoreCase("SQL:");
                }
                if (options.length() > 4) {
                    options.substring(0, 4).equalsIgnoreCase("SCRIPT:");
                }
                boolean hasNumeric = !result[2].equalsIgnoreCase("0");
                boolean hasMultiline = !result[3].equalsIgnoreCase("0");
                boolean bl = hasStyled = !result[4].equalsIgnoreCase("0");
                if (ll.equalsIgnoreCase(Messages.Leistungscodes_contactHL)) {
                    req = (String)req + ":K";
                } else if (ll.equalsIgnoreCase(Messages.Leistungscodes_textHL)) {
                    req = hasStyled ? (String)req + ":TS" : (hasMultiline ? (String)req + ":TM" : (String)req + ":T");
                } else if (ll.equalsIgnoreCase(Messages.GlobalActions_Redate)) {
                    req = (String)req + ":D";
                } else if (ll.equalsIgnoreCase(Messages.Leistungscodes_comboHL)) {
                    req = hasNumeric ? (String)req + ":CN" : (String)req + ":CS";
                } else if (ll.equalsIgnoreCase(Messages.Core_List_ellipsis)) {
                    req = hasNumeric ? (String)req + ":LN" : (String)req + ":LS";
                } else if (ll.equalsIgnoreCase(Messages.Leistungscodes_checkboxHL)) {
                    req = (String)req + ":X";
                } else if (ll.equalsIgnoreCase(Messages.Leistungscodes_radioHL)) {
                    req = hasNumeric ? (String)req + ":RN" : (String)req + ":RS";
                }
                options = options.replaceAll("\r\n", Leistungscodes.ITEMDELIMITER);
                options = options.replaceAll("\n", Leistungscodes.ITEMDELIMITER).replaceAll("\r", Leistungscodes.ITEMDELIMITER);
                req = (String)req + Leistungscodes.ARGUMENTSSDELIMITER + options;
                if (isChanging) {
                    List<String> allRequirements = this.listDisplay.getAll();
                    int selIx = allRequirements.indexOf(fieldToBeChanged);
                    if (selIx >= 0) {
                        Object[] tmp = allRequirements.toArray();
                        int listSize = allRequirements.size();
                        List<String> currRequirements = this.listDisplay.getAll();
                        int i = 0;
                        while (i < listSize) {
                            this.listDisplay.remove(currRequirements.get(0));
                            ++i;
                        }
                        i = 0;
                        while (i < tmp.length) {
                            Object toBeAdded = (String)tmp[i];
                            if (i == selIx) {
                                toBeAdded = req;
                            }
                            this.listDisplay.add((String)toBeAdded);
                            ++i;
                        }
                    }
                } else {
                    this.listDisplay.add((String)req);
                }
            }
        }

        public void moveItemToOtherList(ListDisplay<String> listDisplay, ListDisplay<String> destDisplay, ListDisplay<String> ... noDuplicatesDisplays) {
            String sel = listDisplay.getSelection();
            if (sel.isEmpty()) {
                return;
            }
            ArrayList allItems = (ArrayList)((ArrayList)destDisplay.getAll()).clone();
            int li = 0;
            while (li < allItems.size()) {
                allItems.set(li, ((String)allItems.get(li)).split(Leistungscodes.ARGUMENTSSDELIMITER)[0]);
                ++li;
            }
            if (allItems.contains(sel.split(Leistungscodes.ARGUMENTSSDELIMITER)[0])) {
                SWTHelper.alert("", Messages.Leistungscodes_definitionAlreadyExistsInDestination);
                return;
            }
            ListDisplay<String>[] listDisplayArray = noDuplicatesDisplays;
            int n = noDuplicatesDisplays.length;
            int n2 = 0;
            while (n2 < n) {
                ListDisplay<String> noDuplicatesList = listDisplayArray[n2];
                ArrayList allItems2 = (ArrayList)((ArrayList)noDuplicatesList.getAll()).clone();
                int li2 = 0;
                while (li2 < allItems2.size()) {
                    allItems2.set(li2, ((String)allItems2.get(li2)).split(Leistungscodes.ARGUMENTSSDELIMITER)[0]);
                    ++li2;
                }
                if (allItems2.contains(sel.split(Leistungscodes.ARGUMENTSSDELIMITER)[0])) {
                    SWTHelper.alert("", Messages.Leistungscodes_definitionAlreadyExistsSomewhere);
                    return;
                }
                ++n2;
            }
            destDisplay.add(sel);
            listDisplay.remove(sel);
        }

        class ListPopUpMenuAction
        extends Action {
            int actionType;

            public ListPopUpMenuAction(String actionName, ImageDescriptor imageDescriptor, String toolTipText, int actionType, ListDisplay<String> listDisplay, boolean enabled) {
                super(actionName);
                this.actionType = 0;
                this.actionType = actionType;
                this.setImageDescriptor(imageDescriptor);
                this.setToolTipText(toolTipText);
                this.setEnabled(enabled);
            }

            public void run() {
                switch (this.actionType) {
                    case 0: {
                        FieldDefsDisplay.this.moveListItem(-1);
                        break;
                    }
                    case 1: {
                        FieldDefsDisplay.this.moveListItem(1);
                        break;
                    }
                    case 3: {
                        FieldDefsDisplay.this.deleteListItem();
                        break;
                    }
                    case 4: {
                        String sel = FieldDefsDisplay.this.listDisplay.getSelection();
                        FieldDefsDisplay.this._FieldsHyperlinkActivated("", sel);
                        break;
                    }
                    default: {
                        if (this.actionType <= 5) break;
                        FieldDefsDisplay.this.moveItemToOtherList(FieldDefsDisplay.this.listDisplay, FieldDefsDisplay.this.moveTo_DestinationLists.get(this.actionType - 5 - 1), FieldDefsDisplay.this.noDuplicatesList);
                    }
                }
            }
        }

        class toolBarSelectionListener
        implements SelectionListener {
            toolBarSelectionListener() {
            }

            public void widgetSelected(SelectionEvent e) {
                int type = (Integer)((ToolItem)e.getSource()).getData("type");
                switch (type) {
                    case 0: {
                        FieldDefsDisplay.this.moveListItem(-1);
                        break;
                    }
                    case 1: {
                        FieldDefsDisplay.this.moveListItem(1);
                        break;
                    }
                    case 3: {
                        FieldDefsDisplay.this.deleteListItem();
                        break;
                    }
                    case 4: {
                        String sel = FieldDefsDisplay.this.listDisplay.getSelection();
                        FieldDefsDisplay.this._FieldsHyperlinkActivated("", sel);
                        break;
                    }
                    default: {
                        if (type <= 5) break;
                        FieldDefsDisplay.this.moveItemToOtherList(FieldDefsDisplay.this.listDisplay, FieldDefsDisplay.this.moveTo_DestinationLists.get(type - 5 - 1), FieldDefsDisplay.this.noDuplicatesList);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }
    }
}

