/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.data.interfaces.ICodeElement;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.ServiceElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.dto.CodeElementDTO;
import ch.rgw.tools.StringTool;
import java.util.List;
import org.slf4j.LoggerFactory;

public class ServiceBlockElement
extends XChangeElement {
    public static final String XMLNAME = "serviceblock";
    public static final String ENCLOSING = "serviceblocks";
    public static final String ATTR_NAME = "name";

    public ServiceBlockElement asExporter(XChangeExporter p, Leistungsblock lb) {
        this.asExporter(p);
        this.setAttribute(ATTR_NAME, lb.getName());
        List ics = lb.getElementReferences();
        for (ICodeElement ic : ics) {
            if (ic instanceof IVerrechenbar) {
                IVerrechenbar iv = (IVerrechenbar)ic;
                ServiceElement se = new ServiceElement().asExporter(this.sender, iv);
                this.add(se);
                continue;
            }
            if (!(ic instanceof CodeElementDTO)) continue;
            ServiceElement se = new ServiceElement().asExporter(this.sender, (CodeElementDTO)ic);
            this.add(se);
        }
        return this;
    }

    public void doImport() {
        String name = this.getAttr(ATTR_NAME);
        if (!StringTool.isNothing((Object)name)) {
            Leistungsblock block = new Leistungsblock(name, ContextServiceHolder.getActiveMandatorOrNull().getId());
            List<? extends XChangeElement> lService = this.getChildren("service", ServiceElement.class);
            for (ServiceElement serviceElement : lService) {
                if (this.importCodeElement(block, serviceElement)) continue;
                LoggerFactory.getLogger(this.getClass()).warn("Could not import code element [" + serviceElement.getAttr("contractName") + " / " + serviceElement.getAttr("contractCode") + "]");
            }
        }
    }

    private boolean importCodeElement(Leistungsblock block, ServiceElement se) {
        String codeSystemName = se.getAttr("contractName");
        String code = se.getAttr("contractCode");
        String name = se.getAttr(ATTR_NAME);
        if (codeSystemName != null && !codeSystemName.isEmpty() && code != null && !code.isEmpty()) {
            CodeElementDTO codeElement = new CodeElementDTO(codeSystemName, code);
            if (name != null && !name.isEmpty()) {
                codeElement.setText(name);
            }
            block.addElement((ICodeElement)codeElement);
            return true;
        }
        return false;
    }

    @Override
    public String getXMLName() {
        return XMLNAME;
    }
}

