/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs.provider;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IImage;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.StickerServiceHolder;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class KontaktSelektorLabelProvider
extends DefaultLabelProvider
implements ITableColorProvider {
    @Override
    public String getText(Object element) {
        if (element instanceof Kontakt) {
            Kontakt k = (Kontakt)element;
            Object label = k.getLabel();
            if (k.istPerson()) {
                label = (String)label + " (" + k.get("Geburtsdatum") + ")";
            }
            if ("1".equals(k.get("istAnwender"))) {
                label = k.get("Bezeichnung1") + " " + k.get("Bezeichnung2") + " - " + (String)label;
            }
            if (k.istOrganisation() && StringUtils.isNotBlank((CharSequence)((String)k.getExtInfoStoredObjectByKey((Object)"allowedBillingLaw")))) {
                label = (String)label + " (" + (String)k.getExtInfoStoredObjectByKey((Object)"allowedBillingLaw") + ")";
            }
            return label;
        }
        if (element instanceof PersistentObject) {
            PersistentObject po = (PersistentObject)element;
            return po.getLabel();
        }
        return element.toString();
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        return this.getText(element);
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof Kontakt) {
            IContact pat = ((Kontakt)element).toIContact();
            ISticker sticker = StickerServiceHolder.get().getSticker((Identifiable)pat).orElse(null);
            if (sticker != null && sticker.getImage() != null) {
                return CoreUiUtil.getImageAsIcon((IImage)sticker.getImage());
            }
        }
        return super.getColumnImage(element, columnIndex);
    }

    public Color getForeground(Object element, int columnIndex) {
        if (element instanceof Kontakt) {
            IContact pat = ((Kontakt)element).toIContact();
            ISticker sticker = StickerServiceHolder.get().getSticker((Identifiable)pat).orElse(null);
            if (sticker != null && StringUtils.isNotBlank((CharSequence)sticker.getForeground())) {
                return CoreUiUtil.getColorForString((String)sticker.getForeground());
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        if (element instanceof Kontakt) {
            IContact pat = ((Kontakt)element).toIContact();
            ISticker sticker = StickerServiceHolder.get().getSticker((Identifiable)pat).orElse(null);
            if (sticker != null && StringUtils.isNotBlank((CharSequence)sticker.getBackground())) {
                return CoreUiUtil.getColorForString((String)sticker.getBackground());
            }
        }
        return null;
    }
}

