/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs.provider;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ContactSelectionLabelProvider
extends DefaultLabelProvider {
    private static DateTimeFormatter dateOfBirthFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");

    @Override
    public String getText(Object element) {
        if (element instanceof IContact) {
            IContact contact = (IContact)element;
            Object label = contact.getLabel();
            if (contact.isPerson()) {
                Optional person = CoreModelServiceHolder.get().load(contact.getId(), IPerson.class);
                String dateOfBirthString = ((IPerson)person.get()).getDateOfBirth() != null ? ((IPerson)person.get()).getDateOfBirth().format(dateOfBirthFormatter) : "?";
                label = (String)label + " (" + dateOfBirthString + ")";
            }
            if (contact.isUser()) {
                label = StringUtils.defaultString((String)contact.getDescription1()) + " " + StringUtils.defaultString((String)contact.getDescription2()) + " - " + (String)label;
            }
            return label;
        }
        if (element instanceof Identifiable) {
            return ((Identifiable)element).getLabel();
        }
        return element.toString();
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        return this.getText(element);
    }
}

