/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddMultiplikatorDialog
extends TitleAreaDialog {
    CDateTime dpc;
    Text multi;
    TimeTool begindate;
    String mult;

    public AddMultiplikatorDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(ret, 0);
        l1.setText(Messages.Core_Date);
        this.dpc = new CDateTime(ret, 34605058);
        String value = LocalDate.now().format(DateTimeFormatter.ofPattern("01.01.y"));
        this.dpc.setSelection(new TimeTool(value).getTime());
        this.dpc.setToolTipText(Messages.MultiplikatorEditor_PleaseEnterBeginDate);
        Label label = new Label(ret, 0);
        label.setText(Messages.Core_Multiplicator);
        this.multi = new Text(ret, 2048);
        this.multi.setTextLimit(6);
        this.multi.setToolTipText(Messages.MultiplikatorEditor_NewMultipilcator);
        this.multi.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.MultiplikatorEditor_BeginDate);
        this.setMessage(Messages.MultiplikatorEditor_PleaseEnterBeginDate);
        this.getShell().setText(Messages.MultiplikatorEditor_NewMultipilcator);
    }

    protected void okPressed() {
        this.begindate = new TimeTool(this.dpc.getSelection());
        this.mult = this.multi.getText();
        try {
            if (this.mult.isEmpty() || (double)Float.parseFloat(this.mult) <= 0.0) {
                SWTHelper.showError(Messages.MultiplikatorEditor_ErrorTitle, Messages.MultiplikatorEditor_ErrorMessage);
                super.cancelPressed();
            } else {
                super.okPressed();
            }
        }
        catch (Exception ex) {
            SWTHelper.showError(Messages.MultiplikatorEditor_ErrorTitle, Messages.MultiplikatorEditor_ErrorMessage);
            super.cancelPressed();
        }
    }

    public TimeTool getBegindate() {
        return this.begindate;
    }

    public String getMult() {
        return this.mult;
    }
}

