/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.services.holder.ContextServiceHolder;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.swt.program.Program;

public class OpenCompendiumHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional medication = ContextServiceHolder.get().getTyped(IPrescription.class);
        if (medication.isPresent()) {
            IArticle article = ((IPrescription)medication.get()).getArticle();
            String gtin = article.getGtin();
            if (StringUtils.isNotBlank((CharSequence)gtin)) {
                String url = "http://www.compendium.ch/prod/gtin/" + article.getGtin();
                Program.launch((String)url);
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)article.getName())) {
                String url = "http://www.compendium.ch/search/products?q=" + article.getName().trim();
                Program.launch((String)url);
                return null;
            }
        }
        String url = "http://www.compendium.ch/search/de";
        Program.launch((String)url);
        return null;
    }
}

