/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.KonsFilter;
import ch.elexis.core.ui.actions.Messages;
import ch.elexis.core.ui.actions.ObjectFilterRegistry;
import ch.elexis.data.Konsultation;
import ch.rgw.tools.VersionedResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IFilter;

public class HistoryLoader
extends BackgroundJob {
    private StringBuilder sb;
    private List<IEncounter> lKons;
    private KonsFilter filter;
    private IFilter globalFilter;
    private final int currentPage;
    private final int pageSize;
    boolean multiline = false;

    public void setFilter(KonsFilter kf) {
        this.filter = kf;
    }

    public HistoryLoader(StringBuilder sb, List<IEncounter> lKons) {
        this(sb, lKons, false);
    }

    public HistoryLoader(StringBuilder sb, List<IEncounter> lKons, boolean multiline) {
        this(sb, lKons, multiline, 0, 0);
    }

    public HistoryLoader(StringBuilder sb, List<IEncounter> paramlKons, boolean multiline, int currentPage, int pageSize) {
        super(Messages.Core_Load_Consultations);
        this.sb = sb;
        this.lKons = new ArrayList<IEncounter>(paramlKons);
        this.multiline = multiline;
        this.setPriority(50);
        this.setUser(false);
        this.currentPage = currentPage;
        this.pageSize = pageSize;
    }

    @Override
    public synchronized IStatus execute(IProgressMonitor monitor) {
        monitor.beginTask(Messages.Core_Load_Consultations, this.lKons.size() + 100);
        monitor.subTask(Messages.HistoryLoader_Sorting);
        if (this.lKons.isEmpty()) {
            return Status.OK_STATUS;
        }
        Collections.sort(this.lKons, new Comparator<IEncounter>(){

            @Override
            public int compare(IEncounter o1, IEncounter o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                int sort = o2.getDate().compareTo(o1.getDate());
                if (sort != 0) {
                    return sort;
                }
                return Long.compare(o2.getLastupdate(), o1.getLastupdate());
            }
        });
        if (this.currentPage > 0 && this.pageSize > 0) {
            int fromIdx = (this.currentPage - 1) * this.pageSize;
            int toIdx = this.currentPage * this.pageSize;
            if (toIdx > this.lKons.size()) {
                toIdx = this.lKons.size();
                fromIdx = toIdx - this.pageSize;
            }
            if (fromIdx < 0) {
                fromIdx = 0;
            }
            this.lKons = new ArrayList<IEncounter>(fromIdx < toIdx ? this.lKons.subList(fromIdx, toIdx) : this.lKons);
        } else {
            this.lKons = new ArrayList<IEncounter>(this.lKons);
        }
        monitor.worked(50);
        ICoverage selectedFall = ContextServiceHolder.get().getActiveCoverage().orElse(null);
        Iterator<IEncounter> it = this.lKons.iterator();
        this.sb.append("<form>");
        this.globalFilter = ObjectFilterRegistry.getInstance().getFilterFor(Konsultation.class);
        while (!monitor.isCanceled()) {
            if (!it.hasNext()) {
                this.sb.append("</form>");
                this.result = this.sb.toString();
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
            IEncounter k = it.next();
            if (this.filter != null && !this.filter.pass(k) || this.globalFilter != null && !this.globalFilter.select((Object)k)) continue;
            if (k != null) {
                VersionedResource vr = k.getVersionedEntry();
                String s = vr.getHead();
                if (s != null) {
                    if (s.startsWith("<")) {
                        Samdas samdas = new Samdas(s);
                        s = samdas.getRecordText();
                    }
                    s = this.maskHTML(s);
                    if (this.multiline) {
                        s = s.replaceAll("\r\n", "<br/>");
                        s = s.replaceAll("\n", "<br/>");
                    }
                } else {
                    s = "";
                }
                String label = this.maskHTML(k.getLabel());
                if (selectedFall != null && !selectedFall.equals(k.getCoverage())) {
                    this.sb.append("<p><a href=\"").append(this.maskHTML(k.getId())).append("\">").append(label).append("</a><br/>").append("<span color=\"gruen\">").append(this.maskHTML(k.getCoverage().getLabel())).append("</span><br/><span color=\"gruen\">").append(s).append("</span></p>");
                } else {
                    this.sb.append("<p><a href=\"").append(this.maskHTML(k.getId())).append("\">").append(label).append("</a><br/>").append("<span color=\"gruen\">").append(this.maskHTML(k.getCoverage().getLabel())).append("</span><br/>").append(s).append("</p>");
                }
            }
            monitor.worked(1);
        }
        this.sb.setLength(0);
        monitor.done();
        return Status.CANCEL_STATUS;
    }

    private String maskHTML(String input) {
        StringJoiner sj = new StringJoiner("\n");
        Scanner scanner = new Scanner(input);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            sj.add(StringUtils.abbreviate((String)line, (int)10000));
        }
        scanner.close();
        String safeInput = sj.toString();
        String s = safeInput.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("&", "&amp;");
        return s;
    }

    @Override
    public int getSize() {
        return this.lKons.size();
    }

    public List<IEncounter> getlKons() {
        return this.lKons;
    }
}

