/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.PersistentObjectLoader;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;

public class FlatDataLoader
extends PersistentObjectLoader
implements ILazyContentProvider {
    private List<? extends PersistentObject> filtered = null;

    public FlatDataLoader(CommonViewer cv, Query<? extends PersistentObject> qbe) {
        super(cv, qbe);
    }

    public FlatDataLoader(Query<? extends PersistentObject> qbe) {
        super(null, qbe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStatus work(IProgressMonitor monitor, HashMap<String, Object> params) {
        if (this.isSuspended()) {
            return Status.CANCEL_STATUS;
        }
        final TableViewer tv = (TableViewer)this.cv.getViewerWidget();
        FlatDataLoader flatDataLoader = this;
        synchronized (flatDataLoader) {
            this.filtered = Collections.emptyList();
            this.setQuery();
            this.applyQueryFilters();
            if (this.orderFields != null) {
                this.qbe.orderBy(false, this.orderFields);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.filtered = this.qbe.execute();
            final int itemCount = this.filtered.size();
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            UiDesk.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (tv != null && !tv.getTable().isDisposed()) {
                        tv.setItemCount(0);
                        tv.setItemCount(itemCount);
                    }
                }
            });
        }
        return Status.OK_STATUS;
    }

    protected void setQuery() {
        this.qbe.clear();
        ViewerConfigurer.ControlFieldProvider cfp = this.cv.getConfigurer().getControlFieldProvider();
        if (cfp != null) {
            cfp.setQuery((Query<? extends PersistentObject>)this.qbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateElement(int index) {
        if (this.filtered != null) {
            FlatDataLoader flatDataLoader = this;
            synchronized (flatDataLoader) {
                PersistentObject o;
                if (index >= 0 && index < this.filtered.size() && (o = this.filtered.get(index)) != null) {
                    TableViewer tv = (TableViewer)this.cv.getViewerWidget();
                    tv.replace((Object)this.filtered.get(index), index);
                }
            }
        }
    }
}

