/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.usage.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.performance.EventPerformanceStatisticHandler;
import ch.elexis.core.ui.usage.model.IStatistic;
import ch.elexis.core.ui.usage.model.ModelFactory;
import ch.elexis.core.ui.usage.model.SimpleStatistic;
import ch.elexis.core.ui.usage.model.Statistics;
import ch.rgw.tools.TimeTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.slf4j.LoggerFactory;

public enum StatisticsManager {
    INSTANCE;

    private Statistics statistics = ModelFactory.eINSTANCE.createStatistics();
    private EventPerformanceStatisticHandler eventStatisticHandler;
    private boolean disableAutoExport = false;

    public StatisticsManager getInstance() {
        return INSTANCE;
    }

    public void setEventPerformanceStatisticHandler(EventPerformanceStatisticHandler eventStatisticHandler) {
        this.eventStatisticHandler = eventStatisticHandler;
    }

    public void addCallingStatistic(String action, boolean isPerspective) {
        String type = isPerspective ? "call: perspective" : "call: view";
        IStatistic lastItem = this.findLastElementOfType(action, type);
        if (lastItem != null) {
            this.updateStastic(lastItem.getAction() + " -> " + action, isPerspective ? "switch: perspective" : "switch: view");
        }
        this.updateStastic(action, type);
    }

    public void addClosingStatistic(String action, boolean isPerpsective) {
        this.updateStastic(action, isPerpsective ? "close: perspective" : "close: view");
    }

    private void updateStastic(String action, String type) {
        Optional<IStatistic> opStastics = this.statistics.getStatistics().stream().filter(p -> p.getAction().equals(action) && p.getActionType().equals(type)).findFirst();
        if (opStastics.isPresent()) {
            opStastics.get().setValue(opStastics.get().getValue() + 1);
            opStastics.get().setTime(new Date(System.currentTimeMillis()));
        } else {
            SimpleStatistic iStatistic = ModelFactory.eINSTANCE.createSimpleStatistic();
            iStatistic.setTime(new Date());
            iStatistic.setAction(action);
            iStatistic.setActionType(type);
            iStatistic.setValue(1);
            this.statistics.getStatistics().add((Object)iStatistic);
        }
        this.statistics.setTo(new Date());
    }

    private IStatistic findLastElementOfType(String action, String type) {
        List list = this.statistics.getStatistics().stream().filter(p -> p.getActionType().equals(type) && !p.getAction().equals(action)).collect(Collectors.toList());
        list.sort((p1, p2) -> p2.getTime().compareTo(p1.getTime()));
        if (!list.isEmpty()) {
            return (IStatistic)list.get(0);
        }
        return null;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void autoExportStatistics() throws IOException {
        TimeTool t = new TimeTool(System.currentTimeMillis());
        String dir = CoreHub.getWritableUserDir().getAbsolutePath() + File.separator + "statistics";
        String fileName = "usage" + t.toString(13) + ".xml";
        if (!this.disableAutoExport) {
            try {
                File directory = new File(dir);
                if (directory.isDirectory()) {
                    Collection filesToDelete = FileUtils.listFiles((File)directory, (IOFileFilter)new AgeFileFilter(DateUtils.addDays((Date)new Date(), (int)-30)), (IOFileFilter)TrueFileFilter.TRUE);
                    for (File file : filesToDelete) {
                        boolean success = FileUtils.deleteQuietly((File)file);
                        if (success) continue;
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Cannot delete old file at: " + file.getAbsolutePath());
                    }
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Cannot delete old files.", (Throwable)e);
            }
            this.exportStatisticsToFile(dir + File.separator + fileName);
            if (this.eventStatisticHandler != null) {
                this.exportEventStatisticsToFile(dir + File.separator + "evt_" + fileName, this.eventStatisticHandler);
            }
            this.disableAutoExport = true;
        }
    }

    private void exportEventStatisticsToFile(String path, EventPerformanceStatisticHandler eventStatisticHandler) throws IOException {
        if (eventStatisticHandler != null) {
            Statistics statistics = ModelFactory.eINSTANCE.createStatistics();
            statistics.getStatistics().addAll(eventStatisticHandler.getStatistics());
            File toExport = new File(path);
            String content = this.createXMI(statistics);
            if (content != null) {
                FileUtils.writeStringToFile((File)toExport, (String)content);
            }
        }
    }

    public void exportStatisticsToFile(String path) throws IOException {
        if (this.statistics != null) {
            File toExport = new File(path);
            String content = this.createXMI(this.statistics);
            if (content != null) {
                FileUtils.writeStringToFile((File)toExport, (String)content);
            }
        }
    }

    private String createXMI(Statistics statistics) {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("xmi", new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createURI((String)"statistics.xml"));
        resource.getContents().add((Object)statistics);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            resource.save((OutputStream)os, Collections.EMPTY_MAP);
            os.flush();
            String aString = new String(os.toByteArray(), "UTF-8");
            os.close();
            return aString;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(StatisticsManager.class).error("", (Throwable)e);
            return null;
        }
    }
}

