/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.tasks.parts;

import ch.elexis.core.tasks.model.ITask;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.ui.tasks.ITaskResultDetailContributions;
import ch.elexis.core.ui.tasks.parts.TaskResultLabelProvider;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.time.LocalDateTime;
import java.util.HashMap;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TaskLogDetailPart {
    @Inject
    ITaskResultDetailContributions taskResultDetailDialogContributions;
    @Inject
    ECommandService commandService;
    @Inject
    EHandlerService handlerService;

    @PostConstruct
    public void postConstruct(Composite parent, MPart part) {
        parent.setLayout((Layout)new GridLayout(1, false));
        ITask task = (ITask)part.getTransientData().get("task");
        part.setIconURI(TaskResultLabelProvider.getInstance().getIconURI(task));
        LocalDateTime _runAt = task.getRunAt();
        String runAt = _runAt != null ? TimeUtil.formatSafe((LocalDateTime)_runAt) : "queued";
        String partLabel = task.getTaskDescriptor().getReferenceId() + " - " + runAt;
        part.setLabel(partLabel);
        HashMap<String, Object> e4Services = new HashMap<String, Object>();
        e4Services.put(ECommandService.class.getName(), this.commandService);
        e4Services.put(EHandlerService.class.getName(), this.handlerService);
        this.taskResultDetailDialogContributions.createDetailCompositeForTask(parent, task, e4Services);
    }
}

