/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.part.nattable;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.core.ui.reminder.supplier.ReminderSupplierFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.graphics.Color;

public class ReminderColumn {
    private String name;
    private String color;
    private Type type;
    private IContact contact;
    private IUserGroup group;
    private String search;
    private boolean showCompleted;

    public static List<ReminderColumn> getAllAvailable() {
        ArrayList<ReminderColumn> available = new ArrayList<ReminderColumn>();
        available.add(new ReminderColumn("Alle", "cecece", Type.ALL));
        available.add(new ReminderColumn("Meine", "acbfad", Type.USER));
        available.add(new ReminderColumn("Patient", "bfacac", Type.PATIENT));
        available.add(new ReminderColumn("Popup", "67fccd", Type.POPUP));
        CoreModelServiceHolder.get().getQuery(IUserGroup.class).execute().forEach(ug -> {
            boolean bl = available.add(new ReminderColumn((IUserGroup)ug, "84d6ed", Type.GROUP));
        });
        CoreModelServiceHolder.get().getQuery(IUser.class).and((EStructuralFeature)ModelPackage.Literals.IUSER__ACTIVE, IQuery.COMPARATOR.EQUALS, (Object)Boolean.TRUE).and((EStructuralFeature)ModelPackage.Literals.IUSER__ASSIGNED_CONTACT, IQuery.COMPARATOR.NOT_EQUALS, null).execute().forEach(u -> {
            boolean bl = available.add(new ReminderColumn((IUser)u, "e9ed84", Type.USER));
        });
        return available;
    }

    public ReminderColumn(String name, String color, Type type) {
        this.name = name;
        this.color = color;
        this.type = type;
    }

    public ReminderColumn(IUserGroup userGroup, String color, Type type) {
        this.name = userGroup.getId();
        this.group = userGroup;
        this.color = color;
        this.type = type;
    }

    public ReminderColumn(IUser user, String color, Type type) {
        this.name = user.getId();
        this.contact = user.getAssignedContact();
        if (this.contact.isMandator()) {
            Color mandatorColor = UiMandant.getColorForIMandator((IMandator)((IMandator)CoreModelServiceHolder.get().load(this.contact.getId(), IMandator.class).get()));
            this.color = Integer.toHexString(mandatorColor.getRed()) + Integer.toHexString(mandatorColor.getGreen()) + Integer.toHexString(mandatorColor.getBlue());
        } else {
            this.color = color;
        }
        this.type = type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<IReminder> loadReminders() {
        if (this.type == Type.USER) {
            if (this.contact != null) return this.loadContact(this.contact);
            Optional user = ContextServiceHolder.get().getActiveUser();
            if (!user.isPresent() || ((IUser)user.get()).getAssignedContact() == null) return Collections.emptyList();
            return this.loadContact(((IUser)user.get()).getAssignedContact());
        }
        if (this.type == Type.PATIENT) {
            Optional patient = ContextServiceHolder.get().getActivePatient();
            if (!patient.isPresent()) return Collections.emptyList();
            return this.loadPatient((IPatient)patient.get());
        }
        if (this.type == Type.ALL) {
            return this.loadAll();
        }
        if (this.type == Type.POPUP) {
            return this.loadPopup();
        }
        if (this.type != Type.GROUP) return Collections.emptyList();
        return this.loadGroup();
    }

    private List<IReminder> loadPopup() {
        Supplier<List<IReminder>> supplier = ReminderSupplierFactory.get(Type.POPUP, this.search, this.showCompleted, 100);
        return supplier.get();
    }

    private List<IReminder> loadAll() {
        Supplier<List<IReminder>> supplier = ReminderSupplierFactory.get(Type.ALL, this.search, this.showCompleted, 100);
        return supplier.get();
    }

    private List<IReminder> loadGroup() {
        Supplier<List<IReminder>> supplier = ReminderSupplierFactory.get(this.group, this.search, this.showCompleted, 100);
        return supplier.get();
    }

    private List<IReminder> loadContact(IContact contact) {
        Supplier<List<IReminder>> supplier = ReminderSupplierFactory.get(contact, this.search, this.showCompleted, 100);
        return supplier.get();
    }

    private List<IReminder> loadPatient(IPatient patient) {
        Supplier<List<IReminder>> supplier = ReminderSupplierFactory.get(patient, this.search, this.showCompleted, 100);
        return supplier.get();
    }

    public String getId() {
        return this.name + "::" + this.getType().name();
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.type == Type.USER) {
            IContact responsible = this.getResponsible();
            return this.getName() + " (" + responsible.getDescription1() + " " + responsible.getDescription2() + ")";
        }
        return this.getName();
    }

    public String getColor() {
        return this.color;
    }

    public Type getType() {
        return this.type;
    }

    public IContact getResponsible() {
        Optional user;
        if (this.contact == null && (user = ContextServiceHolder.get().getActiveUser()).isPresent() && ((IUser)user.get()).getAssignedContact() != null) {
            return ((IUser)user.get()).getAssignedContact();
        }
        return this.contact;
    }

    public IContact getPatient() {
        Optional patient;
        if (this.type == Type.PATIENT && (patient = ContextServiceHolder.get().getActivePatient()).isPresent()) {
            return (IContact)patient.get();
        }
        return null;
    }

    public IUserGroup getGroup() {
        return this.group;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReminderColumn other = (ReminderColumn)obj;
        return Objects.equals(this.name, other.name) && this.type == other.type;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public boolean hasSearch() {
        return StringUtils.isNotBlank((CharSequence)this.search);
    }

    public void setShowCompleted(Boolean value) {
        this.showCompleted = value;
    }

    public static enum Type {
        USER,
        PATIENT,
        ALL,
        POPUP,
        GROUP;

    }
}

