/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.composites;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IUser;
import ch.elexis.core.model.IUserGroup;
import ch.elexis.core.model.issue.Priority;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IUserService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.ui.e4.fieldassist.AsyncContentProposalProvider;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.proposals.IdentifiableContentProposal;
import ch.elexis.core.ui.proposals.IdentifiableProposalProvider;
import ch.elexis.core.ui.reminder.composites.BooleanExpandableComposite;
import jakarta.inject.Inject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ReminderComposite
extends Composite {
    private ComboViewer typeViewer;
    private Text subjectTxt;
    private Text msgText;
    private Text patSearchText;
    private Text userSearchText;
    private Text groupSearchText;
    private BooleanExpandableComposite dueExpandable;
    @Inject
    private IUserService userService;
    protected WritableValue<IReminder> item = new WritableValue();
    private CDateTime duePicker;
    private BooleanExpandableComposite notifyExpandable;
    private Button popupOnPatient;
    private Button popupOnLogin;
    private Button important;

    public ReminderComposite(Composite parent, int style) {
        super(parent, style);
        CoreUiUtil.injectServices((Object)((Object)this));
        this.setLayout((Layout)new GridLayout(3, false));
        Composite leftComposite = new Composite((Composite)this, 0);
        leftComposite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 300;
        leftComposite.setLayoutData((Object)gd);
        Composite middleComposite = new Composite((Composite)this, 0);
        middleComposite.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        middleComposite.setLayoutData((Object)gd);
        Composite rightComposite = new Composite((Composite)this, 0);
        rightComposite.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 300;
        rightComposite.setLayoutData((Object)gd);
        this.typeViewer = new ComboViewer(leftComposite);
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setInput((Object)Type.values());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Type) {
                    return ((Type)element).getLocaleText();
                }
                return super.getText(element);
            }
        });
        this.typeViewer.getControl().setLayoutData((Object)new GridData(4, 128, true, false));
        Composite patSearchComposite = new Composite(leftComposite, 0);
        patSearchComposite.setLayout((Layout)new GridLayout(2, false));
        patSearchComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.patSearchText = new Text(patSearchComposite, 640);
        this.patSearchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.patSearchText.setMessage("Patient");
        AsyncContentProposalProvider<IPatient> aopp = new AsyncContentProposalProvider<IPatient>(new String[]{"description1", "description2", "dob", "code"}){

            public IQuery<IPatient> createBaseQuery() {
                return CoreModelServiceHolder.get().getQuery(IPatient.class);
            }

            protected boolean isPatientQuery() {
                return true;
            }

            public Text getWidget() {
                return ReminderComposite.this.patSearchText;
            }
        };
        this.patSearchText.setData(null);
        this.patSearchText.setTextLimit(80);
        ContentProposalAdapter cppa = new ContentProposalAdapter((Control)this.patSearchText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)aopp, null, null);
        aopp.configureContentProposalAdapter(cppa);
        cppa.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                ch.elexis.core.ui.e4.fieldassist.IdentifiableContentProposal prop = (ch.elexis.core.ui.e4.fieldassist.IdentifiableContentProposal)proposal;
                ReminderComposite.this.patSearchText.setText(prop.getLabel());
                ReminderComposite.this.patSearchText.setData(prop.getIdentifiable());
                ((IReminder)ReminderComposite.this.item.getValue()).setContact((IContact)prop.getIdentifiable());
            }
        });
        ToolBarManager tbManager = new ToolBarManager(8388928);
        tbManager.add((IAction)new Action(){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                ((IReminder)ReminderComposite.this.item.getValue()).setContact(null);
                ReminderComposite.this.updatePatientField();
            }
        });
        tbManager.createControl(patSearchComposite);
        Composite userSearchComposite = new Composite(leftComposite, 0);
        userSearchComposite.setLayout((Layout)new GridLayout(2, false));
        userSearchComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.userSearchText = new Text(userSearchComposite, 640);
        this.userSearchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.userSearchText.setMessage("Zugewiesen User");
        IdentifiableProposalProvider<IUser> userProposalProvider = new IdentifiableProposalProvider<IUser>(CoreModelServiceHolder.get().getQuery(IUser.class).and("kontakt", IQuery.COMPARATOR.NOT_EQUALS, null).and("active", IQuery.COMPARATOR.EQUALS, (Object)true)){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<IContentProposal> list = new ArrayList<IContentProposal>(Arrays.asList(super.getProposals(contents, position)));
                Collections.sort(list, (l, r) -> {
                    IdentifiableContentProposal lip = (IdentifiableContentProposal)l;
                    IdentifiableContentProposal rip = (IdentifiableContentProposal)r;
                    if (((IUser)lip.getIdentifiable()).getId().startsWith(contents) && !((IUser)rip.getIdentifiable()).getId().startsWith(contents)) {
                        return -1;
                    }
                    if (((IUser)rip.getIdentifiable()).getId().startsWith(contents) && !((IUser)lip.getIdentifiable()).getId().startsWith(contents)) {
                        return 1;
                    }
                    return ((IUser)lip.getIdentifiable()).getId().compareTo(((IUser)rip.getIdentifiable()).getId());
                });
                if (Messages.Core_All.toLowerCase().contains(contents.toLowerCase()) || StringUtils.isBlank((CharSequence)contents)) {
                    list.add(0, (IContentProposal)new ContentProposal(Messages.Core_All));
                }
                return list.toArray(new IContentProposal[list.size()]);
            }

            public String getLabelForObject(IUser user) {
                return ReminderComposite.this.getUserLabel(user);
            }
        };
        userProposalProvider.allowNoContent();
        userProposalProvider.matchContained();
        this.userSearchText.setData(null);
        this.userSearchText.setTextLimit(80);
        final ContentProposalAdapter cppau = new ContentProposalAdapter((Control)this.userSearchText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)userProposalProvider, null, null);
        this.userSearchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    cppau.openProposalPopup();
                }
            }
        });
        cppau.setAutoActivationDelay(250);
        cppau.setProposalAcceptanceStyle(2);
        cppau.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                if (proposal instanceof IdentifiableContentProposal) {
                    IdentifiableContentProposal prop = (IdentifiableContentProposal)proposal;
                    ((IReminder)ReminderComposite.this.item.getValue()).setGroup(null);
                    ((IReminder)ReminderComposite.this.item.getValue()).getResponsible().forEach(c -> ((IReminder)ReminderComposite.this.item.getValue()).removeResponsible(c));
                    ((IReminder)ReminderComposite.this.item.getValue()).addResponsible(((IUser)prop.getIdentifiable()).getAssignedContact());
                    ((IReminder)ReminderComposite.this.item.getValue()).setResponsibleAll(false);
                    ReminderComposite.this.updateUserResponsibleFields();
                } else {
                    ((IReminder)ReminderComposite.this.item.getValue()).setGroup(null);
                    ((IReminder)ReminderComposite.this.item.getValue()).setResponsibleAll(true);
                    ((IReminder)ReminderComposite.this.item.getValue()).getResponsible().forEach(c -> ((IReminder)ReminderComposite.this.item.getValue()).removeResponsible(c));
                    ReminderComposite.this.updateUserResponsibleFields();
                }
            }
        });
        Composite groupSearchComposite = new Composite(leftComposite, 0);
        groupSearchComposite.setLayout((Layout)new GridLayout(2, false));
        groupSearchComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.groupSearchText = new Text(groupSearchComposite, 640);
        this.groupSearchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.groupSearchText.setMessage("Zugewiesen Gruppe");
        IdentifiableProposalProvider groupProposalProvider = new IdentifiableProposalProvider(CoreModelServiceHolder.get().getQuery(IUserGroup.class));
        groupProposalProvider.allowNoContent();
        this.groupSearchText.setData(null);
        this.groupSearchText.setTextLimit(80);
        final ContentProposalAdapter cppag = new ContentProposalAdapter((Control)this.groupSearchText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)groupProposalProvider, null, null);
        this.groupSearchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    cppag.openProposalPopup();
                }
            }
        });
        cppag.setAutoActivationDelay(250);
        cppag.setProposalAcceptanceStyle(2);
        cppag.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                if (proposal instanceof IdentifiableContentProposal) {
                    IdentifiableContentProposal prop = (IdentifiableContentProposal)proposal;
                    ((IReminder)ReminderComposite.this.item.getValue()).getResponsible().forEach(c -> ((IReminder)ReminderComposite.this.item.getValue()).removeResponsible(c));
                    ((IReminder)ReminderComposite.this.item.getValue()).setResponsibleAll(false);
                    ((IReminder)ReminderComposite.this.item.getValue()).setGroup((IUserGroup)prop.getIdentifiable());
                    ReminderComposite.this.updateGroupResponsibleFields();
                }
            }
        });
        this.subjectTxt = new Text(middleComposite, 2048);
        this.subjectTxt.setMessage("Titel");
        gd = new GridData(4, 128, true, false);
        gd.widthHint = 400;
        this.subjectTxt.setLayoutData((Object)gd);
        this.msgText = new Text(middleComposite, 2114);
        this.msgText.setMessage("Beschreibung");
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 400;
        this.msgText.setLayoutData((Object)gd);
        this.dueExpandable = new BooleanExpandableComposite(rightComposite, 0);
        this.dueExpandable.setLayoutData(new GridData(4, 128, true, false));
        this.dueExpandable.setMessage("F\u00e4lligkeit");
        this.dueExpandable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReminderComposite.this.dueExpandable.getSelection()) {
                    ((IReminder)ReminderComposite.this.item.getValue()).setDue(LocalDate.now());
                    ReminderComposite.this.duePicker.setSelection(TimeUtil.toDate((LocalDate)LocalDate.now()));
                    ReminderComposite.this.dueExpandable.setExpanded(true);
                } else {
                    ((IReminder)ReminderComposite.this.item.getValue()).setDue(null);
                    ReminderComposite.this.dueExpandable.setExpanded(false);
                }
            }
        });
        this.dueExpandable.onExpand(() -> this.duePicker.setSelection(((IReminder)this.item.getValue()).getDue() != null ? TimeUtil.toDate((LocalDate)((IReminder)this.item.getValue()).getDue()) : null));
        this.duePicker = new CDateTime((Composite)this.dueExpandable, 5);
        this.duePicker.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.duePicker.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IReminder)ReminderComposite.this.item.getValue()).setDue(TimeUtil.toLocalDate((Date)ReminderComposite.this.duePicker.getSelection()));
            }
        });
        this.dueExpandable.setExpanded(false);
        this.notifyExpandable = new BooleanExpandableComposite(rightComposite, 0);
        this.notifyExpandable.setLayoutData(new GridData(4, 128, true, false, 2, 1));
        this.notifyExpandable.setMessage("Erinnerung");
        this.notifyExpandable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReminderComposite.this.notifyExpandable.getSelection()) {
                    if (((IReminder)ReminderComposite.this.item.getValue()).getContact() != null && ((IReminder)ReminderComposite.this.item.getValue()).getContact().isPatient()) {
                        ((IReminder)ReminderComposite.this.item.getValue()).setVisibility(Visibility.POPUP_ON_PATIENT_SELECTION);
                        ReminderComposite.this.popupOnPatient.setSelection(true);
                    }
                    ReminderComposite.this.notifyExpandable.setExpanded(true);
                } else {
                    ((IReminder)ReminderComposite.this.item.getValue()).setVisibility(Visibility.ALWAYS);
                    ReminderComposite.this.notifyExpandable.setExpanded(false);
                }
            }
        });
        this.notifyExpandable.onExpand(() -> {
            this.popupOnPatient.setSelection(((IReminder)this.item.getValue()).getVisibility() == Visibility.POPUP_ON_PATIENT_SELECTION);
            this.popupOnLogin.setSelection(((IReminder)this.item.getValue()).getVisibility() == Visibility.POPUP_ON_LOGIN);
        });
        this.popupOnPatient = new Button((Composite)this.notifyExpandable, 32);
        this.popupOnPatient.setText("Bei Patientenauswahl");
        this.popupOnPatient.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.popupOnPatient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IReminder)ReminderComposite.this.item.getValue()).setVisibility(Visibility.POPUP_ON_PATIENT_SELECTION);
                ReminderComposite.this.popupOnLogin.setSelection(false);
            }
        });
        this.popupOnLogin = new Button((Composite)this.notifyExpandable, 32);
        this.popupOnLogin.setText("Bei Login");
        this.popupOnLogin.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.popupOnLogin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IReminder)ReminderComposite.this.item.getValue()).setVisibility(Visibility.POPUP_ON_LOGIN);
                ReminderComposite.this.popupOnPatient.setSelection(false);
            }
        });
        this.notifyExpandable.setExpanded(false);
        Label separator = new Label(rightComposite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.important = new Button(rightComposite, 32);
        this.important.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.important.setText("Wichtig");
        this.important.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReminderComposite.this.important.getSelection()) {
                    ((IReminder)ReminderComposite.this.item.getValue()).setPriority(Priority.HIGH);
                } else {
                    ((IReminder)ReminderComposite.this.item.getValue()).setPriority(Priority.MEDIUM);
                }
            }
        });
        this.initDataBindings();
    }

    public void setReminder(IReminder reminder) {
        this.item.setValue((Object)reminder);
        this.updatePatientField();
        this.updateUserResponsibleFields();
        this.updateGroupResponsibleFields();
        this.dueExpandable.setSelection(reminder.getDue() != null);
        this.dueExpandable.setExpanded(reminder.getDue() != null);
        this.notifyExpandable.setSelection(reminder.getVisibility() == Visibility.POPUP_ON_PATIENT_SELECTION || reminder.getVisibility() == Visibility.POPUP_ON_LOGIN);
        this.important.setSelection(reminder.getPriority() == Priority.HIGH);
    }

    private void updatePatientField() {
        IContact patient = this.reloadAsPatient(((IReminder)this.item.getValue()).getContact());
        if (patient != null) {
            this.patSearchText.setText(patient.getLabel());
            this.patSearchText.setData((Object)patient);
        } else {
            this.patSearchText.setText("");
            this.patSearchText.setData(null);
        }
    }

    private String getUserLabel(IUser user) {
        StringBuilder sb = new StringBuilder(user.getLabel());
        if (user.getAssignedContact() != null) {
            sb.append(" (" + user.getAssignedContact().getDescription1() + " " + user.getAssignedContact().getDescription2() + ")");
        }
        return sb.toString();
    }

    private void updateGroupResponsibleFields() {
        IReminder reminder = (IReminder)this.item.getValue();
        if (reminder.getGroup() != null) {
            this.groupSearchText.setText(reminder.getGroup().getLabel());
            this.groupSearchText.setData((Object)reminder.getGroup());
        } else {
            this.groupSearchText.setText("");
            this.groupSearchText.setData(null);
        }
    }

    private void updateUserResponsibleFields() {
        IReminder reminder = (IReminder)this.item.getValue();
        if (reminder.getResponsible() != null && !reminder.getResponsible().isEmpty()) {
            List user = this.userService.getUsersByAssociatedContact((IContact)reminder.getResponsible().get(0));
            if (!user.isEmpty()) {
                this.userSearchText.setText(this.getUserLabel((IUser)user.get(0)));
                this.userSearchText.setData(user.get(0));
            }
        } else if (reminder.isResponsibleAll()) {
            this.userSearchText.setText(Messages.Core_All);
            this.userSearchText.setData((Object)Messages.Core_All);
        } else if (reminder.getResponsible() == null || reminder.getResponsible().isEmpty()) {
            this.userSearchText.setText("");
            this.userSearchText.setData(null);
        }
    }

    private IContact reloadAsPatient(IContact contact) {
        if (contact != null && contact.isPatient()) {
            return CoreModelServiceHolder.get().load(contact.getId(), IPatient.class).orElse(null);
        }
        return null;
    }

    public IReminder getReminder() {
        return (IReminder)this.item.getValue();
    }

    protected void initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue targetObservable = ViewerProperties.singleSelection().observe((Viewer)this.typeViewer);
        IObservableValue modelObservable = PojoProperties.value(IReminder.class, (String)"type").observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)targetObservable, modelObservable);
        ISWTObservableValue target = WidgetProperties.text((int)24).observeDelayed(500, (Widget)this.subjectTxt);
        IObservableValue model = PojoProperties.value(IReminder.class, (String)"subject").observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)target, model, null, null);
        target = WidgetProperties.text((int)24).observeDelayed(500, (Widget)this.msgText);
        model = PojoProperties.value(IReminder.class, (String)"message").observeDetail(this.item);
        bindingContext.bindValue((IObservableValue)target, model, null, null);
    }

    public void dispose() {
        CoreUiUtil.uninjectServices((Object)((Object)this));
        super.dispose();
    }
}

