/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.mediorder.internal.handler;

import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.ui.mediorder.MediorderCanExecuteUtil;
import ch.elexis.core.ui.mediorder.MediorderPart;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;

public class CloseMediorderHandler {
    @Inject
    @Service(filterExpression="(service.model.name=ch.elexis.core.model)")
    IModelService coreModelService;
    @Inject
    ICoverageService coverageService;

    @CanExecute
    public boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") IStock stock) {
        return MediorderCanExecuteUtil.canExecute(stock.getStockEntries(), this.coverageService);
    }

    @Execute
    public void execute(MPart part) {
        MediorderPart mediOrderPart = (MediorderPart)part.getObject();
        for (IStock stock : mediOrderPart.getSelectedStocks()) {
            for (IStockEntry entry : stock.getStockEntries()) {
                this.coreModelService.remove((Identifiable)entry);
            }
        }
        mediOrderPart.refresh();
    }
}

