/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.billing;

import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.IBilledAdjuster;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.processor.BillingProcessor;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.osgi.service.component.annotations.Component;

@Component
public class PrescriptionBilledAdjuster
implements IBilledAdjuster {
    private BillingProcessor billingProcessor;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public void adjust(final IBilled billed) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                IBillable billable = billed.getBillable();
                PrescriptionBilledAdjuster.this.billingProcessor = new BillingProcessor(billed.getEncounter());
                if (billable instanceof IArticle) {
                    IArticle article = (IArticle)billable;
                    Optional<IPatient> patientOpt = PrescriptionBilledAdjuster.this.getPatient(billed);
                    Optional articleStoreToString = StoreToStringServiceHolder.get().storeToString((Identifiable)article);
                    if (patientOpt.isPresent() && articleStoreToString.isPresent()) {
                        PrescriptionBilledAdjuster.this.createDispensationPrescription(article, patientOpt.get(), billed);
                        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IPrescription.class);
                    }
                }
                PrescriptionBilledAdjuster.this.billingProcessor.updatePrescriptionsWithDosage(billed);
            }
        });
    }

    private Optional<IPatient> getPatient(IBilled billed) {
        ICoverage coverage;
        IEncounter encounter = billed.getEncounter();
        if (encounter != null && (coverage = encounter.getCoverage()) != null) {
            return Optional.of(coverage.getPatient());
        }
        return Optional.empty();
    }

    private IPrescription createDispensationPrescription(IArticle article, IPatient patient, IBilled billed) {
        IPrescription prescription = (IPrescription)new IPrescriptionBuilder(CoreModelServiceHolder.get(), ContextServiceHolder.get(), article, patient, "").build();
        prescription.setExtInfo((Object)"verrechnetId", (Object)billed.getId());
        billed.setExtInfo((Object)"prescriptionId", (Object)prescription.getId());
        prescription.setEntryType(EntryType.SELF_DISPENSED);
        prescription.setDateFrom(billed.getEncounter().getDate().atStartOfDay());
        CoreModelServiceHolder.get().save((Identifiable)prescription);
        return prescription;
    }
}

