/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.preferences;

import ch.elexis.core.ac.EvACE;
import ch.elexis.core.ac.EvaluatableACE;
import ch.elexis.core.ac.Right;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabMapping;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.laboratory.commands.EditLabItemUi;
import ch.elexis.core.ui.laboratory.dialogs.LabItemViewerFilter;
import ch.elexis.core.ui.laboratory.preferences.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class LaborPrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer tableViewer;
    private Table table;
    int sortC = 1;
    private String[] headers = new String[]{Messages.Core_Name, Messages.Core_Short_Label, "LOINC", Messages.Core_Type, Messages.Core_Unit, Messages.Core_Reference_Male, Messages.Core_Reference_female, Messages.Core_Sortmode};
    private int[] colwidth = new int[]{16, 6, 6, 6, 6, 16, 16, 16};
    private LabItemViewerFilter viewerFilter;

    public LaborPrefs() {
        super(Messages.LaborPrefs_labTitle);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        LabListLabelProvider labListLabelProvider = new LabListLabelProvider();
        this.viewerFilter = new LabItemViewerFilter((ILabelProvider)labListLabelProvider);
        Text filterTxt = new Text(parent, 896);
        filterTxt.setMessage("filter");
        filterTxt.addModifyListener(e -> {
            if (filterTxt.getText().length() > 1) {
                this.viewerFilter.setSearchText(filterTxt.getText());
                this.tableViewer.refresh();
            } else {
                this.viewerFilter.setSearchText("");
                this.tableViewer.refresh();
            }
        });
        filterTxt.setLayoutData((Object)new GridData(4, 2, true, false));
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData());
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(tableComposite, 0x10010800);
        this.table = this.tableViewer.getTable();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labListLabelProvider);
        this.tableViewer.addFilter((ViewerFilter)this.viewerFilter);
        int i = 0;
        while (i < this.headers.length) {
            TableColumn tc = new TableColumn(this.table, 16384);
            tc.setText(this.headers[i]);
            tableColumnLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(this.colwidth[i], true));
            tc.setData((Object)i);
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LaborPrefs.this.sortC = (Integer)((TableColumn)e.getSource()).getData();
                    LaborPrefs.this.tableViewer.refresh(true);
                }
            });
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = LaborPrefs.this.tableViewer.getStructuredSelection();
                Object o = sel.getFirstElement();
                if (o instanceof ILabItem) {
                    ILabItem li = (ILabItem)o;
                    EditLabItemUi.executeWithParams((Identifiable)li);
                    CoreModelServiceHolder.get().refresh((Identifiable)li, true);
                    LaborPrefs.this.tableViewer.refresh();
                }
            }
        });
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ILabItem li1 = (ILabItem)e1;
                ILabItem li2 = (ILabItem)e2;
                String s1 = "";
                String s2 = "";
                switch (LaborPrefs.this.sortC) {
                    case 1: {
                        s1 = li1.getCode();
                        s2 = li2.getCode();
                        break;
                    }
                    case 3: {
                        s1 = li1.getTyp().toString();
                        s2 = li2.getTyp().toString();
                        break;
                    }
                    case 7: {
                        s1 = li1.getGroup();
                        s2 = li2.getGroup();
                        break;
                    }
                    default: {
                        s1 = li1.getName();
                        s2 = li2.getName();
                    }
                }
                int res = s1.compareToIgnoreCase(s2);
                if (res == 0) {
                    try {
                        Integer no1 = Integer.parseInt(li1.getPriority());
                        Integer no2 = Integer.parseInt(li2.getPriority());
                        return no1.compareTo(no2);
                    }
                    catch (NumberFormatException nfe) {
                        return li1.getPriority().compareToIgnoreCase(li2.getPriority());
                    }
                }
                return res;
            }
        });
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        this.tableViewer.addDragSupport(operations, transferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)LaborPrefs.this.tableViewer.getSelection();
                ILabItem labItem = (ILabItem)selection.getFirstElement();
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = labItem.getCode() + "," + labItem.getName() + "," + labItem.getId();
                }
            }
        });
        this.reload();
        return tableComposite;
    }

    private void reload() {
        CompletableFuture.runAsync(() -> {
            List allLabItems = CoreModelServiceHolder.get().getQuery(ILabItem.class).execute();
            Display.getDefault().asyncExec(() -> this.tableViewer.setInput((Object)allLabItems));
        });
    }

    protected void contributeButtons(Composite parent) {
        Button bImportMapping;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bMappingFrom2_1_7 = new Button(parent, 8);
        bMappingFrom2_1_7.setText(Messages.LaborPrefs_mappingFrom2_1_7);
        bMappingFrom2_1_7.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                    handlerService.executeCommand("ch.elexis.mapping.2_1_7.create", null);
                }
                catch (Exception ex) {
                    throw new RuntimeException("ch.elexis.mapping.2_1_7.create", ex);
                }
                LaborPrefs.this.tableViewer.refresh();
            }
        });
        if (AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(ILabItem.class, (Right)Right.UPDATE))) {
            ++((GridLayout)parent.getLayout()).numColumns;
            bImportMapping = new Button(parent, 8);
            bImportMapping.setText(Messages.LaborPrefs_mergeLabItems);
            bImportMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                        handlerService.executeCommand("ch.elexis.labitem.merge", null);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("ch.elexis.labitem.merge", ex);
                    }
                    LaborPrefs.this.tableViewer.refresh();
                }
            });
        }
        ++((GridLayout)parent.getLayout()).numColumns;
        bImportMapping = new Button(parent, 8);
        bImportMapping.setText(Messages.LaborPrefs_importLabMapping);
        bImportMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                    handlerService.executeCommand("ch.elexis.labmapping.import", null);
                }
                catch (Exception ex) {
                    throw new RuntimeException("ch.elexis.labmapping.import", ex);
                }
                LaborPrefs.this.tableViewer.refresh();
            }
        });
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bNewItem = new Button(parent, 8);
        bNewItem.setText(Messages.LaborPrefs_labValue);
        bNewItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                    handlerService.executeCommand("ch.elexis.labitem.create", null);
                }
                catch (Exception ex) {
                    throw new RuntimeException("ch.elexis.labitem.create", ex);
                }
                LaborPrefs.this.reload();
            }
        });
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bDelItem = new Button(parent, 8);
        bDelItem.setText(Messages.LaborPrefs_deleteItem);
        bDelItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)LaborPrefs.this.tableViewer.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof ILabItem) {
                    ILabItem li = (ILabItem)o;
                    if (MessageDialog.openQuestion((Shell)LaborPrefs.this.getShell(), (String)Messages.LaborPrefs_deleteItem, (String)MessageFormat.format(Messages.LaborPrefs_deleteReallyItem, li.getLabel()))) {
                        if (LaborPrefs.this.deleteResults(li)) {
                            LaborPrefs.this.deleteMappings(li);
                            CoreModelServiceHolder.get().delete((Deleteable)li);
                            LaborPrefs.this.tableViewer.remove((Object)li);
                        } else {
                            MessageDialog.openWarning((Shell)LaborPrefs.this.getShell(), (String)Messages.LaborPrefs_deleteItem, (String)Messages.LaborPrefs_deleteFail);
                        }
                    }
                }
            }
        });
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bDelAllItems = new Button(parent, 8);
        bDelAllItems.setText(Messages.LaborPrefs_deleteAllItems);
        bDelAllItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SWTHelper.askYesNo((String)Messages.LaborPrefs_deleteReallyAllItems, (String)Messages.LaborPrefs_deleteAllExplain)) {
                    List items = CoreModelServiceHolder.get().getQuery(ILabItem.class).execute();
                    boolean success = true;
                    for (ILabItem li : items) {
                        if (LaborPrefs.this.deleteResults(li)) {
                            LaborPrefs.this.deleteMappings(li);
                            CoreModelServiceHolder.get().delete((Deleteable)li);
                            continue;
                        }
                        success = false;
                    }
                    if (!success) {
                        MessageDialog.openWarning((Shell)LaborPrefs.this.getShell(), (String)Messages.LaborPrefs_deleteAllItems, (String)Messages.LaborPrefs_deleteFail);
                    }
                    LaborPrefs.this.tableViewer.refresh();
                }
            }
        });
        if (!AccessControlServiceHolder.get().evaluate((EvaluatableACE)EvACE.of(ILabItem.class, (Right)Right.DELETE))) {
            bDelAllItems.setEnabled(false);
        }
    }

    private boolean deleteResults(ILabItem li) {
        boolean ret = true;
        List list = CoreModelServiceHolder.get().getQuery(ILabResult.class).and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__ITEM, IQuery.COMPARATOR.EQUALS, (Object)li).execute();
        for (ILabResult lr : list) {
            if (LocalLockServiceHolder.get().acquireLock((Object)lr).isOk()) {
                CoreModelServiceHolder.get().delete((Deleteable)lr);
                LocalLockServiceHolder.get().releaseLock((Object)lr);
                continue;
            }
            ret = false;
        }
        return ret;
    }

    private void deleteMappings(ILabItem li) {
        List list = CoreModelServiceHolder.get().getQuery(ILabMapping.class).and((EStructuralFeature)ModelPackage.Literals.ILAB_MAPPING__ITEM, IQuery.COMPARATOR.EQUALS, (Object)li).execute();
        for (ILabMapping lm : list) {
            CoreModelServiceHolder.get().delete((Deleteable)lm);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public Point computeSize() {
        return new Point(350, 350);
    }

    static class LabListLabelProvider
    extends ColumnLabelProvider
    implements ITableLabelProvider {
        LabListLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ILabItem li = (ILabItem)element;
            switch (columnIndex) {
                case 0: {
                    return li.getName();
                }
                case 1: {
                    return li.getCode();
                }
                case 2: {
                    return li.getLoincCode();
                }
                case 3: {
                    LabItemTyp typ = li.getTyp();
                    if (typ == LabItemTyp.NUMERIC) {
                        return Messages.Core_Number;
                    }
                    if (typ == LabItemTyp.TEXT) {
                        return Messages.Core_Text;
                    }
                    if (typ == LabItemTyp.FORMULA) {
                        return Messages.Core_Formula;
                    }
                    if (typ == LabItemTyp.DOCUMENT) {
                        return Messages.Core_Document;
                    }
                    return Messages.Core_Absolute;
                }
                case 4: {
                    return li.getUnit();
                }
                case 5: {
                    return li.getReferenceMale();
                }
                case 6: {
                    return li.getReferenceFemale();
                }
                case 7: {
                    return li.getGroup() + " - " + li.getPriority();
                }
            }
            return "?col?";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element) {
            ILabItem li = (ILabItem)element;
            if (li.isVisible()) {
                return Display.getCurrent().getSystemColor(1);
            }
            return Display.getCurrent().getSystemColor(15);
        }
    }
}

