/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls.util;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.ILabItem;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.dialogs.DisplayLabDokumenteDialog;
import ch.elexis.core.ui.dialogs.DisplayTextDialog;
import ch.elexis.core.ui.laboratory.controls.LaborResultsComposite;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.graphics.Font;

public class DisplayDoubleClickListener
implements IDoubleClickListener {
    private static Font dialogFont = null;
    private LaborResultsComposite composite;

    public DisplayDoubleClickListener(LaborResultsComposite composite) {
        this.composite = composite;
    }

    public void doubleClick(DoubleClickEvent event) {
        List<LabResult> results = this.composite.getSelectedResults();
        if (results != null && !results.isEmpty()) {
            LabResult firstResult = results.get(0);
            if (firstResult.getItem().getTyp().equals((Object)LabItemTyp.DOCUMENT)) {
                this.openDisplayDialog(firstResult);
            } else {
                for (LabResult labResult : results) {
                    this.openDisplayDialog(labResult);
                }
            }
        }
    }

    private void openDisplayDialog(LabResult labResult) {
        Patient patient;
        ILabItem labItem = labResult.getItem();
        if (labItem.getTyp().equals((Object)LabItemTyp.TEXT) || labResult.getComment().length() > 0) {
            DisplayTextDialog dlg;
            block9: {
                dlg = new DisplayTextDialog(this.composite.getShell(), Messages.Core_Textresult, labItem.getName(), labResult.getComment());
                try {
                    try {
                        if (dialogFont == null) {
                            dialogFont = new Font(null, "Courier New", 11, 0);
                        }
                    }
                    catch (Exception exception) {
                        dlg.setFont(dialogFont);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    dlg.setFont(dialogFont);
                    throw throwable;
                }
                dlg.setFont(dialogFont);
            }
            dlg.setWhitespaceNormalized(Boolean.valueOf(false));
            dlg.open();
        } else if (labItem.getTyp().equals((Object)LabItemTyp.DOCUMENT) && (patient = ElexisEventDispatcher.getSelectedPatient()) != null) {
            new DisplayLabDokumenteDialog(this.composite.getShell(), Messages.Core_Laboratory_Document, Collections.singletonList(labResult)).open();
        }
    }
}

