/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls;

import ch.elexis.core.ui.laboratory.controls.model.LaborItemResults;
import ch.elexis.core.ui.laboratory.controls.util.LaborItemResultsComparator;
import ch.elexis.data.LabResult;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class LaborResultsContentProvider
implements ITreeContentProvider {
    private HashMap<String, HashMap<String, HashMap<String, List<LabResult>>>> grouped;
    private ArrayList<String> groups = new ArrayList();
    private HashMap<String, LaborItemResults> itemResults = new HashMap();
    private HashSet<String> dates = new HashSet();

    LaborResultsContentProvider() {
    }

    public List<TimeTool> getDates() {
        ArrayList<TimeTool> ret = new ArrayList<TimeTool>();
        for (String date : this.dates) {
            ret.add(new TimeTool(date));
        }
        Collections.sort(ret);
        return ret;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof HashMap) {
            this.grouped = (HashMap)newInput;
            this.updateItemResults();
        }
    }

    private void updateItemResults() {
        this.groups.clear();
        this.itemResults.clear();
        this.dates.clear();
        for (String group : this.grouped.keySet()) {
            HashMap<String, HashMap<String, List<LabResult>>> itemMap = this.grouped.get(group);
            for (String item : itemMap.keySet()) {
                LaborItemResults results = new LaborItemResults(item, itemMap.get(item));
                if (!results.isVisible()) continue;
                this.itemResults.put(group + "::" + item, results);
                this.dates.addAll(results.getDays());
            }
        }
        this.groups.addAll(this.grouped.keySet());
        Collections.sort(this.groups);
    }

    public Object[] getElements(Object inputElement) {
        return this.groups.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof String) {
            HashMap<String, HashMap<String, List<LabResult>>> itemMap = this.grouped.get(parentElement);
            ArrayList<LaborItemResults> ret = new ArrayList<LaborItemResults>();
            for (String item : itemMap.keySet()) {
                if (this.itemResults.get(String.valueOf(parentElement) + "::" + item) == null) continue;
                ret.add(this.itemResults.get(String.valueOf(parentElement) + "::" + item));
            }
            Collections.sort(ret, new LaborItemResultsComparator());
            return ret.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof String) {
            return this.grouped.get(element) != null && !this.grouped.get(element).isEmpty();
        }
        return false;
    }
}

